/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.DiskSchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyDiskSchemaManager
implements IDiskSchemaManager {
    private static final String FILE_NAME = "SeriesKeyMapping.meta";
    private static final String FILE_VERSION = "AppendOnly_V1";
    File dataFile;
    FileOutputStream outputStream;
    RandomAccessFile randomAccessFile;
    long loc;
    private static final Logger logger = LoggerFactory.getLogger(AppendOnlyDiskSchemaManager.class);

    public AppendOnlyDiskSchemaManager(File dir) {
        try {
            this.initFile(dir);
            this.outputStream = new FileOutputStream(this.dataFile, true);
            this.randomAccessFile = new RandomAccessFile(this.dataFile, "rw");
            if (this.loc == 0L) {
                ReadWriteIOUtils.write((String)FILE_VERSION, (OutputStream)this.outputStream);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new IllegalArgumentException("can't initialize disk schema manager at " + this.dataFile);
        }
    }

    private void initFile(File dir) throws IOException {
        if (dir.mkdirs()) {
            logger.info("ID table create database system dir {} doesn't exist, create it", (Object)dir.getParentFile());
        }
        this.dataFile = new File(dir, FILE_NAME);
        if (this.dataFile.exists()) {
            this.loc = this.dataFile.length();
            if (!this.checkFileConsistency(this.loc)) {
                throw new IOException("File corruption");
            }
        } else {
            logger.debug("create new file for id table: {}", (Object)dir.getName());
            boolean createRes = this.dataFile.createNewFile();
            if (!createRes) {
                throw new IOException("create new file for id table failed. Path is: " + this.dataFile.getPath());
            }
            this.loc = 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFileConsistency(long pos) {
        if (pos == 0L) {
            return true;
        }
        if (pos <= 4L) {
            return false;
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.dataFile));){
            String version = ReadWriteIOUtils.readString((InputStream)inputStream);
            if (FILE_VERSION.equals(version)) return true;
            logger.error("File version isn't right, need: {}, actual: {} ", (Object)FILE_VERSION, (Object)version);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("File check failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public long serialize(DiskSchemaEntry schemaEntry) {
        long beforeLoc = this.loc;
        try {
            this.loc += (long)schemaEntry.serialize(this.outputStream);
        }
        catch (IOException e) {
            logger.error("failed to serialize schema entry: {}", (Object)schemaEntry);
            throw new IllegalArgumentException("can't serialize disk entry of " + schemaEntry);
        }
        return beforeLoc;
    }

    @Override
    public void recover(IDTable idTable) {
        long loc = 0L;
        try (FileInputStream inputStream = new FileInputStream(this.dataFile);){
            ReadWriteIOUtils.readString((InputStream)inputStream);
            while (inputStream.available() > 0) {
                DiskSchemaEntry cur = DiskSchemaEntry.deserialize(inputStream);
                if (!cur.deviceID.equals("tombstone_record")) {
                    SchemaEntry schemaEntry = new SchemaEntry(TSDataType.deserialize((byte)cur.type), TSEncoding.deserialize((byte)cur.encoding), CompressionType.deserialize((byte)cur.compressor), loc);
                    idTable.putSchemaEntry(cur.deviceID, cur.measurementName, schemaEntry, cur.isAligned);
                }
                loc += cur.entrySize;
            }
        }
        catch (IOException | MetadataException e) {
            logger.info("Last entry is incomplete, we will recover as much as we can.");
            try {
                this.outputStream.getChannel().truncate(loc);
            }
            catch (IOException ioException) {
                logger.error("Failed at truncate file.", (Throwable)ioException);
            }
            this.loc = loc;
        }
    }

    @Override
    public Collection<DiskSchemaEntry> getAllSchemaEntry() throws IOException {
        ArrayList<DiskSchemaEntry> res = new ArrayList<DiskSchemaEntry>();
        try (FileInputStream inputStream = new FileInputStream(this.dataFile);){
            ReadWriteIOUtils.readString((InputStream)inputStream);
            for (int maxCount = 1000; maxCount > 0; --maxCount) {
                try {
                    DiskSchemaEntry cur = DiskSchemaEntry.deserialize(inputStream);
                    if (cur.deviceID.equals("tombstone_record")) continue;
                    res.add(cur);
                    continue;
                }
                catch (IOException e) {
                    logger.debug("read finished");
                    break;
                }
            }
        }
        return res;
    }

    @Override
    public List<DiskSchemaEntry> getDiskSchemaEntriesByOffset(List<Long> offsets) {
        ArrayList<DiskSchemaEntry> diskSchemaEntries = new ArrayList<DiskSchemaEntry>(offsets.size());
        Collections.sort(offsets);
        try {
            for (long offset : offsets) {
                diskSchemaEntries.add(this.getDiskSchemaEntryByOffset(offset));
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return diskSchemaEntries;
    }

    @Override
    public void deleteDiskSchemaEntryByOffset(long offset) throws MetadataException {
        try {
            this.randomAccessFile.seek(offset + (long)FILE_VERSION.length() + 4L);
            int strLength = this.randomAccessFile.readInt();
            byte[] bytes = new byte[strLength];
            this.randomAccessFile.write(bytes, 0, strLength);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new MetadataException(e.getMessage());
        }
    }

    private DiskSchemaEntry getDiskSchemaEntryByOffset(long offset) throws IOException {
        this.randomAccessFile.seek(offset + (long)FILE_VERSION.length() + 4L);
        this.readString();
        String seriesKey = this.readString();
        String measurementName = this.readString();
        String deviceID = DeviceIDFactory.getInstance().getDeviceID(seriesKey.substring(0, seriesKey.length() - measurementName.length() - 1)).toStringID();
        return new DiskSchemaEntry(deviceID, seriesKey, measurementName, this.randomAccessFile.readByte(), this.randomAccessFile.readByte(), this.randomAccessFile.readByte(), this.randomAccessFile.readBoolean());
    }

    private String readString() throws IOException {
        int strLength = this.randomAccessFile.readInt();
        byte[] bytes = new byte[strLength];
        this.randomAccessFile.read(bytes, 0, strLength);
        return new String(bytes, 0, strLength);
    }

    @Override
    public void close() throws IOException {
        try {
            this.outputStream.close();
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            logger.error("close schema file failed");
            throw e;
        }
    }
}

