/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeLastCacheManager;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCacheMetrics;
import org.apache.iotdb.db.metadata.cache.SchemaCacheEntry;
import org.apache.iotdb.db.metadata.cache.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.metadata.cache.dualkeycache.IDualKeyCacheComputation;
import org.apache.iotdb.db.metadata.cache.dualkeycache.impl.DualKeyCacheBuilder;
import org.apache.iotdb.db.metadata.cache.dualkeycache.impl.DualKeyCachePolicy;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeSchemaCache {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeSchemaCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final IDualKeyCache<PartialPath, String, SchemaCacheEntry> dualKeyCache;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);

    private DataNodeSchemaCache() {
        DualKeyCacheBuilder dualKeyCacheBuilder = new DualKeyCacheBuilder();
        this.dualKeyCache = dualKeyCacheBuilder.cacheEvictionPolicy(DualKeyCachePolicy.LRU).memoryCapacity(config.getAllocateMemoryForSchemaCache()).firstKeySizeComputer(PartialPath::estimateSize).secondKeySizeComputer(s -> 32 + 2 * s.length()).valueSizeComputer(SchemaCacheEntry::estimateSize).build();
        MetricService.getInstance().addMetricSet((IMetricSet)new DataNodeSchemaCacheMetrics(this));
    }

    public double getHitRate() {
        return this.dualKeyCache.stats().hitRate() * 100.0;
    }

    public static DataNodeSchemaCache getInstance() {
        return DataNodeSchemaCacheHolder.INSTANCE;
    }

    public void takeReadLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    public void takeWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public ClusterSchemaTree get(final PartialPath devicePath, final String[] measurements) {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        final HashSet<String> storageGroupSet = new HashSet<String>();
        this.dualKeyCache.compute(new IDualKeyCacheComputation<PartialPath, String, SchemaCacheEntry>(){

            @Override
            public PartialPath getFirstKey() {
                return devicePath;
            }

            public String[] getSecondKeyList() {
                return measurements;
            }

            @Override
            public void computeValue(int index, SchemaCacheEntry value) {
                if (value != null) {
                    schemaTree.appendSingleMeasurement(devicePath.concatNode(value.getSchemaEntryId()), value.getMeasurementSchema(), value.getTagMap(), null, value.isAligned());
                    storageGroupSet.add(value.getStorageGroup());
                }
            }
        });
        schemaTree.setDatabases(storageGroupSet);
        return schemaTree;
    }

    public ClusterSchemaTree get(PartialPath fullPath) {
        SchemaCacheEntry schemaCacheEntry = this.dualKeyCache.get(fullPath.getDevicePath(), fullPath.getMeasurement());
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        if (schemaCacheEntry != null) {
            schemaTree.appendSingleMeasurement(fullPath, schemaCacheEntry.getMeasurementSchema(), schemaCacheEntry.getTagMap(), null, schemaCacheEntry.isAligned());
            schemaTree.setDatabases(Collections.singleton(schemaCacheEntry.getStorageGroup()));
        }
        return schemaTree;
    }

    public List<Integer> compute(final ISchemaComputation schemaComputation) {
        final ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        final AtomicBoolean isFirstMeasurement = new AtomicBoolean(true);
        this.dualKeyCache.compute(new IDualKeyCacheComputation<PartialPath, String, SchemaCacheEntry>(){

            @Override
            public PartialPath getFirstKey() {
                return schemaComputation.getDevicePath();
            }

            public String[] getSecondKeyList() {
                return schemaComputation.getMeasurements();
            }

            @Override
            public void computeValue(int index, SchemaCacheEntry value) {
                if (value == null) {
                    indexOfMissingMeasurements.add(index);
                } else {
                    if (isFirstMeasurement.get()) {
                        schemaComputation.computeDevice(value.isAligned());
                        isFirstMeasurement.getAndSet(false);
                    }
                    schemaComputation.computeMeasurement(index, value);
                }
            }
        });
        return indexOfMissingMeasurements;
    }

    public void put(ClusterSchemaTree schemaTree) {
        for (MeasurementPath measurementPath : schemaTree.getAllMeasurement()) {
            this.putSingleMeasurementPath(schemaTree.getBelongedDatabase((PartialPath)measurementPath), measurementPath);
        }
    }

    private void putSingleMeasurementPath(String storageGroup, MeasurementPath measurementPath) {
        SchemaCacheEntry schemaCacheEntry = new SchemaCacheEntry(storageGroup, (MeasurementSchema)measurementPath.getMeasurementSchema(), measurementPath.getTagMap(), measurementPath.isUnderAlignedEntity());
        this.dualKeyCache.put(measurementPath.getDevicePath(), measurementPath.getMeasurement(), schemaCacheEntry);
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        SchemaCacheEntry entry = this.dualKeyCache.get(seriesPath.getDevicePath(), seriesPath.getMeasurement());
        if (null == entry) {
            return null;
        }
        return DataNodeLastCacheManager.getLastCache(entry);
    }

    public void updateLastCache(PartialPath seriesPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        SchemaCacheEntry entry = this.dualKeyCache.get(seriesPath.getDevicePath(), seriesPath.getMeasurement());
        if (null == entry) {
            return;
        }
        DataNodeLastCacheManager.updateLastCache(entry, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastCache(String storageGroup, MeasurementPath measurementPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        PartialPath seriesPath = measurementPath.transformToPartialPath();
        SchemaCacheEntry entry = this.dualKeyCache.get(seriesPath.getDevicePath(), seriesPath.getMeasurement());
        if (null == entry) {
            IDualKeyCache<PartialPath, String, SchemaCacheEntry> iDualKeyCache = this.dualKeyCache;
            synchronized (iDualKeyCache) {
                entry = this.dualKeyCache.get(seriesPath.getDevicePath(), seriesPath.getMeasurement());
                if (null == entry) {
                    entry = new SchemaCacheEntry(storageGroup, (MeasurementSchema)measurementPath.getMeasurementSchema(), measurementPath.getTagMap(), measurementPath.isUnderAlignedEntity());
                    this.dualKeyCache.put(seriesPath.getDevicePath(), seriesPath.getMeasurement(), entry);
                }
            }
        }
        DataNodeLastCacheManager.updateLastCache(entry, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public void invalidateAll() {
        this.dualKeyCache.invalidateAll();
    }

    public void cleanUp() {
        this.dualKeyCache.cleanUp();
    }

    private static class DataNodeSchemaCacheHolder {
        private static final DataNodeSchemaCache INSTANCE = new DataNodeSchemaCache();

        private DataNodeSchemaCacheHolder() {
        }
    }
}

