/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.schedule;

import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionWorker;
import org.apache.iotdb.db.engine.compaction.schedule.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.service.metrics.recorder.CompactionMetricsManager;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private static final long MAX_WAITING_TIME = 120000L;
    private static final CompactionTaskManager INSTANCE = new CompactionTaskManager();
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private WrappedThreadPoolExecutor taskExecutionPool;
    private WrappedThreadPoolExecutor subCompactionTaskExecutionPool;
    public static volatile AtomicInteger currentTaskNum = new AtomicInteger(0);
    private final FixedPriorityBlockingQueue<AbstractCompactionTask> candidateCompactionTaskQueue = new FixedPriorityBlockingQueue<AbstractCompactionTask>(this.config.getCandidateCompactionTaskQueueSize(), new DefaultCompactionTaskComparatorImpl());
    private final Map<String, Map<AbstractCompactionTask, Future<CompactionTaskSummary>>> storageGroupTasks = new ConcurrentHashMap<String, Map<AbstractCompactionTask, Future<CompactionTaskSummary>>>();
    private final AtomicInteger finishedTaskNum = new AtomicInteger(0);
    private final RateLimiter mergeWriteRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);
    private volatile boolean init = false;

    public static CompactionTaskManager getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
        if (this.taskExecutionPool == null && IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() > 0 && (this.config.isEnableSeqSpaceCompaction() || this.config.isEnableUnseqSpaceCompaction() || this.config.isEnableCrossSpaceCompaction())) {
            this.initThreadPool();
            currentTaskNum = new AtomicInteger(0);
            this.candidateCompactionTaskQueue.regsitPollLastHook(AbstractCompactionTask::resetCompactionCandidateStatusForAllSourceFiles);
            this.candidateCompactionTaskQueue.regsitPollLastHook(x -> CompactionMetricsManager.getInstance().reportPollTaskFromWaitingQueue(x.isCrossTask(), x.isInnerSeqTask()));
            this.init = true;
        }
        logger.info("Compaction task manager started.");
    }

    private void initThreadPool() {
        int compactionThreadNum = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        this.taskExecutionPool = (WrappedThreadPoolExecutor)IoTDBThreadPoolFactory.newFixedThreadPool((int)compactionThreadNum, (String)ThreadName.COMPACTION_SERVICE.getName());
        this.subCompactionTaskExecutionPool = (WrappedThreadPoolExecutor)IoTDBThreadPoolFactory.newFixedThreadPool((int)(compactionThreadNum * IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum()), (String)ThreadName.COMPACTION_SUB_SERVICE.getName());
        for (int i = 0; i < compactionThreadNum; ++i) {
            this.taskExecutionPool.submit((Runnable)new CompactionWorker(i, this.candidateCompactionTaskQueue));
        }
    }

    public void stop() {
        if (this.taskExecutionPool != null) {
            this.subCompactionTaskExecutionPool.shutdownNow();
            this.taskExecutionPool.shutdownNow();
            logger.info("Waiting for task taskExecutionPool to shut down");
            this.waitTermination();
            this.storageGroupTasks.clear();
            this.candidateCompactionTaskQueue.clear();
        }
    }

    public void waitAndStop(long milliseconds) {
        if (this.taskExecutionPool != null) {
            this.awaitTermination((ExecutorService)this.subCompactionTaskExecutionPool, milliseconds);
            this.awaitTermination((ExecutorService)this.taskExecutionPool, milliseconds);
            logger.info("Waiting for task taskExecutionPool to shut down in {} ms", (Object)milliseconds);
            this.waitTermination();
            this.storageGroupTasks.clear();
        }
    }

    public void waitAllCompactionFinish() {
        long sleepingStartTime = 0L;
        if (this.taskExecutionPool != null) {
            WrappedThreadPoolExecutor tmpThreadPool = this.taskExecutionPool;
            this.taskExecutionPool = null;
            this.candidateCompactionTaskQueue.clear();
            while (true) {
                int totalSize = 0;
                for (Map<AbstractCompactionTask, Future<CompactionTaskSummary>> taskMap : this.storageGroupTasks.values()) {
                    totalSize += taskMap.size();
                }
                if (totalSize <= 0) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted when waiting all task finish", (Throwable)e);
                    break;
                }
            }
            this.storageGroupTasks.clear();
            this.taskExecutionPool = tmpThreadPool;
            logger.info("All compaction task finish");
        }
    }

    private void waitTermination() {
        long startTime = System.currentTimeMillis();
        int timeMillis = 0;
        while (!this.subCompactionTaskExecutionPool.isTerminated() || !this.taskExecutionPool.isTerminated()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            long time = System.currentTimeMillis() - startTime;
            if ((timeMillis += 200) % 60000 != 0) continue;
            logger.info("CompactionManager has wait for {} seconds to stop", (Object)(time / 1000L));
        }
        this.taskExecutionPool = null;
        this.subCompactionTaskExecutionPool = null;
        this.storageGroupTasks.clear();
        logger.info("CompactionManager stopped");
    }

    private void awaitTermination(ExecutorService service, long milliseconds) {
        try {
            service.shutdownNow();
            service.awaitTermination(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("CompactionThreadPool can not be closed in {} ms", (Object)milliseconds);
            Thread.currentThread().interrupt();
        }
        service.shutdownNow();
    }

    public ServiceType getID() {
        return ServiceType.COMPACTION_SERVICE;
    }

    public synchronized boolean addTaskToWaitingQueue(AbstractCompactionTask compactionTask) throws InterruptedException {
        if (this.init && !this.candidateCompactionTaskQueue.contains(compactionTask) && !this.isTaskRunning(compactionTask)) {
            compactionTask.setSourceFilesToCompactionCandidate();
            this.candidateCompactionTaskQueue.put(compactionTask);
            CompactionMetricsManager.getInstance().reportAddTaskToWaitingQueue(compactionTask.isCrossTask(), compactionTask.isInnerSeqTask());
            return true;
        }
        return false;
    }

    private boolean isTaskRunning(AbstractCompactionTask task) {
        String regionWithSG = CompactionTaskManager.getSGWithRegionId(task.getStorageGroupName(), task.getDataRegionId());
        return this.storageGroupTasks.computeIfAbsent(regionWithSG, x -> new ConcurrentHashMap()).containsKey(task);
    }

    public RateLimiter getMergeWriteRateLimiter() {
        this.setWriteMergeRate(IoTDBDescriptor.getInstance().getConfig().getCompactionWriteThroughputMbPerSec());
        return this.mergeWriteRateLimiter;
    }

    private void setWriteMergeRate(double throughoutMbPerSec) {
        double throughout = throughoutMbPerSec * 1024.0 * 1024.0;
        if (throughout == 0.0) {
            throughout = Double.MAX_VALUE;
        }
        if (this.mergeWriteRateLimiter.getRate() != throughout) {
            this.mergeWriteRateLimiter.setRate(throughout);
        }
    }

    public static void mergeRateLimiterAcquire(RateLimiter limiter, long bytesLength) {
        while (bytesLength >= Integer.MAX_VALUE) {
            limiter.acquire(Integer.MAX_VALUE);
            bytesLength -= Integer.MAX_VALUE;
        }
        if (bytesLength > 0L) {
            limiter.acquire((int)bytesLength);
        }
    }

    public synchronized void removeRunningTaskFuture(AbstractCompactionTask task) {
        String regionWithSG = CompactionTaskManager.getSGWithRegionId(task.getStorageGroupName(), task.getDataRegionId());
        if (this.storageGroupTasks.containsKey(regionWithSG)) {
            this.storageGroupTasks.get(regionWithSG).remove(task);
        }
        this.finishedTaskNum.incrementAndGet();
    }

    public synchronized Future<Void> submitSubTask(Callable<Void> subCompactionTask) {
        if (this.subCompactionTaskExecutionPool != null && !this.subCompactionTaskExecutionPool.isShutdown()) {
            return this.subCompactionTaskExecutionPool.submit(subCompactionTask);
        }
        return null;
    }

    public synchronized List<AbstractCompactionTask> abortCompaction(String storageGroupName) {
        ArrayList<AbstractCompactionTask> compactionTaskOfCurSG = new ArrayList<AbstractCompactionTask>();
        if (this.storageGroupTasks.containsKey(storageGroupName)) {
            for (Map.Entry<AbstractCompactionTask, Future<CompactionTaskSummary>> compactionTaskEntry : this.storageGroupTasks.get(storageGroupName).entrySet()) {
                compactionTaskEntry.getValue().cancel(true);
                compactionTaskOfCurSG.add(compactionTaskEntry.getKey());
            }
        }
        this.storageGroupTasks.remove(storageGroupName);
        this.candidateCompactionTaskQueue.clear();
        return compactionTaskOfCurSG;
    }

    public boolean isAnyTaskInListStillRunning(List<AbstractCompactionTask> compactionTasks) {
        boolean anyTaskRunning = false;
        for (AbstractCompactionTask task : compactionTasks) {
            anyTaskRunning = anyTaskRunning || task.isTaskRan() && !task.isTaskFinished();
        }
        return anyTaskRunning;
    }

    public int getExecutingTaskCount() {
        int runningTaskCnt = 0;
        for (Map<AbstractCompactionTask, Future<CompactionTaskSummary>> runningTaskMap : this.storageGroupTasks.values()) {
            runningTaskCnt += runningTaskMap.size();
        }
        return runningTaskCnt;
    }

    public int getTotalTaskCount() {
        return this.getExecutingTaskCount() + this.candidateCompactionTaskQueue.size();
    }

    public int getCompactionCandidateTaskCount() {
        return this.candidateCompactionTaskQueue.size();
    }

    public synchronized List<AbstractCompactionTask> getRunningCompactionTaskList() {
        ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
        for (Map<AbstractCompactionTask, Future<CompactionTaskSummary>> runningTaskMap : this.storageGroupTasks.values()) {
            tasks.addAll(runningTaskMap.keySet());
        }
        return tasks;
    }

    public long getFinishedTaskNum() {
        return this.finishedTaskNum.get();
    }

    public void recordTask(AbstractCompactionTask task, Future<CompactionTaskSummary> summary) {
        this.storageGroupTasks.computeIfAbsent(CompactionTaskManager.getSGWithRegionId(task.getStorageGroupName(), task.getDataRegionId()), x -> new ConcurrentHashMap()).put(task, summary);
    }

    public static String getSGWithRegionId(String storageGroupName, String dataRegionId) {
        return storageGroupName + "-" + dataRegionId;
    }

    public void restart() throws InterruptedException {
        if (IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() > 0) {
            if (this.subCompactionTaskExecutionPool != null) {
                this.subCompactionTaskExecutionPool.shutdownNow();
                if (!this.subCompactionTaskExecutionPool.awaitTermination(120000L, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException("Has been waiting over 120 seconds for all sub compaction tasks to finish.");
                }
            }
            if (this.taskExecutionPool != null) {
                this.taskExecutionPool.shutdownNow();
                if (!this.taskExecutionPool.awaitTermination(120000L, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException("Has been waiting over 120 seconds for all compaction tasks to finish.");
                }
            }
            this.initThreadPool();
            this.finishedTaskNum.set(0);
            this.candidateCompactionTaskQueue.clear();
            this.init = true;
        }
        currentTaskNum = new AtomicInteger(0);
        this.init = true;
        logger.info("Compaction task manager started.");
    }

    public void clearCandidateQueue() {
        this.candidateCompactionTaskQueue.clear();
    }

    public Future<CompactionTaskSummary> getCompactionTaskFutureMayBlock(AbstractCompactionTask task) throws InterruptedException, TimeoutException {
        String regionWithSG = CompactionTaskManager.getSGWithRegionId(task.getStorageGroupName(), task.getDataRegionId());
        long startTime = System.currentTimeMillis();
        while (!this.storageGroupTasks.containsKey(regionWithSG) || !this.storageGroupTasks.get(regionWithSG).containsKey(task)) {
            Thread.sleep(10L);
            if (System.currentTimeMillis() - startTime <= 20000L) continue;
            throw new TimeoutException("Timeout when waiting for task future");
        }
        return this.storageGroupTasks.get(regionWithSG).get(task);
    }
}

