/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.execute.utils.writer.AbstractInnerCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;

public class ReadPointInnerCompactionWriter
extends AbstractInnerCompactionWriter {
    public ReadPointInnerCompactionWriter(TsFileResource targetFileResource) throws IOException {
        super(targetFileResource);
    }

    @Override
    public void write(TimeColumn timestamps, Column[] columns, int subTaskId, int batchSize) throws IOException {
        AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
        chunkWriter.write(timestamps, columns, batchSize);
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + timestamps.getTimes().length;
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, (IChunkWriter)chunkWriter, subTaskId, false);
        this.isEmptyFile = false;
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushAlignedChunk(Chunk timeChunk, IChunkMetadata timeChunkMetadata, List<Chunk> valueChunks, List<IChunkMetadata> valueChunkMetadatas, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }

    @Override
    public boolean flushAlignedPage(ByteBuffer compressedTimePageData, PageHeader timePageHeader, List<ByteBuffer> compressedValuePageDatas, List<PageHeader> valuePageHeaders, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointInnerCompactionWriter");
    }
}

