/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategy;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;

public class RandomOnDiskUsableSpaceStrategy
extends DirectoryStrategy {
    private Random random = new Random(System.currentTimeMillis());

    @Override
    public int nextFolderIndex() throws DiskSpaceInsufficientException {
        int index;
        List<Long> spaceList = this.getFolderUsableSpaceList();
        long spaceSum = spaceList.stream().mapToLong(Long::longValue).sum();
        if (spaceSum <= 0L) {
            throw new DiskSpaceInsufficientException(this.folders);
        }
        long randomV = (this.random.nextLong() & Long.MAX_VALUE) % spaceSum;
        for (index = 0; index < spaceList.size() && randomV >= spaceList.get(index); randomV -= spaceList.get(index).longValue(), ++index) {
        }
        return index;
    }

    public List<Long> getFolderUsableSpaceList() {
        ArrayList<Long> spaceList = new ArrayList<Long>();
        for (int i = 0; i < this.folders.size(); ++i) {
            String folder = (String)this.folders.get(i);
            spaceList.add(JVMCommonUtils.getUsableSpace((String)folder));
        }
        return spaceList;
    }
}

