/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.type;

import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.metrics.micrometer.type.MicrometerRate;
import org.apache.iotdb.metrics.micrometer.type.MicrometerTimerHistogramSnapshot;
import org.apache.iotdb.metrics.type.HistogramSnapshot;
import org.apache.iotdb.metrics.type.Rate;

public class MicrometerTimer
implements org.apache.iotdb.metrics.type.Timer {
    Timer timer;
    MicrometerRate micrometerRate;

    public MicrometerTimer(Timer timer) {
        this.timer = timer;
        this.micrometerRate = new MicrometerRate(new AtomicLong(0L));
    }

    public void update(long duration, TimeUnit unit) {
        this.timer.record(duration, unit);
        this.micrometerRate.mark();
    }

    public HistogramSnapshot takeSnapshot() {
        return new MicrometerTimerHistogramSnapshot(this.timer.takeSnapshot(), this.timer.baseTimeUnit());
    }

    public Rate getImmutableRate() {
        return this.micrometerRate;
    }
}

