/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

public class PaginationController {
    public static final PaginationController UNLIMITED_PAGINATION_CONTROLLER = new PaginationController(0L, 0L);
    private final boolean hasLimit;
    private long curLimit;
    private long curOffset;

    public PaginationController(long limit, long offset) {
        this.curLimit = limit;
        this.hasLimit = limit > 0L;
        this.curOffset = offset;
    }

    public boolean hasCurOffset() {
        return this.curOffset > 0L;
    }

    public boolean hasCurOffset(long rowCount) {
        return this.curOffset >= rowCount;
    }

    public boolean hasCurLimit() {
        return !this.hasLimit || this.curLimit > 0L;
    }

    public void consumeOffset(long rowCount) {
        this.curOffset -= rowCount;
    }

    public void consumeOffset() {
        --this.curOffset;
    }

    public void consumeLimit() {
        if (this.hasLimit) {
            --this.curLimit;
        }
    }
}

