/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.BinaryFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;

public class OrFilter
extends BinaryFilter
implements Serializable {
    private static final long serialVersionUID = -968055896528472694L;

    public OrFilter() {
    }

    public OrFilter(Filter left, Filter right) {
        super(left, right);
    }

    @Override
    public String toString() {
        return "(" + this.left + " || " + this.right + ")";
    }

    @Override
    public Filter copy() {
        return new OrFilter(this.left.copy(), this.right.copy());
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        return this.left.satisfy(statistics) || this.right.satisfy(statistics);
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.left.satisfy(time, value) || this.right.satisfy(time, value);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return this.left.satisfyStartEndTime(startTime, endTime) || this.right.satisfyStartEndTime(startTime, endTime);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return this.left.containStartEndTime(startTime, endTime) || this.right.containStartEndTime(startTime, endTime);
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.OR;
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        TimeRange range;
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        List<TimeRange> leftTimeRanges = this.left.getTimeRanges();
        List<TimeRange> rightTimeRanges = this.right.getTimeRanges();
        int leftIndex = 0;
        int rightIndex = 0;
        int leftSize = leftTimeRanges.size();
        int rightSize = rightTimeRanges.size();
        if (leftTimeRanges.isEmpty() && rightTimeRanges.isEmpty()) {
            return Collections.emptyList();
        }
        if (leftTimeRanges.isEmpty()) {
            return rightTimeRanges;
        }
        if (rightTimeRanges.isEmpty()) {
            return leftTimeRanges;
        }
        TimeRange leftRange = leftTimeRanges.get(leftIndex);
        TimeRange rightRange = rightTimeRanges.get(rightIndex);
        if (leftRange.getMin() <= rightRange.getMin()) {
            range = leftRange;
            ++leftIndex;
        } else {
            range = rightRange;
            ++rightIndex;
        }
        while (leftIndex < leftSize || rightIndex < rightSize) {
            TimeRange chosenRange;
            if (leftIndex < leftSize && rightIndex < rightSize) {
                TimeRange leftRange2 = leftTimeRanges.get(leftIndex);
                TimeRange rightRange2 = rightTimeRanges.get(rightIndex);
                if (leftRange2.getMin() <= rightRange2.getMin()) {
                    chosenRange = leftRange2;
                    ++leftIndex;
                } else {
                    chosenRange = rightRange2;
                    ++rightIndex;
                }
            } else if (leftIndex < leftSize) {
                chosenRange = leftTimeRanges.get(leftIndex);
                ++leftIndex;
            } else {
                chosenRange = rightTimeRanges.get(rightIndex);
                ++rightIndex;
            }
            if (chosenRange.getMin() > range.getMax()) {
                result.add(range);
                range = chosenRange;
                continue;
            }
            range.setMax(Math.max(range.getMax(), chosenRange.getMax()));
        }
        result.add(range);
        return result;
    }
}

