/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.util.Comparator;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.iotdb.commons.udf.builtin.UDTFSelectK;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFBottomK
extends UDTFSelectK {
    @Override
    protected void constructPQ() throws UDFInputSeriesDataTypeNotValidException {
        switch (this.dataType) {
            case INT32: {
                this.intPQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> -((Integer)o.right).intValue()));
                break;
            }
            case INT64: {
                this.longPQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> -((Long)o.right).longValue()));
                break;
            }
            case FLOAT: {
                this.floatPQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> Float.valueOf(-((Float)o.right).floatValue())));
                break;
            }
            case DOUBLE: {
                this.doublePQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> -((Double)o.right).doubleValue()));
                break;
            }
            case TEXT: {
                this.stringPQ = new PriorityQueue(this.k, (pairA, pairB) -> {
                    String cs1 = (String)pairB.right;
                    String cs2 = (String)pairA.right;
                    if (Objects.requireNonNull(cs1).equals(Objects.requireNonNull(cs2))) {
                        return 0;
                    }
                    int len = Math.min(cs1.length(), cs2.length());
                    for (int i = 0; i < len; ++i) {
                        char b;
                        char a = cs1.charAt(i);
                        if (a == (b = cs2.charAt(i))) continue;
                        return a - b;
                    }
                    return cs1.length() - cs2.length();
                });
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT});
            }
        }
    }

    @Override
    protected void transformInt(long time, int value) {
        if (this.intPQ.size() < this.k) {
            this.intPQ.add(new Pair((Object)time, (Object)value));
        } else if (value < (Integer)((Pair)this.intPQ.peek()).right) {
            this.intPQ.poll();
            this.intPQ.add(new Pair((Object)time, (Object)value));
        }
    }

    @Override
    protected void transformLong(long time, long value) {
        if (this.longPQ.size() < this.k) {
            this.longPQ.add(new Pair((Object)time, (Object)value));
        } else if (value < (Long)((Pair)this.longPQ.peek()).right) {
            this.longPQ.poll();
            this.longPQ.add(new Pair((Object)time, (Object)value));
        }
    }

    @Override
    protected void transformFloat(long time, float value) {
        if (this.floatPQ.size() < this.k) {
            this.floatPQ.add(new Pair((Object)time, (Object)Float.valueOf(value)));
        } else if (value < ((Float)((Pair)this.floatPQ.peek()).right).floatValue()) {
            this.floatPQ.poll();
            this.floatPQ.add(new Pair((Object)time, (Object)Float.valueOf(value)));
        }
    }

    @Override
    protected void transformDouble(long time, double value) {
        if (this.doublePQ.size() < this.k) {
            this.doublePQ.add(new Pair((Object)time, (Object)value));
        } else if (value < (Double)((Pair)this.doublePQ.peek()).right) {
            this.doublePQ.poll();
            this.doublePQ.add(new Pair((Object)time, (Object)value));
        }
    }

    @Override
    protected void transformString(long time, String value) {
        if (this.stringPQ.size() < this.k) {
            this.stringPQ.add(new Pair((Object)time, (Object)value));
        } else if (value.compareTo((String)((Pair)this.stringPQ.peek()).right) < 0) {
            this.stringPQ.poll();
            this.stringPQ.add(new Pair((Object)time, (Object)value));
        }
    }
}

