/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReconfigurationTimeoutException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.FollowerInfoImpl;
import org.apache.ratis.server.impl.MessageStreamRequests;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.PendingStepDown;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.metrics.LogAppenderMetrics;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

class LeaderStateImpl
implements LeaderState {
    public static final String APPEND_PLACEHOLDER = JavaUtils.getClassSimpleName(LeaderState.class) + ".placeholder";
    private final StateUpdateEvent updateCommitEvent = new StateUpdateEvent(StateUpdateEvent.Type.UPDATE_COMMIT, -1L, this::updateCommit);
    private final StateUpdateEvent checkStagingEvent = new StateUpdateEvent(StateUpdateEvent.Type.CHECK_STAGING, -1L, this::checkStaging);
    private final String name;
    private final RaftServerImpl server;
    private final RaftLog raftLog;
    private final long currentTerm;
    private volatile ConfigurationStagingState stagingState;
    private List<List<RaftPeerId>> voterLists;
    private final Map<RaftPeerId, FollowerInfo> peerIdFollowerInfoMap = new ConcurrentHashMap<RaftPeerId, FollowerInfo>();
    private final SenderList senders;
    private final EventQueue eventQueue;
    private final EventProcessor processor;
    private final PendingRequests pendingRequests;
    private final WatchRequests watchRequests;
    private final MessageStreamRequests messageStreamRequests;
    private volatile boolean running = true;
    private final int stagingCatchupGap;
    private final long placeHolderIndex;
    private final RaftServerMetricsImpl raftServerMetrics;
    private final LogAppenderMetrics logAppenderMetrics;
    private final long followerMaxGapThreshold;
    private final PendingStepDown pendingStepDown;

    LeaderStateImpl(RaftServerImpl server) {
        this.name = server.getMemberId() + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.server = server;
        RaftProperties properties = server.getRaftServer().getProperties();
        this.stagingCatchupGap = RaftServerConfigKeys.stagingCatchupGap((RaftProperties)properties);
        ServerState state = server.getState();
        this.raftLog = state.getLog();
        this.currentTerm = state.getCurrentTerm();
        this.eventQueue = new EventQueue();
        this.processor = new EventProcessor(this.name, server);
        this.raftServerMetrics = server.getRaftServerMetrics();
        this.logAppenderMetrics = new LogAppenderMetrics(server.getMemberId());
        this.pendingRequests = new PendingRequests(server.getMemberId(), properties, this.raftServerMetrics);
        this.watchRequests = new WatchRequests(server.getMemberId(), properties);
        this.messageStreamRequests = new MessageStreamRequests(server.getMemberId());
        this.pendingStepDown = new PendingStepDown(this);
        long maxPendingRequests = RaftServerConfigKeys.Write.elementLimit((RaftProperties)properties);
        double followerGapRatioMax = RaftServerConfigKeys.Write.followerGapRatioMax((RaftProperties)properties);
        if (followerGapRatioMax == -1.0) {
            this.followerMaxGapThreshold = -1L;
        } else {
            if (followerGapRatioMax > 1.0 || followerGapRatioMax <= 0.0) {
                throw new IllegalArgumentException("raft.server.write.follower.gap.ratio.maxs value must between [1, 0) to enable the feature");
            }
            this.followerMaxGapThreshold = (long)(followerGapRatioMax * (double)maxPendingRequests);
        }
        RaftConfigurationImpl conf = state.getRaftConf();
        Collection<RaftPeer> others = conf.getOtherPeers(server.getId());
        this.placeHolderIndex = this.raftLog.getNextIndex();
        this.senders = new SenderList();
        this.addSenders(others, this.placeHolderIndex, true, RaftProtos.RaftPeerRole.FOLLOWER);
        Collection listeners = conf.getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
        if (!listeners.isEmpty()) {
            this.addSenders(listeners, this.placeHolderIndex, false, RaftProtos.RaftPeerRole.LISTENER);
        }
        this.voterLists = this.divideFollowers(conf);
    }

    RaftProtos.LogEntryProto start() {
        RaftProtos.LogEntryProto placeHolder = LogProtoUtils.toLogEntryProto(this.server.getRaftConf(), (Long)this.server.getState().getCurrentTerm(), this.raftLog.getNextIndex());
        CodeInjectionForTesting.execute((String)APPEND_PLACEHOLDER, (Object)this.server.getId().toString(), null, (Object[])new Object[0]);
        this.raftLog.append(Collections.singletonList(placeHolder));
        this.processor.start();
        this.senders.forEach(LogAppender::start);
        return placeHolder;
    }

    boolean isReady() {
        return this.server.getState().getLastAppliedIndex() >= this.placeHolderIndex;
    }

    void stop() {
        this.running = false;
        this.senders.forEach(LogAppender::stop);
        NotLeaderException nle = this.server.generateNotLeaderException();
        Collection<RaftProtos.CommitInfoProto> commitInfos = this.server.getCommitInfos();
        try {
            Collection<TransactionContext> transactions = this.pendingRequests.sendNotLeaderResponses(nle, commitInfos);
            this.server.getStateMachine().leaderEvent().notifyNotLeader(transactions);
            this.watchRequests.failWatches((Exception)nle);
        }
        catch (IOException e) {
            RaftServer.Division.LOG.warn("{}: Caught exception in sendNotLeaderResponses", (Object)this, (Object)e);
        }
        this.messageStreamRequests.clear();
        this.server.getServerRpc().notifyNotLeader(this.server.getMemberId().getGroupId());
        this.logAppenderMetrics.unregister();
        this.raftServerMetrics.unregister();
        this.pendingRequests.close();
    }

    void notifySenders() {
        this.senders.forEach(LogAppender::notifyLogAppender);
    }

    boolean inStagingState() {
        return this.stagingState != null;
    }

    long getCurrentTerm() {
        return this.currentTerm;
    }

    public boolean onFollowerTerm(FollowerInfo follower, long followerTerm) {
        if (LeaderStateImpl.isAttendingVote(follower) && followerTerm > this.getCurrentTerm()) {
            this.submitStepDownEvent(followerTerm, LeaderState.StepDownReason.HIGHER_TERM);
            return true;
        }
        return false;
    }

    PendingRequest startSetConfiguration(SetConfigurationRequest request, List<RaftPeer> peersInNewConf) {
        RaftServer.Division.LOG.info("{}: startSetConfiguration {}", (Object)this, (Object)request);
        Preconditions.assertTrue((this.running && !this.inStagingState() ? 1 : 0) != 0);
        List listenersInNewConf = request.getArguments().getPeersInNewConf(RaftProtos.RaftPeerRole.LISTENER);
        Collection<RaftPeer> peersToBootStrap = this.server.getRaftConf().filterNotContainedInConf(peersInNewConf);
        Collection<RaftPeer> listenersToBootStrap = this.server.getRaftConf().filterNotContainedInConf(listenersInNewConf);
        PendingRequest pending = this.pendingRequests.addConfRequest(request);
        ConfigurationStagingState configurationStagingState = new ConfigurationStagingState(peersToBootStrap, listenersToBootStrap, new PeerConfiguration(peersInNewConf, listenersInNewConf));
        Collection<RaftPeer> newPeers = configurationStagingState.getNewPeers();
        Collection<RaftPeer> newListeners = configurationStagingState.getNewListeners();
        this.stagingState = configurationStagingState;
        if (newPeers.isEmpty() && newListeners.isEmpty()) {
            this.applyOldNewConf();
        } else {
            this.addAndStartSenders(newPeers, RaftProtos.RaftPeerRole.FOLLOWER);
            this.addAndStartSenders(newListeners, RaftProtos.RaftPeerRole.LISTENER);
        }
        return pending;
    }

    PendingRequests.Permit tryAcquirePendingRequest(Message message) {
        return this.pendingRequests.tryAcquire(message);
    }

    PendingRequest addPendingRequest(PendingRequests.Permit permit, RaftClientRequest request, TransactionContext entry) {
        if (RaftServer.Division.LOG.isDebugEnabled()) {
            RaftServer.Division.LOG.debug("{}: addPendingRequest at {}, entry={}", new Object[]{this, request, LogProtoUtils.toLogEntryString(entry.getLogEntry())});
        }
        return this.pendingRequests.add(permit, request, entry);
    }

    CompletableFuture<RaftClientReply> streamAsync(RaftClientRequest request) {
        return ((CompletableFuture)this.messageStreamRequests.streamAsync(request).thenApply(dummy -> this.server.newSuccessReply(request))).exceptionally(e -> this.exception2RaftClientReply(request, (Throwable)e));
    }

    CompletableFuture<RaftClientRequest> streamEndOfRequestAsync(RaftClientRequest request) {
        return this.messageStreamRequests.streamEndOfRequestAsync(request).thenApply(bytes -> RaftClientRequest.toWriteRequest((RaftClientRequest)request, (Message)Message.valueOf((ByteString)bytes)));
    }

    CompletableFuture<RaftClientReply> addWatchReqeust(RaftClientRequest request) {
        RaftServer.Division.LOG.debug("{}: addWatchRequest {}", (Object)this, (Object)request);
        return ((CompletableFuture)this.watchRequests.add(request).thenApply(logIndex -> this.server.newSuccessReply(request, (long)logIndex))).exceptionally(e -> this.exception2RaftClientReply(request, (Throwable)e));
    }

    private RaftClientReply exception2RaftClientReply(RaftClientRequest request, Throwable e) {
        if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof NotReplicatedException) {
            NotReplicatedException nre = (NotReplicatedException)e;
            return this.server.newReplyBuilder(request).setException((RaftException)nre).setLogIndex(nre.getLogIndex()).build();
        }
        if (e instanceof NotLeaderException) {
            return this.server.newExceptionReply(request, (RaftException)((NotLeaderException)e));
        }
        if (e instanceof LeaderNotReadyException) {
            return this.server.newExceptionReply(request, (RaftException)((LeaderNotReadyException)e));
        }
        throw new CompletionException(e);
    }

    public void onFollowerCommitIndex(FollowerInfo follower, long commitIndex) {
        if (follower.updateCommitIndex(commitIndex)) {
            this.commitIndexChanged();
        }
    }

    private void commitIndexChanged() {
        this.getMajorityMin(FollowerInfo::getCommitIndex, () -> ((RaftLog)this.raftLog).getLastCommittedIndex()).ifPresent(m -> {
            this.watchRequests.update(RaftProtos.ReplicationLevel.ALL_COMMITTED, ((MinMajorityMax)m).min);
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY_COMMITTED, ((MinMajorityMax)m).majority);
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY, ((MinMajorityMax)m).max);
        });
        this.notifySenders();
    }

    private void applyOldNewConf() {
        ServerState state = this.server.getState();
        RaftConfigurationImpl current = state.getRaftConf();
        RaftConfigurationImpl oldNewConf = this.stagingState.generateOldNewConf(current, state.getLog().getNextIndex());
        long index = state.getLog().append(state.getCurrentTerm(), (RaftConfiguration)oldNewConf);
        this.updateConfiguration(index, oldNewConf);
        this.stagingState = null;
        this.notifySenders();
    }

    private void updateConfiguration(long logIndex, RaftConfigurationImpl newConf) {
        Preconditions.assertTrue((logIndex == newConf.getLogEntryIndex() ? 1 : 0) != 0);
        this.voterLists = this.divideFollowers(newConf);
        this.server.getState().setRaftConf(newConf);
    }

    void updateFollowerCommitInfos(CommitInfoCache cache, List<RaftProtos.CommitInfoProto> protos) {
        for (LogAppender sender : this.senders.getSenders()) {
            FollowerInfo info = sender.getFollower();
            protos.add(cache.update(info.getPeer(), info.getCommitIndex()));
        }
    }

    public RaftProtos.AppendEntriesRequestProto newAppendEntriesRequestProto(FollowerInfo follower, List<RaftProtos.LogEntryProto> entries, TermIndex previous, long callId) {
        boolean initializing = LeaderStateImpl.isAttendingVote(follower);
        RaftPeerId targetId = follower.getPeer().getId();
        return ServerProtoUtils.toAppendEntriesRequestProto(this.server.getMemberId(), targetId, this.currentTerm, entries, ServerImplUtils.effectiveCommitIndex(this.raftLog.getLastCommittedIndex(), previous, entries.size()), initializing, previous, this.server.getCommitInfos(), callId);
    }

    void addAndStartSenders(Collection<RaftPeer> newPeers, RaftProtos.RaftPeerRole role) {
        if (!newPeers.isEmpty()) {
            this.addSenders(newPeers, 0L, false, role).forEach(LogAppender::start);
        }
    }

    Collection<LogAppender> addSenders(Collection<RaftPeer> newPeers, long nextIndex, boolean attendVote, RaftProtos.RaftPeerRole role) {
        Timestamp t = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        List<LogAppender> newAppenders = newPeers.stream().map(peer -> {
            FollowerInfoImpl f = new FollowerInfoImpl(this.server.getMemberId(), (RaftPeer)peer, t, nextIndex, attendVote);
            this.peerIdFollowerInfoMap.put(peer.getId(), f);
            if (role == RaftProtos.RaftPeerRole.FOLLOWER) {
                this.raftServerMetrics.addFollower(peer.getId());
                this.logAppenderMetrics.addFollowerGauges(peer.getId(), () -> ((FollowerInfo)f).getNextIndex(), () -> ((FollowerInfo)f).getMatchIndex(), () -> ((FollowerInfo)f).getLastRpcTime());
            }
            return this.server.newLogAppender(this, f);
        }).collect(Collectors.toList());
        this.senders.addAll(newAppenders);
        return newAppenders;
    }

    void stopAndRemoveSenders(Predicate<LogAppender> predicate) {
        List<LogAppender> toStop = this.senders.stream().filter(predicate).collect(Collectors.toList());
        toStop.forEach(LogAppender::stop);
        this.senders.removeAll(toStop);
    }

    public void restart(LogAppender sender) {
        FollowerInfo info = sender.getFollower();
        RaftServer.Division.LOG.info("{}: Restarting {} for {}", new Object[]{this, JavaUtils.getClassSimpleName(sender.getClass()), info.getName()});
        sender.stop();
        this.senders.removeAll(Collections.singleton(sender));
        RaftPeer peer = info.getPeer();
        if (this.server.getRaftConf().containsInConf(peer.getId(), new RaftProtos.RaftPeerRole[0])) {
            this.addAndStartSenders(Collections.singleton(peer), RaftProtos.RaftPeerRole.FOLLOWER);
        } else if (this.server.getRaftConf().containsInConf(peer.getId(), RaftProtos.RaftPeerRole.LISTENER)) {
            this.addAndStartSenders(Collections.singleton(peer), RaftProtos.RaftPeerRole.LISTENER);
        }
    }

    private void updateSenders(RaftConfigurationImpl conf) {
        Preconditions.assertTrue((conf.isStable() && !this.inStagingState() ? 1 : 0) != 0);
        this.stopAndRemoveSenders(s -> !conf.containsInConf(s.getFollowerId(), RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER));
    }

    void submitStepDownEvent(LeaderState.StepDownReason reason) {
        this.submitStepDownEvent(this.getCurrentTerm(), reason);
    }

    void submitStepDownEvent(long term, LeaderState.StepDownReason reason) {
        this.eventQueue.submit(new StateUpdateEvent(StateUpdateEvent.Type.STEP_DOWN, term, () -> this.stepDown(term, reason)));
    }

    private void stepDown(long term, LeaderState.StepDownReason reason) {
        block2: {
            try {
                this.server.changeToFollowerAndPersistMetadata(term, false, reason);
                this.pendingStepDown.complete(this.server::newSuccessReply);
            }
            catch (IOException e) {
                String s = this + ": Failed to persist metadata for term " + term;
                RaftServer.Division.LOG.warn(s, (Throwable)e);
                if (!this.running) break block2;
                throw new IllegalStateException(s + " and running == true", e);
            }
        }
    }

    CompletableFuture<RaftClientReply> submitStepDownRequestAsync(TransferLeadershipRequest request) {
        return this.pendingStepDown.submitAsync(request);
    }

    private synchronized void sendStartLeaderElectionToHigherPriorityPeer(RaftPeerId follower, TermIndex lastEntry) {
        ServerState state = this.server.getState();
        TermIndex currLastEntry = state.getLastEntry();
        if (ServerState.compareLog(currLastEntry, lastEntry) != 0) {
            RaftServer.Division.LOG.warn("{} can not send StartLeaderElectionRequest to follower:{} because currLastEntry:{} did not match lastEntry:{}", new Object[]{this, follower, currLastEntry, lastEntry});
            return;
        }
        RaftProtos.StartLeaderElectionRequestProto r = ServerProtoUtils.toStartLeaderElectionRequestProto(this.server.getMemberId(), follower, lastEntry);
        CompletableFuture.supplyAsync(() -> {
            this.server.getLeaderElectionMetrics().onTransferLeadership();
            try {
                RaftProtos.StartLeaderElectionReplyProto replyProto = this.server.getServerRpc().startLeaderElection(r);
                RaftServer.Division.LOG.info("{} received {} reply of StartLeaderElectionRequest from follower:{}", new Object[]{this, replyProto.getServerReply().getSuccess() ? "success" : "fail", follower});
            }
            catch (IOException e) {
                RaftServer.Division.LOG.warn("{} send StartLeaderElectionRequest throw exception", (Object)this, (Object)e);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() {
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            ServerState state;
            if (this.running && (state = this.server.getState()).getRaftConf().isTransitional() && state.isConfCommitted()) {
                this.replicateNewConf();
            }
        }
    }

    private BootStrapProgress checkProgress(FollowerInfo follower, long committed) {
        Preconditions.assertTrue((!LeaderStateImpl.isAttendingVote(follower) ? 1 : 0) != 0);
        Timestamp progressTime = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        Timestamp timeoutTime = Timestamp.currentTime().addTimeMs(-3L * (long)this.server.getMaxTimeoutMs());
        if (follower.getLastRpcResponseTime().compareTo(timeoutTime) < 0) {
            RaftServer.Division.LOG.debug("{} detects a follower {} timeout ({}ms) for bootstrapping", new Object[]{this, follower, follower.getLastRpcResponseTime().elapsedTimeMs()});
            return BootStrapProgress.NOPROGRESS;
        }
        if (follower.getMatchIndex() + (long)this.stagingCatchupGap > committed && follower.getLastRpcResponseTime().compareTo(progressTime) > 0 && follower.hasAttemptedToInstallSnapshot()) {
            return BootStrapProgress.CAUGHTUP;
        }
        return BootStrapProgress.PROGRESSING;
    }

    private Collection<BootStrapProgress> checkAllProgress(long committed) {
        Preconditions.assertTrue((boolean)this.inStagingState());
        return this.senders.stream().filter(sender -> !LeaderStateImpl.isAttendingVote(sender.getFollower())).map(sender -> this.checkProgress(sender.getFollower(), committed)).collect(Collectors.toCollection(ArrayList::new));
    }

    public void onFollowerSuccessAppendEntries(FollowerInfo follower) {
        if (LeaderStateImpl.isAttendingVote(follower)) {
            this.submitUpdateCommitEvent();
        } else {
            this.eventQueue.submit(this.checkStagingEvent);
        }
    }

    public boolean isFollowerBootstrapping(FollowerInfo follower) {
        return this.isBootStrappingPeer(follower.getPeer().getId());
    }

    private void checkStaging() {
        if (!this.inStagingState()) {
            this.updateCommitEvent.execute();
        } else {
            long committedIndex = this.server.getState().getLog().getLastCommittedIndex();
            Collection<BootStrapProgress> reports = this.checkAllProgress(committedIndex);
            if (reports.contains((Object)BootStrapProgress.NOPROGRESS)) {
                this.stagingState.fail(BootStrapProgress.NOPROGRESS);
            } else if (!reports.contains((Object)BootStrapProgress.PROGRESSING)) {
                this.applyOldNewConf();
                this.senders.stream().map(LogAppender::getFollower).filter(f -> this.server.getRaftConf().containsInConf(f.getPeer().getId(), new RaftProtos.RaftPeerRole[0])).map(FollowerInfoImpl.class::cast).forEach(FollowerInfoImpl::startAttendVote);
            }
        }
    }

    boolean isBootStrappingPeer(RaftPeerId peerId) {
        return Optional.ofNullable(this.stagingState).map(s -> s.contains(peerId)).orElse(false);
    }

    void submitUpdateCommitEvent() {
        this.eventQueue.submit(this.updateCommitEvent);
    }

    private void updateCommit() {
        this.getMajorityMin(FollowerInfo::getMatchIndex, () -> ((RaftLog)this.raftLog).getFlushIndex(), this.followerMaxGapThreshold).ifPresent(m -> this.updateCommit(((MinMajorityMax)m).majority, ((MinMajorityMax)m).min));
    }

    private Optional<MinMajorityMax> getMajorityMin(ToLongFunction<FollowerInfo> followerIndex, LongSupplier logIndex) {
        return this.getMajorityMin(followerIndex, logIndex, -1L);
    }

    private Optional<MinMajorityMax> getMajorityMin(ToLongFunction<FollowerInfo> followerIndex, LongSupplier logIndex, long gapThreshold) {
        RaftPeerId selfId = this.server.getId();
        RaftConfigurationImpl conf = this.server.getRaftConf();
        List<RaftPeerId> followers = this.voterLists.get(0);
        boolean includeSelf = conf.containsInConf(selfId, new RaftProtos.RaftPeerRole[0]);
        if (followers.isEmpty() && !includeSelf) {
            return Optional.empty();
        }
        long[] indicesInNewConf = this.getSorted(followers, includeSelf, followerIndex, logIndex);
        MinMajorityMax newConf = MinMajorityMax.valueOf(indicesInNewConf, gapThreshold);
        if (!conf.isTransitional()) {
            return Optional.of(newConf);
        }
        List<RaftPeerId> oldFollowers = this.voterLists.get(1);
        boolean includeSelfInOldConf = conf.containsInOldConf(selfId);
        if (oldFollowers.isEmpty() && !includeSelfInOldConf) {
            return Optional.empty();
        }
        long[] indicesInOldConf = this.getSorted(oldFollowers, includeSelfInOldConf, followerIndex, logIndex);
        MinMajorityMax oldConf = MinMajorityMax.valueOf(indicesInOldConf, gapThreshold);
        return Optional.of(newConf.combine(oldConf));
    }

    private void updateCommit(LogEntryHeader[] entriesToCommit) {
        long newCommitIndex = this.raftLog.getLastCommittedIndex();
        this.logMetadata(newCommitIndex);
        this.commitIndexChanged();
        boolean hasConfiguration = false;
        for (LogEntryHeader entry : entriesToCommit) {
            if (entry.getIndex() > newCommitIndex) break;
            hasConfiguration |= entry.getLogEntryBodyCase() == RaftProtos.LogEntryProto.LogEntryBodyCase.CONFIGURATIONENTRY;
            this.raftLog.getRaftLogMetrics().onLogEntryCommitted(entry);
        }
        if (hasConfiguration) {
            this.checkAndUpdateConfiguration();
        }
    }

    private void updateCommit(long majority, long min) {
        long oldLastCommitted = this.raftLog.getLastCommittedIndex();
        if (majority > oldLastCommitted) {
            LogEntryHeader[] entriesToCommit = this.raftLog.getEntries(oldLastCommitted + 1L, majority + 1L);
            if (this.server.getState().updateCommitIndex(majority, this.currentTerm, true)) {
                this.updateCommit(entriesToCommit);
            }
        }
        this.watchRequests.update(RaftProtos.ReplicationLevel.ALL, min);
    }

    private void logMetadata(long commitIndex) {
        this.raftLog.appendMetadata(this.currentTerm, commitIndex);
        this.notifySenders();
    }

    private void checkAndUpdateConfiguration() {
        RaftConfigurationImpl conf = this.server.getRaftConf();
        if (conf.isTransitional()) {
            this.replicateNewConf();
        } else {
            this.pendingRequests.replySetConfiguration(this.server::newSuccessReply);
            if (!conf.containsInConf(this.server.getId(), RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER)) {
                RaftServer.Division.LOG.info("{} is not included in the new configuration {}. Will shutdown server...", (Object)this, (Object)conf);
                try {
                    this.server.properties().minRpcTimeout().sleep();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                this.server.close();
            }
        }
    }

    private void replicateNewConf() {
        RaftConfigurationImpl conf = this.server.getRaftConf();
        RaftConfigurationImpl newConf = RaftConfigurationImpl.newBuilder().setConf(conf).setLogEntryIndex(this.raftLog.getNextIndex()).build();
        this.updateSenders(newConf);
        long index = this.raftLog.append(this.server.getState().getCurrentTerm(), (RaftConfiguration)newConf);
        this.updateConfiguration(index, newConf);
        this.notifySenders();
    }

    private List<FollowerInfo> getFollowerInfos(List<RaftPeerId> followerIDs) {
        ArrayList<FollowerInfo> followerInfos = new ArrayList<FollowerInfo>();
        for (int i = 0; i < followerIDs.size(); ++i) {
            RaftPeerId id = followerIDs.get(i);
            if (!this.peerIdFollowerInfoMap.containsKey(id)) {
                throw new IllegalArgumentException("RaftPeerId:" + id + " not in peerIdFollowerInfoMap of leader:" + this.server.getMemberId());
            }
            followerInfos.add(this.peerIdFollowerInfoMap.get(id));
        }
        return followerInfos;
    }

    private long[] getSorted(List<RaftPeerId> followerIDs, boolean includeSelf, ToLongFunction<FollowerInfo> getFollowerIndex, LongSupplier getLogIndex) {
        int length;
        int n = length = includeSelf ? followerIDs.size() + 1 : followerIDs.size();
        if (length == 0) {
            throw new IllegalArgumentException("followers.size() == " + followerIDs.size() + " and includeSelf == " + includeSelf);
        }
        long[] indices = new long[length];
        List<FollowerInfo> followerInfos = this.getFollowerInfos(followerIDs);
        for (int i = 0; i < followerInfos.size(); ++i) {
            indices[i] = getFollowerIndex.applyAsLong(followerInfos.get(i));
        }
        if (includeSelf) {
            indices[length - 1] = getLogIndex.getAsLong();
        }
        Arrays.sort(indices);
        return indices;
    }

    private List<List<RaftPeerId>> divideFollowers(RaftConfigurationImpl conf) {
        ArrayList<List<RaftPeerId>> lists = new ArrayList<List<RaftPeerId>>(2);
        List listForNew = this.senders.stream().map(LogAppender::getFollowerId).filter(x$0 -> conf.containsInConf((RaftPeerId)x$0, new RaftProtos.RaftPeerRole[0])).collect(Collectors.toList());
        lists.add(listForNew);
        if (conf.isTransitional()) {
            List listForOld = this.senders.stream().map(LogAppender::getFollowerId).filter(conf::containsInOldConf).collect(Collectors.toList());
            lists.add(listForOld);
        }
        return lists;
    }

    private void yieldLeaderToHigherPriorityPeer() {
        if (!this.server.getInfo().isLeader()) {
            return;
        }
        RaftConfigurationImpl conf = this.server.getRaftConf();
        RaftPeer leader = conf.getPeer(this.server.getId(), new RaftProtos.RaftPeerRole[0]);
        if (leader == null) {
            RaftServer.Division.LOG.error("{} the leader {} is not in the conf {}", new Object[]{this, this.server.getId(), conf});
            return;
        }
        int leaderPriority = leader.getPriority();
        for (LogAppender logAppender : this.senders.getSenders()) {
            FollowerInfo followerInfo = logAppender.getFollower();
            RaftPeerId followerID = followerInfo.getPeer().getId();
            RaftPeer follower = conf.getPeer(followerID, new RaftProtos.RaftPeerRole[0]);
            if (follower == null) {
                if (conf.getPeer(followerID, RaftProtos.RaftPeerRole.LISTENER) != null) continue;
                RaftServer.Division.LOG.error("{} the follower {} is not in the conf {}", new Object[]{this, followerID, conf});
                continue;
            }
            int followerPriority = follower.getPriority();
            if (followerPriority <= leaderPriority) continue;
            TermIndex leaderLastEntry = this.server.getState().getLastEntry();
            if (leaderLastEntry == null) {
                RaftServer.Division.LOG.info("{} send StartLeaderElectionRequest to follower:{} on term:{} because follower's priority:{} is higher than leader's:{} and leader's lastEntry is null", new Object[]{this, followerID, this.currentTerm, followerPriority, leaderPriority});
                this.sendStartLeaderElectionToHigherPriorityPeer(followerID, null);
                return;
            }
            if (followerInfo.getMatchIndex() < leaderLastEntry.getIndex()) continue;
            RaftServer.Division.LOG.info("{} send StartLeaderElectionRequest to follower:{} on term:{} because follower's priority:{} is higher than leader's:{} and follower's lastEntry index:{} catch up with leader's:{}", new Object[]{this, followerID, this.currentTerm, followerPriority, leaderPriority, followerInfo.getMatchIndex(), leaderLastEntry.getIndex()});
            this.sendStartLeaderElectionToHigherPriorityPeer(followerID, leaderLastEntry);
            return;
        }
    }

    public boolean checkLeadership() {
        if (!this.server.getInfo().isLeader()) {
            return false;
        }
        if (this.server.getRole().getRoleElapsedTimeMs() < (long)this.server.getMaxTimeoutMs()) {
            return true;
        }
        List<RaftPeerId> activePeers = this.senders.stream().filter(sender -> sender.getFollower().getLastRpcResponseTime().elapsedTimeMs() <= (long)this.server.getMaxTimeoutMs()).map(LogAppender::getFollowerId).collect(Collectors.toList());
        RaftConfigurationImpl conf = this.server.getRaftConf();
        if (conf.hasMajority(activePeers, this.server.getId())) {
            return true;
        }
        RaftServer.Division.LOG.warn(this + ": Lost leadership on term: " + this.currentTerm + ". Election timeout: " + this.server.getMaxTimeoutMs() + "ms. In charge for: " + this.server.getRole().getRoleElapsedTimeMs() + "ms. Conf: " + conf);
        this.senders.stream().map(LogAppender::getFollower).forEach(f -> RaftServer.Division.LOG.warn("Follower {}", f));
        this.stepDown(this.currentTerm, LeaderState.StepDownReason.LOST_MAJORITY_HEARTBEATS);
        return false;
    }

    void replyPendingRequest(long logIndex, RaftClientReply reply) {
        this.pendingRequests.replyPendingRequest(logIndex, reply);
    }

    TransactionContext getTransactionContext(long index) {
        return this.pendingRequests.getTransactionContext(index);
    }

    long[] getFollowerNextIndices() {
        return this.senders.stream().mapToLong(s -> s.getFollower().getNextIndex()).toArray();
    }

    static Map<RaftPeerId, RaftPeer> newMap(Collection<RaftPeer> peers, String str) {
        Objects.requireNonNull(peers, () -> str + " == null");
        HashMap<RaftPeerId, RaftPeer> map = new HashMap<RaftPeerId, RaftPeer>();
        for (RaftPeer p : peers) {
            map.put(p.getId(), p);
        }
        return Collections.unmodifiableMap(map);
    }

    List<RaftPeer> getFollowers() {
        return Collections.unmodifiableList(this.senders.stream().map(sender -> sender.getFollower().getPeer()).filter(peer -> this.server.getRaftConf().containsInConf(peer.getId(), new RaftProtos.RaftPeerRole[0])).collect(Collectors.toList()));
    }

    Stream<LogAppender> getLogAppenders() {
        return this.senders.stream();
    }

    private static boolean isAttendingVote(FollowerInfo follower) {
        return ((FollowerInfoImpl)follower).isAttendingVote();
    }

    public void checkHealth(FollowerInfo follower) {
        TimeDuration elapsedTime = follower.getLastRpcResponseTime().elapsedTime();
        if (elapsedTime.compareTo(this.server.properties().rpcSlownessTimeout()) > 0) {
            RaftProtos.RoleInfoProto leaderInfo = this.server.getInfo().getRoleInfoProto();
            this.server.getStateMachine().leaderEvent().notifyFollowerSlowness(leaderInfo);
            this.server.getStateMachine().leaderEvent().notifyFollowerSlowness(leaderInfo, follower.getPeer());
        }
        RaftPeerId followerId = follower.getPeer().getId();
        this.raftServerMetrics.recordFollowerHeartbeatElapsedTime(followerId, elapsedTime.toLong(TimeUnit.NANOSECONDS));
    }

    public String toString() {
        return this.name;
    }

    private class ConfigurationStagingState {
        private final String name;
        private final Map<RaftPeerId, RaftPeer> newPeers;
        private final Map<RaftPeerId, RaftPeer> newListeners;
        private final PeerConfiguration newConf;

        ConfigurationStagingState(Collection<RaftPeer> newPeers, Collection<RaftPeer> newListeners, PeerConfiguration newConf) {
            this.name = LeaderStateImpl.this.server.getMemberId() + "-" + JavaUtils.getClassSimpleName(this.getClass());
            this.newPeers = LeaderStateImpl.newMap(newPeers, "peer");
            this.newListeners = LeaderStateImpl.newMap(newListeners, "listeners");
            this.newConf = newConf;
        }

        RaftConfigurationImpl generateOldNewConf(RaftConfigurationImpl current, long logIndex) {
            return RaftConfigurationImpl.newBuilder().setConf(this.newConf).setOldConf(current).setLogEntryIndex(logIndex).build();
        }

        Collection<RaftPeer> getNewPeers() {
            return this.newPeers.values();
        }

        Collection<RaftPeer> getNewListeners() {
            return this.newListeners.values();
        }

        boolean contains(RaftPeerId peerId) {
            return this.newPeers.containsKey(peerId) || this.newListeners.containsKey(peerId);
        }

        void fail(BootStrapProgress progress) {
            String message = this + ": Fail to set configuration " + this.newConf + " due to " + (Object)((Object)progress);
            RaftServer.Division.LOG.debug(message);
            LeaderStateImpl.this.stopAndRemoveSenders(s -> !LeaderStateImpl.isAttendingVote(s.getFollower()));
            LeaderStateImpl.this.stagingState = null;
            LeaderStateImpl.this.pendingRequests.failSetConfiguration((RaftException)new ReconfigurationTimeoutException(message));
        }

        public String toString() {
            return this.name;
        }
    }

    static class MinMajorityMax {
        private final long min;
        private final long majority;
        private final long max;

        MinMajorityMax(long min, long majority, long max) {
            this.min = min;
            this.majority = majority;
            this.max = max;
        }

        MinMajorityMax combine(MinMajorityMax that) {
            return new MinMajorityMax(Math.min(this.min, that.min), Math.min(this.majority, that.majority), Math.min(this.max, that.max));
        }

        static MinMajorityMax valueOf(long[] sorted) {
            return new MinMajorityMax(sorted[0], MinMajorityMax.getMajority(sorted), MinMajorityMax.getMax(sorted));
        }

        static MinMajorityMax valueOf(long[] sorted, long gapThreshold) {
            long majority = MinMajorityMax.getMajority(sorted);
            long min = sorted[0];
            if (gapThreshold != -1L && majority - min > gapThreshold) {
                majority = min;
            }
            return new MinMajorityMax(min, majority, MinMajorityMax.getMax(sorted));
        }

        static long getMajority(long[] sorted) {
            return sorted[(sorted.length - 1) / 2];
        }

        static long getMax(long[] sorted) {
            return sorted[sorted.length - 1];
        }
    }

    private class EventProcessor
    extends Daemon {
        public EventProcessor(String name, RaftServerImpl server) {
            super(Daemon.newBuilder().setName(name).setThreadGroup(server.getThreadGroup()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeaderStateImpl.this.prepare();
            while (LeaderStateImpl.this.running) {
                StateUpdateEvent event = LeaderStateImpl.this.eventQueue.poll();
                RaftServerImpl raftServerImpl = LeaderStateImpl.this.server;
                synchronized (raftServerImpl) {
                    if (LeaderStateImpl.this.running) {
                        if (event != null) {
                            event.execute();
                        } else if (LeaderStateImpl.this.inStagingState()) {
                            LeaderStateImpl.this.checkStaging();
                        } else {
                            LeaderStateImpl.this.yieldLeaderToHigherPriorityPeer();
                            LeaderStateImpl.this.checkLeadership();
                        }
                    }
                }
            }
        }
    }

    static class SenderList {
        private final List<LogAppender> senders = new CopyOnWriteArrayList<LogAppender>();

        SenderList() {
        }

        Stream<LogAppender> stream() {
            return this.senders.stream();
        }

        List<LogAppender> getSenders() {
            return this.senders;
        }

        void forEach(Consumer<LogAppender> action) {
            this.senders.forEach(action);
        }

        void addAll(Collection<LogAppender> newSenders) {
            if (newSenders.isEmpty()) {
                return;
            }
            Preconditions.assertUnique((Iterable)CollectionUtils.as(this.senders, LogAppender::getFollowerId), (Iterable)CollectionUtils.as(newSenders, LogAppender::getFollowerId));
            boolean changed = this.senders.addAll(newSenders);
            Preconditions.assertTrue((boolean)changed);
        }

        boolean removeAll(Collection<LogAppender> c) {
            return this.senders.removeAll(c);
        }
    }

    private class EventQueue {
        private final String name;
        private final BlockingQueue<StateUpdateEvent> queue;

        private EventQueue() {
            this.name = LeaderStateImpl.this.server.getMemberId() + "-" + JavaUtils.getClassSimpleName(this.getClass());
            this.queue = new ArrayBlockingQueue<StateUpdateEvent>(4096);
        }

        void submit(StateUpdateEvent event) {
            try {
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                RaftServer.Division.LOG.info("{}: Interrupted when submitting {} ", (Object)this, (Object)event);
                Thread.currentThread().interrupt();
            }
        }

        StateUpdateEvent poll() {
            StateUpdateEvent e;
            try {
                e = this.queue.poll(LeaderStateImpl.this.server.getMaxTimeoutMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                String s = this + ": poll() is interrupted";
                if (!LeaderStateImpl.this.running) {
                    RaftServer.Division.LOG.info(s + " gracefully");
                    return null;
                }
                throw new IllegalStateException(s + " UNEXPECTEDLY", ie);
            }
            if (e != null) {
                while (e.equals(this.queue.peek())) {
                    this.queue.poll();
                }
            }
            return e;
        }

        public String toString() {
            return this.name;
        }
    }

    static class StateUpdateEvent {
        private final Type type;
        private final long newTerm;
        private final Runnable handler;

        StateUpdateEvent(Type type, long newTerm, Runnable handler) {
            this.type = type;
            this.newTerm = newTerm;
            this.handler = handler;
        }

        void execute() {
            this.handler.run();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StateUpdateEvent)) {
                return false;
            }
            StateUpdateEvent that = (StateUpdateEvent)obj;
            return this.type == that.type && this.newTerm == that.newTerm;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.newTerm});
        }

        public String toString() {
            return (Object)((Object)this.type) + (this.newTerm >= 0L ? ":" + this.newTerm : "");
        }

        private static enum Type {
            STEP_DOWN,
            UPDATE_COMMIT,
            CHECK_STAGING;

        }
    }

    private static enum BootStrapProgress {
        NOPROGRESS,
        PROGRESSING,
        CAUGHTUP;

    }
}

