/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import com.google.common.collect.MinMaxPriorityQueue;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class FixedPriorityBlockingQueue<T> {
    private int maxSize;
    private Comparator<T> comparator;
    private MinMaxPriorityQueue<T> queue;
    private ReentrantLock lock = new ReentrantLock();
    private Condition notEmpty = this.lock.newCondition();
    private List<PollLastHook> pollLastHookList = new CopyOnWriteArrayList<PollLastHook>();

    public FixedPriorityBlockingQueue(int maxSize, Comparator<T> comparator) {
        this.maxSize = maxSize;
        this.comparator = comparator;
        this.queue = MinMaxPriorityQueue.orderedBy(comparator).maximumSize(maxSize + 1).create();
    }

    public void put(T element) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            this.queue.add(element);
            if (this.queue.size() > this.maxSize) {
                this.pollLast();
            }
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty()) {
                this.notEmpty.await();
            }
            Object object = this.queue.pollFirst();
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T takeMax() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty()) {
                this.notEmpty.await();
            }
            Object object = this.queue.pollLast();
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void regsitPollLastHook(PollLastHook<T> hook) {
        this.pollLastHookList.add(hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T element) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.queue.contains(element);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (this.queue.size() != 0) {
                this.pollLast();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private void pollLast() {
        ReentrantLock lock = this.lock;
        lock.lock();
        Object element = null;
        try {
            element = this.queue.pollLast();
        }
        finally {
            lock.unlock();
        }
        if (element != null) {
            Object finalElement = element;
            this.pollLastHookList.forEach(x -> x.apply(finalElement));
        }
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String toString() {
        return this.queue.toString();
    }

    @FunctionalInterface
    public static interface PollLastHook<T> {
        public void apply(T var1);
    }
}

