/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.metadata.DiskAlignedChunkMetadataLoader;
import org.apache.iotdb.db.query.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.db.query.reader.chunk.metadata.MemAlignedChunkMetadataLoader;
import org.apache.iotdb.db.query.reader.chunk.metadata.MemChunkMetadataLoader;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class FileLoaderUtils {
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();

    private FileLoaderUtils() {
    }

    public static void updateTsFileResource(TsFileSequenceReader reader, TsFileResource tsFileResource) throws IOException {
        FileLoaderUtils.updateTsFileResource(reader.getAllTimeseriesMetadata(false), tsFileResource);
        tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
        tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
    }

    public static void updateTsFileResource(Map<String, List<TimeseriesMetadata>> device2Metadata, TsFileResource tsFileResource) {
        for (Map.Entry<String, List<TimeseriesMetadata>> entry : device2Metadata.entrySet()) {
            for (TimeseriesMetadata timeseriesMetaData : entry.getValue()) {
                tsFileResource.updateStartTime(entry.getKey(), timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime(entry.getKey(), timeseriesMetaData.getStatistics().getEndTime());
            }
        }
    }

    public static TsFileResource generateTsFileResource(TsFileIOWriter writer) {
        TsFileResource resource = new TsFileResource(writer.getFile());
        for (ChunkGroupMetadata chunkGroupMetadata : writer.getChunkGroupMetadataList()) {
            String device = chunkGroupMetadata.getDevice();
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                resource.updateStartTime(device, chunkMetadata.getStartTime());
                resource.updateEndTime(device, chunkMetadata.getEndTime());
            }
        }
        resource.setStatus(TsFileResourceStatus.CLOSED);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TimeseriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        TimeseriesMetadata timeSeriesMetadata;
        boolean loadFromMem;
        long t1;
        block12: {
            long t2;
            block13: {
                t1 = System.nanoTime();
                loadFromMem = false;
                try {
                    if (resource.isClosed()) {
                        timeSeriesMetadata = TimeSeriesMetadataCache.getInstance().get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFilePath(), seriesPath.getDevice(), seriesPath.getMeasurement()), allSensors, resource.getTimeIndexType() != 1, context.isDebug());
                        if (timeSeriesMetadata != null) {
                            timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskChunkMetadataLoader(resource, seriesPath, context, filter));
                        }
                    } else {
                        loadFromMem = true;
                        timeSeriesMetadata = (TimeseriesMetadata)resource.getTimeSeriesMetadata(seriesPath);
                        if (timeSeriesMetadata != null) {
                            timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemChunkMetadataLoader(resource, seriesPath, context, filter));
                        }
                    }
                    if (timeSeriesMetadata == null) break block12;
                    t2 = System.nanoTime();
                    try {
                        List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), seriesPath);
                        timeSeriesMetadata.setModified(!pathModifications.isEmpty());
                        if (timeSeriesMetadata.getStatistics().getStartTime() > timeSeriesMetadata.getStatistics().getEndTime()) {
                            TimeseriesMetadata timeseriesMetadata = null;
                            QUERY_METRICS.recordSeriesScanCost("timeseries_metadata_modification_nonaligned", System.nanoTime() - t2);
                            QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_nonaligned_mem" : "load_timeseries_metadata_nonaligned_disk", System.nanoTime() - t1);
                            return timeseriesMetadata;
                        }
                    }
                    catch (Throwable throwable) {
                        QUERY_METRICS.recordSeriesScanCost("timeseries_metadata_modification_nonaligned", System.nanoTime() - t2);
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_nonaligned_mem" : "load_timeseries_metadata_nonaligned_disk", System.nanoTime() - t1);
                    throw throwable;
                }
                {
                    if (filter == null || filter.satisfyStartEndTime(timeSeriesMetadata.getStatistics().getStartTime(), timeSeriesMetadata.getStatistics().getEndTime())) break block13;
                    TimeseriesMetadata timeseriesMetadata = null;
                    QUERY_METRICS.recordSeriesScanCost("timeseries_metadata_modification_nonaligned", System.nanoTime() - t2);
                    QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_nonaligned_mem" : "load_timeseries_metadata_nonaligned_disk", System.nanoTime() - t1);
                    return timeseriesMetadata;
                }
            }
            QUERY_METRICS.recordSeriesScanCost("timeseries_metadata_modification_nonaligned", System.nanoTime() - t2);
        }
        TimeseriesMetadata timeseriesMetadata = timeSeriesMetadata;
        QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_nonaligned_mem" : "load_timeseries_metadata_nonaligned_disk", System.nanoTime() - t1);
        return timeseriesMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AlignedTimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, AlignedPath vectorPath, QueryContext context, Filter filter) throws IOException {
        AlignedTimeSeriesMetadata alignedTimeSeriesMetadata;
        boolean loadFromMem;
        long t1;
        block14: {
            boolean modified;
            List valueTimeSeriesMetadataList;
            long t2;
            t1 = System.nanoTime();
            loadFromMem = false;
            try {
                block15: {
                    HashSet<String> allSensors;
                    block18: {
                        Iterator iterator;
                        boolean exist;
                        ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList2;
                        TimeseriesMetadata timeColumn;
                        String deviceId;
                        String filePath;
                        boolean isDebug;
                        TimeSeriesMetadataCache cache;
                        block19: {
                            block17: {
                                alignedTimeSeriesMetadata = null;
                                if (!resource.isClosed()) break block17;
                                cache = TimeSeriesMetadataCache.getInstance();
                                List valueMeasurementList = vectorPath.getMeasurementList();
                                allSensors = new HashSet<String>(valueMeasurementList);
                                allSensors.add("");
                                isDebug = context.isDebug();
                                filePath = resource.getTsFilePath();
                                deviceId = vectorPath.getDevice();
                                timeColumn = cache.get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(filePath, deviceId, ""), allSensors, resource.getTimeIndexType() != 1, isDebug);
                                if (timeColumn == null) break block18;
                                valueTimeSeriesMetadataList2 = new ArrayList<TimeseriesMetadata>(valueMeasurementList.size());
                                exist = false;
                                iterator = valueMeasurementList.iterator();
                                break block19;
                            }
                            loadFromMem = true;
                            alignedTimeSeriesMetadata = (AlignedTimeSeriesMetadata)resource.getTimeSeriesMetadata((PartialPath)vectorPath);
                            if (alignedTimeSeriesMetadata != null) {
                                alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemAlignedChunkMetadataLoader(resource, (PartialPath)vectorPath, context, filter));
                            }
                            break block18;
                        }
                        while (iterator.hasNext()) {
                            String valueMeasurement = (String)iterator.next();
                            TimeseriesMetadata valueColumn = cache.get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(filePath, deviceId, valueMeasurement), allSensors, resource.getTimeIndexType() != 1, isDebug);
                            exist = exist || valueColumn != null;
                            valueTimeSeriesMetadataList2.add(valueColumn);
                        }
                        if (exist) {
                            alignedTimeSeriesMetadata = new AlignedTimeSeriesMetadata(timeColumn, valueTimeSeriesMetadataList2);
                            alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskAlignedChunkMetadataLoader(resource, vectorPath, context, filter));
                        }
                    }
                    if (alignedTimeSeriesMetadata == null) break block14;
                    t2 = System.nanoTime();
                    if (alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime() > alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime()) {
                        allSensors = null;
                        QUERY_METRICS.recordSeriesScanCost("timeseries_metadata_modification_aligned", System.nanoTime() - t2);
                        QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
                        return allSensors;
                    }
                    if (filter == null || filter.satisfyStartEndTime(alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime(), alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime())) break block15;
                    allSensors = null;
                    QUERY_METRICS.recordSeriesScanCost("timeseries_metadata_modification_aligned", System.nanoTime() - t2);
                    QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
                    return allSensors;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                valueTimeSeriesMetadataList = alignedTimeSeriesMetadata.getValueTimeseriesMetadataList();
                modified = false;
            }
            catch (Throwable throwable) {
                QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
                throw throwable;
            }
            for (int i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (valueTimeSeriesMetadataList.get(i) == null) continue;
                List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), vectorPath.getPathWithMeasurement(i));
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).setModified(!pathModifications.isEmpty());
                modified = modified || !pathModifications.isEmpty();
            }
            alignedTimeSeriesMetadata.getTimeseriesMetadata().setModified(modified);
            break block14;
            finally {
                QUERY_METRICS.recordSeriesScanCost("timeseries_metadata_modification_aligned", System.nanoTime() - t2);
            }
        }
        AlignedTimeSeriesMetadata alignedTimeSeriesMetadata2 = alignedTimeSeriesMetadata;
        QUERY_METRICS.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
        return alignedTimeSeriesMetadata2;
    }

    public static List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) throws IOException {
        return timeSeriesMetadata.loadChunkMetadataList();
    }

    public static List<IPageReader> loadPageReaderList(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        if (chunkMetaData == null) {
            throw new IOException("Can't init null chunkMeta");
        }
        IChunkLoader chunkLoader = chunkMetaData.getChunkLoader();
        IChunkReader chunkReader = chunkLoader.getChunkReader(chunkMetaData, timeFilter);
        return chunkReader.loadPageReaderList();
    }
}

