/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.audit.AuditLogger;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.metadata.template.TemplateQueryType;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.parser.ASTVisitor;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.thrift.impl.IClientRPCServiceWithHandler;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSAggregationQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRPCServiceImpl
implements IClientRPCServiceWithHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRPCServiceImpl.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final TSProtocolVersion CURRENT_RPC_VERSION = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    private static final boolean enableAuditLog = config.isEnableAuditLog();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private static final SelectResult SELECT_RESULT = (resp, queryExecution, fetchSize) -> {
        Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, fetchSize);
        resp.setQueryResult((List)pair.left);
        return (Boolean)pair.right;
    };
    private static final SelectResult OLD_SELECT_RESULT = (resp, queryExecution, fetchSize) -> {
        Pair<TSQueryDataSet, Boolean> pair = QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, fetchSize);
        resp.setQueryDataSet((TSQueryDataSet)pair.left);
        return (Boolean)pair.right;
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TSExecuteStatementResp executeStatementInternal(TSExecuteStatementReq req, SelectResult setResult) {
        TSExecuteStatementResp tSExecuteStatementResp;
        SetThreadName threadName;
        StatementType statementType;
        long startTime;
        String statement;
        long queryId;
        boolean finished;
        block29: {
            block30: {
                TSExecuteStatementResp resp;
                ExecutionResult result;
                block26: {
                    TSExecuteStatementResp executionTime3222;
                    block27: {
                        block28: {
                            Statement s;
                            IClientSession clientSession;
                            block23: {
                                TSExecuteStatementResp executionTime22222;
                                block24: {
                                    block25: {
                                        block20: {
                                            TSExecuteStatementResp tSExecuteStatementResp2;
                                            block21: {
                                                block22: {
                                                    finished = false;
                                                    queryId = Long.MIN_VALUE;
                                                    statement = req.getStatement();
                                                    clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                                                    if (!SESSION_MANAGER.checkLogin(clientSession)) {
                                                        return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
                                                    }
                                                    startTime = System.currentTimeMillis();
                                                    statementType = null;
                                                    s = StatementGenerator.createStatement(statement, clientSession.getZoneId());
                                                    if (s != null) break block20;
                                                    tSExecuteStatementResp2 = RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)"This operation type is not supported"));
                                                    COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
                                                    if (!finished) break block21;
                                                    if (statementType == null) break block22;
                                                    long executionTime22222 = COORDINATOR.getTotalExecutionTime(queryId);
                                                    this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statementType, executionTime22222 > 0L ? executionTime22222 : System.currentTimeMillis() - startTime);
                                                }
                                                COORDINATOR.cleanupQueryExecution(queryId);
                                            }
                                            SESSION_MANAGER.updateIdleTime();
                                            return tSExecuteStatementResp2;
                                        }
                                        TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
                                        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block23;
                                        executionTime22222 = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                                        COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
                                        if (!finished) break block24;
                                        if (statementType == null) break block25;
                                        long executionTime3222 = COORDINATOR.getTotalExecutionTime(queryId);
                                        this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statementType, executionTime3222 > 0L ? executionTime3222 : System.currentTimeMillis() - startTime);
                                    }
                                    COORDINATOR.cleanupQueryExecution(queryId);
                                }
                                SESSION_MANAGER.updateIdleTime();
                                return executionTime22222;
                            }
                            statementType = s.getType();
                            if (enableAuditLog) {
                                AuditLogger.log(statement, s);
                            }
                            queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
                            result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), statement, this.partitionFetcher, this.schemaFetcher, req.getTimeout());
                            if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block26;
                            executionTime3222 = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                            COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
                            if (!finished) break block27;
                            if (statementType == null) break block28;
                            long executionTime4 = COORDINATOR.getTotalExecutionTime(queryId);
                            this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statementType, executionTime4 > 0L ? executionTime4 : System.currentTimeMillis() - startTime);
                        }
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    return executionTime3222;
                }
                IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
                threadName = new SetThreadName(result.queryId.getId());
                if (queryExecution != null && queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    finished = setResult.apply(resp, queryExecution, req.fetchSize);
                    resp.setMoreData(!finished);
                } else {
                    finished = true;
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                tSExecuteStatementResp = resp;
                threadName.close();
                COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
                if (!finished) break block29;
                if (statementType == null) break block30;
                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statementType, executionTime > 0L ? executionTime : System.currentTimeMillis() - startTime);
            }
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        SESSION_MANAGER.updateIdleTime();
        return tSExecuteStatementResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            threadName.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        finished = true;
                        TSExecuteStatementResp tSExecuteStatementResp3 = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                        COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
                        if (finished) {
                            if (statementType != null) {
                                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                                this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statementType, executionTime > 0L ? executionTime : System.currentTimeMillis() - startTime);
                            }
                            COORDINATOR.cleanupQueryExecution(queryId);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        return tSExecuteStatementResp3;
                    }
                }
                catch (Throwable throwable3) {
                    COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
                    if (finished) {
                        if (statementType != null) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statementType, executionTime > 0L ? executionTime : System.currentTimeMillis() - startTime);
                        }
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeRawDataQueryInternal(TSRawDataQueryReq req, SelectResult setResult) {
        boolean finished = false;
        long queryId = Long.MIN_VALUE;
        IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
        if (!SESSION_MANAGER.checkLogin(clientSession)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(req, clientSession.getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("execute Raw Data Query: %s", req), s);
            }
            queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException("error code: " + result.status);
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    finished = setResult.apply(resp, queryExecution, req.fetchSize);
                    resp.setMoreData(!finished);
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_RAW_DATA_QUERY)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
            if (finished) {
                this.addStatementExecutionLatency(OperationType.EXECUTE_RAW_DATA_QUERY, StatementType.QUERY, COORDINATOR.getTotalExecutionTime(queryId));
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeLastDataQueryInternal(TSLastDataQueryReq req, SelectResult setResult) {
        boolean finished = false;
        long queryId = Long.MIN_VALUE;
        IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
        if (!SESSION_MANAGER.checkLogin(clientSession)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(req, clientSession.getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("Last Data Query: %s", req), s);
            }
            queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException("error code: " + result.status);
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    finished = setResult.apply(resp, queryExecution, req.fetchSize);
                    resp.setMoreData(!finished);
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_LAST_DATA_QUERY)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
            if (finished) {
                this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, COORDINATOR.getTotalExecutionTime(queryId));
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeAggregationQueryInternal(TSAggregationQueryReq req, SelectResult setResult) {
        boolean finished = false;
        long queryId = Long.MIN_VALUE;
        IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
        if (!SESSION_MANAGER.checkLogin(clientSession)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(req, clientSession.getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException("error code: " + result.status);
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    finished = setResult.apply(resp, queryExecution, req.fetchSize);
                    resp.setMoreData(!finished);
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_LAST_DATA_QUERY)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            COORDINATOR.recordExecutionTime(queryId, System.currentTimeMillis() - startTime);
            if (finished) {
                this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, COORDINATOR.getTotalExecutionTime(queryId));
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementV2(req);
    }

    public TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementV2(req);
    }

    public TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementInternal(req, SELECT_RESULT);
    }

    public TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req) {
        return this.executeRawDataQueryInternal(req, SELECT_RESULT);
    }

    public TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req) {
        return this.executeLastDataQueryInternal(req, SELECT_RESULT);
    }

    public TSExecuteStatementResp executeAggregationQueryV2(TSAggregationQueryReq req) {
        return this.executeAggregationQueryInternal(req, SELECT_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req) {
        IQueryExecution queryExecution;
        TSFetchResultsResp resp;
        StatementType statementType;
        boolean finished;
        long startTime;
        block22: {
            block21: {
                startTime = System.currentTimeMillis();
                finished = false;
                statementType = null;
                IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                if (SESSION_MANAGER.checkLogin(clientSession)) break block21;
                TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
                COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
                if (finished) {
                    if (statementType != null) {
                        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                    }
                    COORDINATOR.cleanupQueryExecution(req.queryId);
                }
                SESSION_MANAGER.updateIdleTime();
                return tSFetchResultsResp;
            }
            resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            queryExecution = COORDINATOR.getQueryExecution(req.queryId);
            if (queryExecution != null) break block22;
            resp.setHasResultSet(false);
            resp.setMoreData(false);
            TSFetchResultsResp tSFetchResultsResp = resp;
            COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
            if (finished) {
                if (statementType != null) {
                    this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                }
                COORDINATOR.cleanupQueryExecution(req.queryId);
            }
            SESSION_MANAGER.updateIdleTime();
            return tSFetchResultsResp;
        }
        statementType = queryExecution.getStatement().getType();
        SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
        try {
            Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, req.fetchSize);
            List result = (List)pair.left;
            finished = (Boolean)pair.right;
            boolean hasResultSet = !result.isEmpty();
            resp.setHasResultSet(hasResultSet);
            resp.setIsAlign(true);
            resp.setQueryResult(result);
            resp.setMoreData(!finished);
            TSFetchResultsResp tSFetchResultsResp = resp;
            queryName.close();
            COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
            if (finished) {
                if (statementType != null) {
                    this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                }
                COORDINATOR.cleanupQueryExecution(req.queryId);
            }
            SESSION_MANAGER.updateIdleTime();
            return tSFetchResultsResp;
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        queryName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
                    COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
                    if (finished) {
                        if (statementType != null) {
                            this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                        }
                        COORDINATOR.cleanupQueryExecution(req.queryId);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    return tSFetchResultsResp;
                }
            }
            catch (Throwable throwable3) {
                COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
                if (finished) {
                    if (statementType != null) {
                        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                    }
                    COORDINATOR.cleanupQueryExecution(req.queryId);
                }
                SESSION_MANAGER.updateIdleTime();
                throw throwable3;
            }
        }
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        IoTDBConstant.ClientVersion clientVersion = this.parseClientVersion(req);
        BasicOpenSessionResp openSessionResp = SESSION_MANAGER.login(SESSION_MANAGER.getCurrSession(), req.username, req.password, req.zoneId, req.client_protocol, clientVersion);
        TSStatus tsStatus = RpcUtils.getStatus((int)openSessionResp.getCode(), (String)openSessionResp.getMessage());
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, CURRENT_RPC_VERSION);
        return resp.setSessionId(openSessionResp.getSessionId());
    }

    private IoTDBConstant.ClientVersion parseClientVersion(TSOpenSessionReq req) {
        Map configuration = req.configuration;
        if (configuration != null && configuration.containsKey("version")) {
            return IoTDBConstant.ClientVersion.valueOf((String)((String)configuration.get("version")));
        }
        return IoTDBConstant.ClientVersion.V_0_12;
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        return new TSStatus(!SESSION_MANAGER.closeSession(SESSION_MANAGER.getCurrSession(), COORDINATOR::cleanupQueryExecution) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        return SESSION_MANAGER.closeOperation(SESSION_MANAGER.getCurrSession(), req.queryId, req.statementId, req.isSetStatementId(), req.isSetQueryId(), COORDINATOR::cleanupQueryExecution);
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        try {
            ZoneId zoneId = SESSION_MANAGER.getCurrSession().getZoneId();
            return new TSGetTimeZoneResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), zoneId != null ? zoneId.toString() : "Unknown time zone");
        }
        catch (Exception e) {
            return new TSGetTimeZoneResp(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.GET_TIME_ZONE, TSStatusCode.GENERATE_TIME_ZONE_ERROR), "Unknown time zone");
        }
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        try {
            SESSION_MANAGER.getCurrSession().setZoneId(ZoneId.of(req.timeZone));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_TIME_ZONE, TSStatusCode.SET_TIME_ZONE_ERROR);
        }
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        properties.setBuildInfo(IoTDBConstant.BUILD_INFO);
        LOGGER.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        properties.setMaxConcurrentClientNum(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum());
        properties.setWatermarkSecretKey(IoTDBDescriptor.getInstance().getConfig().getWatermarkSecretKey());
        properties.setWatermarkBitString(IoTDBDescriptor.getInstance().getConfig().getWatermarkBitString());
        properties.setWatermarkParamMarkRate(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMarkRate());
        properties.setWatermarkParamMaxRightBit(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMaxRightBit());
        properties.setIsReadOnly(CommonDescriptor.getInstance().getConfig().isReadOnly());
        properties.setThriftMaxFrameSize(IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize());
        return properties;
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                return this.getNotLoggedInStatus();
            }
            DatabaseSchemaStatement statement = StatementGenerator.createStatement(storageGroup);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create database %s", storageGroup), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.SET_STORAGE_GROUP, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_STORAGE_GROUP, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementAlias(PathUtils.checkAndReturnSingleMeasurement((String)req.getMeasurementAlias()));
            CreateTimeSeriesStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create timeseries %s", req.getPath()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementAlias(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurementAlias()));
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            CreateAlignedTimeSeriesStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create aligned timeseries %s.%s", req.getPrefixPath(), req.getMeasurements()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_ALIGNED_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_ALIGNED_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementAliasList(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurementAliasList()));
            CreateMultiTimeSeriesStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create %s timeseries, the first is %s", req.getPaths().size(), req.getPaths().get(0)), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_MULTI_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_MULTI_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteTimeseries(long sessionId, List<String> path) {
        TSStatus tSStatus;
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            DeleteTimeSeriesStatement statement = StatementGenerator.createDeleteTimeSeriesStatement(path);
            TSStatus status = AuthorityChecker.checkAuthority(statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            DeleteStorageGroupStatement statement = StatementGenerator.createStatement(storageGroups);
            if (enableAuditLog) {
                AuditLogger.log(String.format("delete databases: %s", storageGroups), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_STORAGE_GROUPS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_STORAGE_GROUPS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        return new TSFetchMetadataResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Fetch Metadata is not supported."));
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        return this.executeStatementInternal(req, OLD_SELECT_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<TSStatus> results = new ArrayList<TSStatus>();
        boolean isAllSuccessful = true;
        IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
        if (!SESSION_MANAGER.checkLogin(clientSession)) {
            return this.getNotLoggedInStatus();
        }
        try {
            for (int i = 0; i < req.getStatements().size(); ++i) {
                TSStatus status;
                Statement s;
                StatementType type;
                long t2;
                String statement;
                block16: {
                    block15: {
                        statement = (String)req.getStatements().get(i);
                        t2 = System.currentTimeMillis();
                        type = null;
                        s = StatementGenerator.createStatement(statement, clientSession.getZoneId());
                        if (s != null) break block15;
                        TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"This operation type is not supported");
                        this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.currentTimeMillis() - t2);
                        return tSStatus;
                    }
                    status = AuthorityChecker.checkAuthority(s, clientSession);
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block16;
                    TSStatus tSStatus = status;
                    this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.currentTimeMillis() - t2);
                    return tSStatus;
                }
                try {
                    if (enableAuditLog) {
                        AuditLogger.log(statement, s);
                    }
                    long queryId = SESSION_MANAGER.requestQueryId();
                    type = s.getType();
                    ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), statement, this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
                    results.add(result.status);
                    this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.currentTimeMillis() - t2);
                    continue;
                }
                catch (Exception e) {
                    try {
                        LOGGER.warn("Error occurred when executing executeBatchStatement: ", (Throwable)e);
                        status = ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_BATCH_STATEMENT));
                        if (status.getCode() != TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()) {
                            isAllSuccessful = false;
                        }
                        results.add(status);
                        this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.currentTimeMillis() - t2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.currentTimeMillis() - t2);
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.addStatementExecutionLatency(OperationType.EXECUTE_BATCH_STATEMENT, StatementType.NULL, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
        return isAllSuccessful ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully") : RpcUtils.getStatus(results);
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        return this.executeStatement(req);
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        return this.executeStatement(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        IQueryExecution queryExecution;
        TSFetchResultsResp resp;
        StatementType statementType;
        long startTime;
        boolean finished;
        block22: {
            block21: {
                finished = false;
                startTime = System.currentTimeMillis();
                statementType = null;
                IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                if (SESSION_MANAGER.checkLogin(clientSession)) break block21;
                TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
                COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
                if (finished) {
                    if (statementType != null) {
                        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                    }
                    COORDINATOR.cleanupQueryExecution(req.queryId);
                }
                SESSION_MANAGER.updateIdleTime();
                return tSFetchResultsResp;
            }
            resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            queryExecution = COORDINATOR.getQueryExecution(req.queryId);
            if (queryExecution != null) break block22;
            resp.setHasResultSet(false);
            resp.setMoreData(true);
            TSFetchResultsResp tSFetchResultsResp = resp;
            COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
            if (finished) {
                if (statementType != null) {
                    this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                }
                COORDINATOR.cleanupQueryExecution(req.queryId);
            }
            SESSION_MANAGER.updateIdleTime();
            return tSFetchResultsResp;
        }
        statementType = queryExecution.getStatement().getType();
        SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
        try {
            Pair<TSQueryDataSet, Boolean> pair = QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, req.fetchSize);
            TSQueryDataSet result = (TSQueryDataSet)pair.left;
            finished = (Boolean)pair.right;
            boolean hasResultSet = result.bufferForTime().limit() != 0;
            resp.setHasResultSet(hasResultSet);
            resp.setQueryDataSet(result);
            resp.setIsAlign(true);
            resp.setMoreData(finished);
            TSFetchResultsResp tSFetchResultsResp = resp;
            queryName.close();
            COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
            if (finished) {
                if (statementType != null) {
                    this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                }
                COORDINATOR.cleanupQueryExecution(req.queryId);
            }
            SESSION_MANAGER.updateIdleTime();
            return tSFetchResultsResp;
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        queryName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
                    COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
                    if (finished) {
                        if (statementType != null) {
                            this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                        }
                        COORDINATOR.cleanupQueryExecution(req.queryId);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    return tSFetchResultsResp;
                }
            }
            catch (Throwable throwable3) {
                COORDINATOR.recordExecutionTime(req.queryId, System.currentTimeMillis() - startTime);
                if (finished) {
                    if (statementType != null) {
                        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, COORDINATOR.getTotalExecutionTime(req.queryId));
                    }
                    COORDINATOR.cleanupQueryExecution(req.queryId);
                }
                SESSION_MANAGER.updateIdleTime();
                throw throwable3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecords(TSInsertRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPaths.get(0), req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_RECORDS, StatementType.BATCH_INSERT_ROWS, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsOfOneDeviceStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPath, req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_RECORDS_OF_ONE_DEVICE, StatementType.BATCH_INSERT_ONE_DEVICE, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsOfOneDeviceStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPath, req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, StatementType.BATCH_INSERT_ONE_DEVICE, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecord(TSInsertRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            InsertRowStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("insertRecord, device %s, time %s", req.getPrefixPath(), req.getTimestamp()), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_RECORD, StatementType.INSERT, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertMultiTabletsStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLETS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLETS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_TABLETS, StatementType.MULTI_BATCH_INSERT, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablet(TSInsertTabletReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            InsertTabletStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLET, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLET, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_TABLET, StatementType.BATCH_INSERT, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPaths.get(0), req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_STRING_RECORDS, StatementType.BATCH_INSERT_ROWS, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        LOGGER.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) {
        LOGGER.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        LOGGER.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        LOGGER.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) {
        LOGGER.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteData(TSDeleteDataReq req) {
        TSStatus tSStatus;
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            DeleteDataStatement statement = StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_DATA, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_DATA, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        return this.executeRawDataQueryInternal(req, OLD_SELECT_RESULT);
    }

    public TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req) {
        return this.executeLastDataQueryInternal(req, OLD_SELECT_RESULT);
    }

    public TSExecuteStatementResp executeAggregationQuery(TSAggregationQueryReq req) {
        return this.executeAggregationQueryInternal(req, OLD_SELECT_RESULT);
    }

    public long requestStatementId(long sessionId) {
        return SESSION_MANAGER.requestStatementId(SESSION_MANAGER.getCurrSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getName()));
            CreateSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("create schema template %s", req.getName()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_SCHEMA_TEMPLATE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_SCHEMA_TEMPLATE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Modify template has not been supported.");
    }

    public TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Modify template has not been supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) {
        TSQueryTemplateResp resp = new TSQueryTemplateResp();
        try {
            Statement statement;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                resp.setStatus(this.getNotLoggedInStatus());
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            if (!req.getName().equals("") && !req.getName().equals("*")) {
                req.setName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getName()));
            }
            if ((statement = StatementGenerator.createStatement(req)) == null) {
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)(TemplateQueryType.values()[req.getQueryType()].name() + "has not been supported.")));
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            switch (TemplateQueryType.values()[req.getQueryType()]) {
                case SHOW_MEASUREMENTS: {
                    resp.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
                    break;
                }
                case SHOW_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_SET_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_USING_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
                    break;
                }
            }
            TSQueryTemplateResp tSQueryTemplateResp = this.executeTemplateQueryStatement(statement, req, resp);
            return tSQueryTemplateResp;
        }
        catch (Exception e) {
            resp.setStatus(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_QUERY_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR));
            TSQueryTemplateResp tSQueryTemplateResp = resp;
            return tSQueryTemplateResp;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSQueryTemplateResp executeTemplateQueryStatement(Statement statement, TSQueryTemplateReq req, TSQueryTemplateResp resp) {
        long startTime = System.currentTimeMillis();
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            TSStatus status = AuthorityChecker.checkAuthority(statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            if (enableAuditLog) {
                AuditLogger.log(String.format("execute Query: %s", statement), statement);
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult executionResult = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), null, this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
            if (executionResult.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && executionResult.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                resp.setStatus(executionResult.status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(executionResult.queryId.getId());
            try {
                ArrayList<String> result = new ArrayList<String>();
                while (queryExecution.hasNextResult()) {
                    Optional<TsBlock> tsBlock;
                    try {
                        tsBlock = queryExecution.getBatchResult();
                    }
                    catch (IoTDBException e) {
                        throw new RuntimeException("Fetch Schema failed. ", e);
                    }
                    if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        result.add(column.getBinary(i).getStringValue());
                    }
                }
                resp.setMeasurements(result);
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully"));
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                threadName.close();
                return tSQueryTemplateResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    resp.setStatus(ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                    TSQueryTemplateResp tSQueryTemplateResp = null;
                    return tSQueryTemplateResp;
                }
            }
        }
        finally {
            this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statement.getType(), System.currentTimeMillis() - startTime);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req) throws TException {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setTemplateName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getTemplateName()));
            SetSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("set schema template %s.%s", req.getTemplateName(), req.getPrefixPath()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IllegalPathException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req) throws TException {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setTemplateName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getTemplateName()));
            UnsetSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("unset schema template %s from %s", req.getTemplateName(), req.getPrefixPath()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IllegalPathException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req) throws TException {
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus = this.getNotLoggedInStatus();
                return tSStatus;
            }
            req.setTemplateName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getTemplateName()));
            DropSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("drop schema template %s", req.getTemplateName()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = status;
                return tSStatus;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus = result.status;
            return tSStatus;
        }
        catch (Exception e) {
            TSStatus tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSStatus handshake(TSyncIdentityInfo info) throws TException {
        return SyncService.getInstance().handshake(info, SESSION_MANAGER.getCurrSession().getClientAddress(), this.partitionFetcher, this.schemaFetcher);
    }

    public TSStatus sendPipeData(ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportPipeData(buff);
    }

    public TSStatus sendFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportFile(metaInfo, buff);
    }

    public TSBackupConfigurationResp getBackupConfiguration() {
        return new TSBackupConfigurationResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSConnectionInfoResp fetchAllConnectionsInfo() throws TException {
        return SESSION_MANAGER.getAllConnectionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecord(TSInsertStringRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            InsertRowStatement statement = StatementGenerator.createStatement(req);
            if (enableAuditLog) {
                AuditLogger.log(String.format("insertStringRecord, device %s, time %s", req.getPrefixPath(), req.getTimestamp()), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_STRING_RECORD, StatementType.INSERT, System.currentTimeMillis() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    private TSExecuteStatementResp createResponse(DatasetHeader header, long queryId) {
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        resp.setColumnNameIndexMap(header.getColumnNameIndexMap());
        resp.setSgColumns(new ArrayList());
        resp.setColumns(header.getRespColumns());
        resp.setDataTypeList(header.getRespDataTypeList());
        resp.setAliasColumns(header.getRespAliasColumns());
        resp.setIgnoreTimeStamp(header.isIgnoreTimestamp());
        resp.setQueryId(queryId);
        return resp;
    }

    private TSStatus getNotLoggedInStatus() {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN, (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private void addStatementExecutionLatency(OperationType operation, StatementType statementType, long costTime) {
        if (statementType == null) {
            return;
        }
        MetricService.getInstance().timer(costTime, TimeUnit.MILLISECONDS, Metric.PERFORMANCE_OVERVIEW.toString(), MetricLevel.IMPORTANT, new String[]{Tag.INTERFACE.toString(), operation.toString(), Tag.TYPE.toString(), statementType.name()});
    }

    private String checkIdentifierAndRemoveBackQuotesIfNecessary(String identifier) {
        return identifier == null ? null : ASTVisitor.parseIdentifier(identifier);
    }

    @Override
    public void handleClientExit() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        if (session != null) {
            TSCloseSessionReq req = new TSCloseSessionReq();
            this.closeSession(req);
        }
        SyncService.getInstance().handleClientExit();
    }

    @FunctionalInterface
    public static interface SelectResult {
        public boolean apply(TSExecuteStatementResp var1, IQueryExecution var2, int var3) throws IoTDBException, IOException;
    }
}

