/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class DatabaseSchemaStatement
extends Statement
implements IConfigStatement {
    private final DatabaseSchemaStatementType subType;
    private PartialPath storageGroupPath;
    private Long TTL = null;
    private Integer schemaReplicationFactor = null;
    private Integer dataReplicationFactor = null;
    private Long timePartitionInterval = null;
    private Integer schemaRegionGroupNum = null;
    private Integer dataRegionGroupNum = null;

    public DatabaseSchemaStatement(DatabaseSchemaStatementType subType) {
        this.subType = subType;
        this.statementType = StatementType.STORAGE_GROUP_SCHEMA;
    }

    public DatabaseSchemaStatementType getSubType() {
        return this.subType;
    }

    public PartialPath getStorageGroupPath() {
        return this.storageGroupPath;
    }

    public void setStorageGroupPath(PartialPath storageGroupPath) {
        this.storageGroupPath = storageGroupPath;
    }

    public Long getTTL() {
        return this.TTL;
    }

    public void setTTL(Long TTL) {
        this.TTL = TTL;
    }

    public Integer getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public void setSchemaReplicationFactor(Integer schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public Integer getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public void setDataReplicationFactor(Integer dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public Long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(Long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public Integer getSchemaRegionGroupNum() {
        return this.schemaRegionGroupNum;
    }

    public void setSchemaRegionGroupNum(Integer schemaRegionGroupNum) {
        this.schemaRegionGroupNum = schemaRegionGroupNum;
    }

    public Integer getDataRegionGroupNum() {
        return this.dataRegionGroupNum;
    }

    public void setDataRegionGroupNum(Integer dataRegionGroupNum) {
        this.dataRegionGroupNum = dataRegionGroupNum;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        switch (this.subType) {
            case CREATE: {
                return visitor.visitSetDatabase(this, context);
            }
        }
        return visitor.visitAlterDatabase(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return this.storageGroupPath != null ? Collections.singletonList(this.storageGroupPath) : Collections.emptyList();
    }

    public String toString() {
        return "SetStorageGroupStatement{storageGroupPath=" + this.storageGroupPath + ", ttl=" + this.TTL + ", schemaReplicationFactor=" + this.schemaReplicationFactor + ", dataReplicationFactor=" + this.dataReplicationFactor + ", timePartitionInterval=" + this.timePartitionInterval + ", schemaRegionGroupNum=" + this.schemaRegionGroupNum + ", dataRegionGroupNum=" + this.dataRegionGroupNum + '}';
    }

    public static enum DatabaseSchemaStatementType {
        CREATE,
        ALTER;

    }
}

