/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.AsyncSendPlanNodeHandler;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPlanNodeSender {
    private static final Logger logger = LoggerFactory.getLogger(AsyncPlanNodeSender.class);
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;
    private final List<FragmentInstance> instances;
    private final Map<Integer, TSendPlanNodeResp> instanceId2RespMap;
    private final AtomicLong pendingNumber;

    public AsyncPlanNodeSender(IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager, List<FragmentInstance> instances) {
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
        this.instances = instances;
        this.instanceId2RespMap = new ConcurrentHashMap<Integer, TSendPlanNodeResp>();
        this.pendingNumber = new AtomicLong(instances.size());
    }

    public void sendAll() {
        long startSendTime = System.nanoTime();
        for (int i = 0; i < this.instances.size(); ++i) {
            FragmentInstance instance = this.instances.get(i);
            AsyncSendPlanNodeHandler handler = new AsyncSendPlanNodeHandler(i, this.pendingNumber, this.instanceId2RespMap, startSendTime);
            try {
                TSendPlanNodeReq sendPlanNodeReq = new TSendPlanNodeReq(new TPlanNode(instance.getFragment().getPlanNodeTree().serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId());
                AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.asyncInternalServiceClientManager.borrowClient((Object)instance.getHostDataNode().getInternalEndPoint());
                client.sendPlanNode(sendPlanNodeReq, (AsyncMethodCallback)handler);
                continue;
            }
            catch (Exception e) {
                handler.onError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCompleted() throws InterruptedException {
        AtomicLong atomicLong = this.pendingNumber;
        synchronized (atomicLong) {
            while (this.pendingNumber.get() != 0L) {
                this.pendingNumber.wait();
            }
        }
    }

    public List<TSStatus> getFailureStatusList() {
        ArrayList<TSStatus> failureStatusList = new ArrayList<TSStatus>();
        for (Map.Entry<Integer, TSendPlanNodeResp> entry : this.instanceId2RespMap.entrySet()) {
            TSStatus status = entry.getValue().getStatus();
            if (!entry.getValue().accepted) {
                if (status == null) {
                    logger.warn("dispatch write failed. message: {}, node {}", (Object)entry.getValue().message, (Object)this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint());
                    failureStatusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)entry.getValue().getMessage()));
                    continue;
                }
                logger.warn("dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{entry.getValue().status, TSStatusCode.representOf((int)status.code), entry.getValue().message, this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint()});
                failureStatusList.add(status);
                continue;
            }
            if (status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            failureStatusList.add(status);
        }
        return failureStatusList;
    }

    public Future<FragInstanceDispatchResult> getResult() {
        for (Map.Entry<Integer, TSendPlanNodeResp> entry : this.instanceId2RespMap.entrySet()) {
            if (entry.getValue().accepted) continue;
            logger.warn("dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{entry.getValue().status, TSStatusCode.representOf((int)entry.getValue().status.code), entry.getValue().message, this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint()});
            if (entry.getValue().getStatus() == null) {
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)entry.getValue().getMessage())));
            }
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(entry.getValue().getStatus()));
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
    }
}

