/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.mpp.execution.schedule.DriverScheduler;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DriverSchedulerMetricSet
implements IMetricSet {
    private static final String metric = Metric.DRIVER_SCHEDULER.toString();
    public static final String READY_QUEUED_TIME = "ready_queued_time";
    public static final String BLOCK_QUEUED_TIME = "block_queued_time";
    public static final String READY_QUEUE_TASK_COUNT = "ready_queue_task_count";
    public static final String BLOCK_QUEUE_TASK_COUNT = "block_queue_task_count";

    public void bindTo(AbstractMetricService metricService) {
        metricService.getOrCreateTimer(metric, MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), READY_QUEUED_TIME});
        metricService.getOrCreateTimer(metric, MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), BLOCK_QUEUED_TIME});
        metricService.createAutoGauge(metric, MetricLevel.IMPORTANT, (Object)DriverScheduler.getInstance(), DriverScheduler::getReadyQueueTaskCount, new String[]{Tag.NAME.toString(), READY_QUEUE_TASK_COUNT});
        metricService.createAutoGauge(metric, MetricLevel.IMPORTANT, (Object)DriverScheduler.getInstance(), DriverScheduler::getBlockQueueTaskCount, new String[]{Tag.NAME.toString(), BLOCK_QUEUE_TASK_COUNT});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.TIMER, metric, new String[]{Tag.NAME.toString(), READY_QUEUED_TIME});
        metricService.remove(MetricType.TIMER, metric, new String[]{Tag.NAME.toString(), BLOCK_QUEUED_TIME});
        metricService.remove(MetricType.AUTO_GAUGE, metric, new String[]{Tag.NAME.toString(), READY_QUEUE_TASK_COUNT});
        metricService.remove(MetricType.AUTO_GAUGE, metric, new String[]{Tag.NAME.toString(), BLOCK_QUEUE_TASK_COUNT});
    }
}

