/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DataExchangeCostMetricSet
implements IMetricSet {
    private static final String metric = Metric.DATA_EXCHANGE_COST.toString();
    public static final Map<String, MetricInfo> metricInfoMap = new HashMap<String, MetricInfo>();
    public static final String SOURCE_HANDLE_GET_TSBLOCK_LOCAL = "source_handle_get_tsblock_local";
    public static final String SOURCE_HANDLE_GET_TSBLOCK_REMOTE = "source_handle_get_tsblock_remote";
    public static final String SOURCE_HANDLE_DESERIALIZE_TSBLOCK_LOCAL = "source_handle_deserialize_tsblock_local";
    public static final String SOURCE_HANDLE_DESERIALIZE_TSBLOCK_REMOTE = "source_handle_deserialize_tsblock_remote";
    public static final String SINK_HANDLE_SEND_TSBLOCK_LOCAL = "sink_handle_send_tsblock_local";
    public static final String SINK_HANDLE_SEND_TSBLOCK_REMOTE = "sink_handle_send_tsblock_remote";
    public static final String SEND_NEW_DATA_BLOCK_EVENT_TASK_CALLER = "send_new_data_block_event_task_caller";
    public static final String SEND_NEW_DATA_BLOCK_EVENT_TASK_SERVER = "send_new_data_block_event_task_server";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK_CALLER = "on_acknowledge_data_block_event_task_caller";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK_SERVER = "on_acknowledge_data_block_event_task_server";
    public static final String GET_DATA_BLOCK_TASK_CALLER = "get_data_block_task_caller";
    public static final String GET_DATA_BLOCK_TASK_SERVER = "get_data_block_task_server";

    public void bindTo(AbstractMetricService metricService) {
        for (MetricInfo metricInfo : metricInfoMap.values()) {
            metricService.getOrCreateTimer(metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        for (MetricInfo metricInfo : metricInfoMap.values()) {
            metricService.remove(MetricType.TIMER, metric, metricInfo.getTagsInArray());
        }
    }

    static {
        metricInfoMap.put(SOURCE_HANDLE_GET_TSBLOCK_LOCAL, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "source_handle_get_tsblock", Tag.TYPE.toString(), "local"}));
        metricInfoMap.put(SOURCE_HANDLE_GET_TSBLOCK_REMOTE, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "source_handle_get_tsblock", Tag.TYPE.toString(), "remote"}));
        metricInfoMap.put(SOURCE_HANDLE_DESERIALIZE_TSBLOCK_LOCAL, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "source_handle_deserialize_tsblock", Tag.TYPE.toString(), "local"}));
        metricInfoMap.put(SOURCE_HANDLE_DESERIALIZE_TSBLOCK_REMOTE, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "source_handle_deserialize_tsblock", Tag.TYPE.toString(), "remote"}));
        metricInfoMap.put(SINK_HANDLE_SEND_TSBLOCK_LOCAL, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "sink_handle_send_tsblock", Tag.TYPE.toString(), "local"}));
        metricInfoMap.put(SINK_HANDLE_SEND_TSBLOCK_REMOTE, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "sink_handle_send_tsblock", Tag.TYPE.toString(), "remote"}));
        metricInfoMap.put(SEND_NEW_DATA_BLOCK_EVENT_TASK_CALLER, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "send_new_data_block_event_task", Tag.TYPE.toString(), "caller"}));
        metricInfoMap.put(SEND_NEW_DATA_BLOCK_EVENT_TASK_SERVER, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "send_new_data_block_event_task", Tag.TYPE.toString(), "server"}));
        metricInfoMap.put(ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK_CALLER, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "on_acknowledge_data_block_event_task", Tag.TYPE.toString(), "caller"}));
        metricInfoMap.put(ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK_SERVER, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "on_acknowledge_data_block_event_task", Tag.TYPE.toString(), "server"}));
        metricInfoMap.put(GET_DATA_BLOCK_TASK_CALLER, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "get_data_block_task", Tag.TYPE.toString(), "caller"}));
        metricInfoMap.put(GET_DATA_BLOCK_TASK_SERVER, new MetricInfo(MetricType.TIMER, metric, new String[]{Tag.OPERATION.toString(), "get_data_block_task", Tag.TYPE.toString(), "server"}));
    }
}

