/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    public static final String CONFIG_NAME = "iotdb-common.properties";
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.commons.auth.authorizer.LocalFileAuthorizer";
    private String encryptDecryptProvider = "org.apache.iotdb.commons.security.encrypt.MessageDigestEncrypt";
    private String encryptDecryptProviderParameter;
    private String adminName = "root";
    private String adminPassword = "root";
    private String userFolder = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system" + File.separator + "users";
    private String roleFolder = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system" + File.separator + "roles";
    private String procedureWalFolder = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system" + File.separator + "procedure";
    private String syncDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "sync";
    private String[] walDirs = new String[]{IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "wal"};
    private FSType systemFileStorageFs = FSType.LOCAL;
    private long defaultTTLInMs = Long.MAX_VALUE;
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(20L);
    private int selectorNumOfClientManager = 1;
    private boolean isRpcThriftCompressionEnabled = false;
    private int coreClientNumForEachNode = 200;
    private int maxClientNumForEachNode = 300;
    private HandleSystemErrorStrategy handleSystemErrorStrategy = HandleSystemErrorStrategy.CHANGE_TO_READ_ONLY;
    private volatile NodeStatus status = NodeStatus.Running;
    private volatile boolean isStopping = false;
    private volatile String statusReason = null;
    private double diskSpaceWarningThreshold = 0.05;
    private TEndPoint targetMLNodeEndPoint = new TEndPoint("127.0.0.1", 10810);

    CommonConfig() {
    }

    public void updatePath(String homeDir) {
        this.userFolder = this.addHomeDir(this.userFolder, homeDir);
        this.roleFolder = this.addHomeDir(this.roleFolder, homeDir);
        this.procedureWalFolder = this.addHomeDir(this.procedureWalFolder, homeDir);
        this.syncDir = this.addHomeDir(this.syncDir, homeDir);
        for (int i = 0; i < this.walDirs.length; ++i) {
            this.walDirs[i] = this.addHomeDir(this.walDirs[i], homeDir);
        }
    }

    private String addHomeDir(String dir, String homeDir) {
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    public String getEncryptDecryptProvider() {
        return this.encryptDecryptProvider;
    }

    public void setEncryptDecryptProvider(String encryptDecryptProvider) {
        this.encryptDecryptProvider = encryptDecryptProvider;
    }

    public String getEncryptDecryptProviderParameter() {
        return this.encryptDecryptProviderParameter;
    }

    public void setEncryptDecryptProviderParameter(String encryptDecryptProviderParameter) {
        this.encryptDecryptProviderParameter = encryptDecryptProviderParameter;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public void setUserFolder(String userFolder) {
        this.userFolder = userFolder;
    }

    public String getRoleFolder() {
        return this.roleFolder;
    }

    public void setRoleFolder(String roleFolder) {
        this.roleFolder = roleFolder;
    }

    public String getProcedureWalFolder() {
        return this.procedureWalFolder;
    }

    public void setProcedureWalFolder(String procedureWalFolder) {
        this.procedureWalFolder = procedureWalFolder;
    }

    public String getSyncDir() {
        return this.syncDir;
    }

    public void setSyncDir(String syncDir) {
        this.syncDir = syncDir;
    }

    public String[] getWalDirs() {
        return this.walDirs;
    }

    public void setWalDirs(String[] walDirs) {
        this.walDirs = walDirs;
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(FSType systemFileStorageFs) {
        this.systemFileStorageFs = systemFileStorageFs;
    }

    public long getDefaultTTLInMs() {
        return this.defaultTTLInMs;
    }

    public void setDefaultTTLInMs(long defaultTTLInMs) {
        this.defaultTTLInMs = defaultTTLInMs;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    public void setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
        this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public void setMaxClientNumForEachNode(int maxClientNumForEachNode) {
        this.maxClientNumForEachNode = maxClientNumForEachNode;
    }

    public int getCoreClientNumForEachNode() {
        return this.coreClientNumForEachNode;
    }

    public void setCoreClientNumForEachNode(int coreClientNumForEachNode) {
        this.coreClientNumForEachNode = coreClientNumForEachNode;
    }

    HandleSystemErrorStrategy getHandleSystemErrorStrategy() {
        return this.handleSystemErrorStrategy;
    }

    void setHandleSystemErrorStrategy(HandleSystemErrorStrategy handleSystemErrorStrategy) {
        this.handleSystemErrorStrategy = handleSystemErrorStrategy;
    }

    public void handleUnrecoverableError() {
        this.handleSystemErrorStrategy.handle();
    }

    public double getDiskSpaceWarningThreshold() {
        return this.diskSpaceWarningThreshold;
    }

    public void setDiskSpaceWarningThreshold(double diskSpaceWarningThreshold) {
        this.diskSpaceWarningThreshold = diskSpaceWarningThreshold;
    }

    public boolean isReadOnly() {
        return this.status == NodeStatus.ReadOnly;
    }

    public NodeStatus getNodeStatus() {
        return this.status;
    }

    public void setNodeStatus(NodeStatus newStatus) {
        logger.info("Set system mode from {} to {}.", (Object)this.status, (Object)newStatus);
        this.status = newStatus;
        this.statusReason = null;
        switch (newStatus) {
            case ReadOnly: {
                logger.warn("Change system status to ReadOnly! Only query statements are permitted!");
                break;
            }
            case Removing: {
                logger.info("Change system status to Removing! The current Node is being removed from cluster!");
                break;
            }
        }
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(NodeStatus status) {
        this.status = status;
    }

    public TEndPoint getTargetMLNodeEndPoint() {
        return this.targetMLNodeEndPoint;
    }

    public void setTargetMLNodeEndPoint(TEndPoint targetMLNodeEndPoint) {
        this.targetMLNodeEndPoint = targetMLNodeEndPoint;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public void setStopping(boolean stopping) {
        this.isStopping = stopping;
    }
}

