/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.rpc.AutoScalingBufferWriteTransport;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TByteBuffer;
import org.apache.thrift.transport.TTransport;

public class Utils {
    private static final int TEMP_BUFFER_SIZE = 1024;
    private static final byte PADDING_MAGIC = 71;

    private Utils() {
    }

    public static String hostAddress(TEndPoint endpoint) {
        return String.format("%s:%d", endpoint.getIp(), endpoint.getPort());
    }

    public static String fromTEndPointToString(TEndPoint endpoint) {
        return String.format("%s_%d", endpoint.getIp(), endpoint.getPort());
    }

    public static long groupEncode(ConsensusGroupId consensusGroupId) {
        long groupType = consensusGroupId.getType().getValue();
        long groupCode = groupType << 32;
        return groupCode += (long)consensusGroupId.getId();
    }

    public static RaftPeerId fromNodeIdToRaftPeerId(int nodeId) {
        return RaftPeerId.valueOf((String)String.valueOf(nodeId));
    }

    public static TEndPoint fromRaftPeerAddressToTEndPoint(String address) {
        String[] items = address.split(":");
        return new TEndPoint(items[0], Integer.parseInt(items[1]));
    }

    public static int fromRaftPeerIdToNodeId(RaftPeerId id) {
        return Integer.parseInt(id.toString());
    }

    public static TEndPoint fromRaftPeerProtoToTEndPoint(RaftProtos.RaftPeerProto proto) {
        String[] items = proto.getAddress().split(":");
        return new TEndPoint(items[0], Integer.parseInt(items[1]));
    }

    public static RaftPeer fromNodeInfoAndPriorityToRaftPeer(int nodeId, TEndPoint endpoint, int priority) {
        return RaftPeer.newBuilder().setId(Utils.fromNodeIdToRaftPeerId(nodeId)).setAddress(Utils.hostAddress(endpoint)).setPriority(priority).build();
    }

    public static RaftPeer fromPeerAndPriorityToRaftPeer(Peer peer, int priority) {
        return Utils.fromNodeInfoAndPriorityToRaftPeer(peer.getNodeId(), peer.getEndpoint(), priority);
    }

    public static List<RaftPeer> fromPeersAndPriorityToRaftPeers(List<Peer> peers, int priority) {
        return peers.stream().map(peer -> Utils.fromPeerAndPriorityToRaftPeer(peer, priority)).collect(Collectors.toList());
    }

    public static int fromRaftPeerProtoToNodeId(RaftProtos.RaftPeerProto proto) {
        return Integer.parseInt(proto.getId().toStringUtf8());
    }

    public static List<Peer> fromRaftProtoListAndRaftGroupIdToPeers(List<RaftProtos.RaftPeerProto> raftProtoList, RaftGroupId id) {
        ConsensusGroupId consensusGroupId = Utils.fromRaftGroupIdToConsensusGroupId(id);
        return raftProtoList.stream().map(peer -> new Peer(consensusGroupId, Utils.fromRaftPeerProtoToNodeId(peer), Utils.fromRaftPeerProtoToTEndPoint(peer))).collect(Collectors.toList());
    }

    public static RaftGroupId fromConsensusGroupIdToRaftGroupId(ConsensusGroupId consensusGroupId) {
        long groupCode = Utils.groupEncode(consensusGroupId);
        byte[] bGroupCode = ByteBuffer.allocate(8).putLong(groupCode).array();
        byte[] bPaddedGroupName = new byte[16];
        for (int i = 0; i < 10; ++i) {
            bPaddedGroupName[i] = 71;
        }
        System.arraycopy(bGroupCode, 2, bPaddedGroupName, 10, bGroupCode.length - 2);
        return RaftGroupId.valueOf((ByteString)ByteString.copyFrom((byte[])bPaddedGroupName));
    }

    public static ConsensusGroupId fromRaftGroupIdToConsensusGroupId(RaftGroupId raftGroupId) {
        byte[] padded = raftGroupId.toByteString().toByteArray();
        long type = (long)((padded[10] & 0xFF) << 8) + (long)(padded[11] & 0xFF);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(padded, 12, 4);
        byteBuffer.flip();
        return ConsensusGroupId.Factory.create((int)((int)type), (int)byteBuffer.getInt());
    }

    public static ByteBuffer serializeTSStatus(TSStatus status) throws TException {
        AutoScalingBufferWriteTransport byteBuffer = new AutoScalingBufferWriteTransport(1024);
        TCompactProtocol protocol = new TCompactProtocol((TTransport)byteBuffer);
        status.write((TProtocol)protocol);
        return ByteBuffer.wrap(byteBuffer.getBuffer());
    }

    public static TSStatus deserializeFrom(ByteBuffer buffer) throws TException {
        TSStatus status = new TSStatus();
        TByteBuffer byteBuffer = new TByteBuffer(buffer);
        TCompactProtocol protocol = new TCompactProtocol((TTransport)byteBuffer);
        status.read((TProtocol)protocol);
        return status;
    }

    public static String getMetadataFromTermIndex(TermIndex termIndex) {
        return String.format("%d_%d", termIndex.getTerm(), termIndex.getIndex());
    }

    public static TermIndex getTermIndexFromDir(File snapshotDir) {
        return Utils.getTermIndexFromMetadataString(snapshotDir.getName());
    }

    public static TermIndex getTermIndexFromMetadataString(String metadata) {
        String[] items = metadata.split("_");
        return TermIndex.valueOf((long)Long.parseLong(items[0]), (long)Long.parseLong(items[1]));
    }

    public static void initRatisConfig(RaftProperties properties, RatisConfig config) {
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)config.getGrpc().getMessageSizeMax());
        GrpcConfigKeys.setFlowControlWindow((RaftProperties)properties, (SizeInBytes)config.getGrpc().getFlowControlWindow());
        GrpcConfigKeys.Server.setAsyncRequestThreadPoolCached((RaftProperties)properties, (boolean)config.getGrpc().isAsyncRequestThreadPoolCached());
        GrpcConfigKeys.Server.setAsyncRequestThreadPoolSize((RaftProperties)properties, (int)config.getGrpc().getAsyncRequestThreadPoolSize());
        GrpcConfigKeys.Server.setLeaderOutstandingAppendsMax((RaftProperties)properties, (int)config.getGrpc().getLeaderOutstandingAppendsMax());
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)properties, (TimeDuration)config.getRpc().getSlownessTimeout());
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)config.getRpc().getTimeoutMin());
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)config.getRpc().getTimeoutMax());
        RaftServerConfigKeys.Rpc.setSleepTime((RaftProperties)properties, (TimeDuration)config.getRpc().getSleepTime());
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)config.getRpc().getRequestTimeout());
        RaftServerConfigKeys.LeaderElection.setLeaderStepDownWaitTime((RaftProperties)properties, (TimeDuration)config.getLeaderElection().getLeaderStepDownWaitTimeKey());
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)config.getLeaderElection().isPreVote());
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)config.getSnapshot().isAutoTriggerEnabled());
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)config.getSnapshot().getAutoTriggerThreshold());
        RaftServerConfigKeys.Snapshot.setCreationGap((RaftProperties)properties, (long)config.getSnapshot().getCreationGap());
        RaftServerConfigKeys.Snapshot.setRetentionFileNum((RaftProperties)properties, (int)config.getSnapshot().getRetentionFileNum());
        RaftServerConfigKeys.ThreadPool.setClientCached((RaftProperties)properties, (boolean)config.getThreadPool().isClientCached());
        RaftServerConfigKeys.ThreadPool.setClientSize((RaftProperties)properties, (int)config.getThreadPool().getClientSize());
        RaftServerConfigKeys.ThreadPool.setProxyCached((RaftProperties)properties, (boolean)config.getThreadPool().isProxyCached());
        RaftServerConfigKeys.ThreadPool.setProxySize((RaftProperties)properties, (int)config.getThreadPool().getProxySize());
        RaftServerConfigKeys.ThreadPool.setServerCached((RaftProperties)properties, (boolean)config.getThreadPool().isServerCached());
        RaftServerConfigKeys.ThreadPool.setServerSize((RaftProperties)properties, (int)config.getThreadPool().getServerSize());
        RaftServerConfigKeys.Log.setUseMemory((RaftProperties)properties, (boolean)config.getLog().isUseMemory());
        RaftServerConfigKeys.Log.setQueueElementLimit((RaftProperties)properties, (int)config.getLog().getQueueElementLimit());
        RaftServerConfigKeys.Log.setQueueByteLimit((RaftProperties)properties, (SizeInBytes)config.getLog().getQueueByteLimit());
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)properties, (int)config.getLog().getPurgeGap());
        RaftServerConfigKeys.Log.setPurgeUptoSnapshotIndex((RaftProperties)properties, (boolean)config.getLog().isPurgeUptoSnapshotIndex());
        RaftServerConfigKeys.Log.setPurgePreservationLogNum((RaftProperties)properties, (long)config.getLog().getPreserveNumsWhenPurge());
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)config.getLog().getSegmentSizeMax());
        RaftServerConfigKeys.Log.setSegmentCacheNumMax((RaftProperties)properties, (int)config.getLog().getSegmentCacheNumMax());
        RaftServerConfigKeys.Log.setSegmentCacheSizeMax((RaftProperties)properties, (SizeInBytes)config.getLog().getSegmentCacheSizeMax());
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)config.getLog().getPreallocatedSize());
        RaftServerConfigKeys.Log.setWriteBufferSize((RaftProperties)properties, (SizeInBytes)config.getLog().getWriteBufferSize());
        RaftServerConfigKeys.Log.setForceSyncNum((RaftProperties)properties, (int)config.getLog().getForceSyncNum());
        RaftServerConfigKeys.Log.setUnsafeFlushEnabled((RaftProperties)properties, (boolean)config.getLog().isUnsafeFlushEnabled());
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)config.getLeaderLogAppender().getBufferByteLimit());
        RaftServerConfigKeys.Log.Appender.setSnapshotChunkSizeMax((RaftProperties)properties, (SizeInBytes)config.getLeaderLogAppender().getSnapshotChunkSizeMax());
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)properties, (boolean)config.getLeaderLogAppender().isInstallSnapshotEnabled());
        GrpcConfigKeys.Server.setHeartbeatChannel((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMin((RaftProperties)properties, (TimeDuration)config.getRpc().getFirstElectionTimeoutMin());
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMax((RaftProperties)properties, (TimeDuration)config.getRpc().getFirstElectionTimeoutMax());
    }
}

