/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SortNode
extends SingleChildProcessNode {
    private final Ordering sortOrder;

    public SortNode(PlanNodeId id, Ordering sortOrder) {
        super(id);
        this.sortOrder = sortOrder;
    }

    public SortNode(PlanNodeId id, PlanNode child, Ordering sortOrder) {
        super(id, child);
        this.sortOrder = sortOrder;
    }

    public Ordering getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public PlanNode clone() {
        return new SortNode(this.getPlanNodeId(), this.sortOrder);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SORT.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.sortOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SORT.serialize(stream);
        ReadWriteIOUtils.write((int)this.sortOrder.ordinal(), (OutputStream)stream);
    }

    public static SortNode deserialize(ByteBuffer byteBuffer) {
        Ordering orderBy = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SortNode(planNodeId, orderBy);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SortNode sortNode = (SortNode)o;
        return this.sortOrder == sortNode.sortOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sortOrder});
    }
}

