/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class NodeManagementMemoryMergeNode
extends ProcessNode {
    private final Set<TSchemaNode> data;
    private PlanNode child;

    public NodeManagementMemoryMergeNode(PlanNodeId id, Set<TSchemaNode> data) {
        super(id);
        this.data = data;
    }

    public Set<TSchemaNode> getData() {
        return this.data;
    }

    public PlanNode getChild() {
        return this.child;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public PlanNode clone() {
        return new NodeManagementMemoryMergeNode(this.getPlanNodeId(), this.data);
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitNodeManagementMemoryMerge(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.NODE_MANAGEMENT_MEMORY_MERGE.serialize(byteBuffer);
        int size = this.data.size();
        ReadWriteIOUtils.write((int)size, (ByteBuffer)byteBuffer);
        this.data.forEach(node -> ThriftCommonsSerDeUtils.serializeTSchemaNode((TSchemaNode)node, (ByteBuffer)byteBuffer));
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.NODE_MANAGEMENT_MEMORY_MERGE.serialize(stream);
        int size = this.data.size();
        ReadWriteIOUtils.write((int)size, (OutputStream)stream);
        this.data.forEach(node -> ThriftCommonsSerDeUtils.serializeTSchemaNode((TSchemaNode)node, (DataOutputStream)stream));
    }

    public static NodeManagementMemoryMergeNode deserialize(ByteBuffer byteBuffer) {
        HashSet<TSchemaNode> data = new HashSet<TSchemaNode>();
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            data.add(ThriftCommonsSerDeUtils.deserializeTSchemaNode((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new NodeManagementMemoryMergeNode(planNodeId, data);
    }

    public String toString() {
        return String.format("NodeManagementMemoryMergeNode-%s", this.getPlanNodeId());
    }
}

