/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.distribution;

import java.util.List;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.mpp.plan.planner.distribution.DistributionPlanContext;
import org.apache.iotdb.db.mpp.plan.planner.distribution.ExchangeNodeAdder;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeGroupContext;
import org.apache.iotdb.db.mpp.plan.planner.distribution.SimpleFragmentParallelPlanner;
import org.apache.iotdb.db.mpp.plan.planner.distribution.SourceRewriter;
import org.apache.iotdb.db.mpp.plan.planner.distribution.WriteFragmentParallelPlanner;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;

public class DistributionPlanner {
    private Analysis analysis;
    private MPPQueryContext context;
    private LogicalQueryPlan logicalPlan;
    private int planFragmentIndex = 0;

    public DistributionPlanner(Analysis analysis, LogicalQueryPlan logicalPlan) {
        this.analysis = analysis;
        this.logicalPlan = logicalPlan;
        this.context = logicalPlan.getContext();
    }

    public PlanNode rewriteSource() {
        SourceRewriter rewriter = new SourceRewriter(this.analysis);
        return rewriter.visit(this.logicalPlan.getRootNode(), new DistributionPlanContext(this.context));
    }

    public PlanNode addExchangeNode(PlanNode root) {
        ExchangeNodeAdder adder = new ExchangeNodeAdder(this.analysis);
        return adder.visit(root, new NodeGroupContext(this.context));
    }

    public SubPlan splitFragment(PlanNode root) {
        FragmentBuilder fragmentBuilder = new FragmentBuilder(this.context);
        return fragmentBuilder.splitToSubPlan(root);
    }

    public DistributedQueryPlan planFragments() {
        PlanNode rootAfterRewrite = this.rewriteSource();
        PlanNode rootWithExchange = this.addExchangeNode(rootAfterRewrite);
        if (this.analysis.getStatement() instanceof QueryStatement) {
            this.analysis.getRespDatasetHeader().setColumnToTsBlockIndexMap(rootWithExchange.getOutputColumnNames());
        }
        SubPlan subPlan = this.splitFragment(rootWithExchange);
        subPlan.getPlanFragment().setRoot(true);
        List<FragmentInstance> fragmentInstances = this.planFragmentInstances(subPlan);
        if (this.context.getQueryType() == QueryType.READ) {
            this.SetSinkForRootInstance(subPlan, fragmentInstances);
        }
        return new DistributedQueryPlan(this.logicalPlan.getContext(), subPlan, subPlan.getPlanFragmentList(), fragmentInstances);
    }

    public List<FragmentInstance> planFragmentInstances(SubPlan subPlan) {
        IFragmentParallelPlaner parallelPlaner = this.context.getQueryType() == QueryType.READ ? new SimpleFragmentParallelPlanner(subPlan, this.analysis, this.context) : new WriteFragmentParallelPlanner(subPlan, this.analysis, this.context);
        return parallelPlaner.parallelPlan();
    }

    public void SetSinkForRootInstance(SubPlan subPlan, List<FragmentInstance> instances) {
        FragmentInstance rootInstance = null;
        for (FragmentInstance instance : instances) {
            if (!instance.getFragment().getId().equals(subPlan.getPlanFragment().getId())) continue;
            rootInstance = instance;
            break;
        }
        if (rootInstance == null) {
            return;
        }
        FragmentSinkNode sinkNode = new FragmentSinkNode(this.context.getQueryId().genPlanNodeId());
        sinkNode.setDownStream(this.context.getLocalDataBlockEndpoint(), this.context.getResultNodeContext().getVirtualFragmentInstanceId(), this.context.getResultNodeContext().getVirtualResultNodeId());
        sinkNode.setChild(rootInstance.getFragment().getPlanNodeTree());
        this.context.getResultNodeContext().setUpStream(rootInstance.getHostDataNode().mPPDataExchangeEndPoint, rootInstance.getId(), sinkNode.getPlanNodeId());
        rootInstance.getFragment().setPlanNodeTree(sinkNode);
    }

    private PlanFragmentId getNextFragmentId() {
        return this.logicalPlan.getContext().getQueryId().genPlanFragmentId();
    }

    private class FragmentBuilder {
        private MPPQueryContext context;

        public FragmentBuilder(MPPQueryContext context) {
            this.context = context;
        }

        public SubPlan splitToSubPlan(PlanNode root) {
            SubPlan rootSubPlan = this.createSubPlan(root);
            this.splitToSubPlan(root, rootSubPlan);
            return rootSubPlan;
        }

        private void splitToSubPlan(PlanNode root, SubPlan subPlan) {
            if (root instanceof WritePlanNode) {
                return;
            }
            if (root instanceof ExchangeNode) {
                ExchangeNode exchangeNode = (ExchangeNode)root;
                FragmentSinkNode sinkNode = new FragmentSinkNode(this.context.getQueryId().genPlanNodeId());
                sinkNode.setChild(exchangeNode.getChild());
                sinkNode.setDownStreamPlanNodeId(exchangeNode.getPlanNodeId());
                exchangeNode.setRemoteSourceNode(sinkNode);
                exchangeNode.cleanChildren();
                SubPlan childSubPlan = this.createSubPlan(sinkNode);
                this.splitToSubPlan(sinkNode, childSubPlan);
                subPlan.addChild(childSubPlan);
                return;
            }
            for (PlanNode child : root.getChildren()) {
                this.splitToSubPlan(child, subPlan);
            }
        }

        private SubPlan createSubPlan(PlanNode root) {
            PlanFragment fragment = new PlanFragment(DistributionPlanner.this.getNextFragmentId(), root);
            return new SubPlan(fragment);
        }
    }
}

