/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.executor;

import com.google.common.util.concurrent.SettableFuture;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.consensus.ConfigNodeRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.executable.ExecutableResource;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.trigger.service.TriggerExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.confignode.rpc.thrift.TCountStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupsReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.CountStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.GetRegionIdTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.GetSeriesSlotListTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.GetTimeSlotListTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.SetStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowClusterDetailsTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowClusterTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowConfigNodesTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowContinuousQueriesTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowDataNodesTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowFunctionsTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowRegionTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowTTLTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowTriggersTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowVariablesTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.template.ShowNodesInSchemaTemplateTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.template.ShowPathSetTemplateTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.template.ShowSchemaTemplateTask;
import org.apache.iotdb.db.mpp.plan.execution.config.sys.sync.ShowPipeSinkTask;
import org.apache.iotdb.db.mpp.plan.execution.config.sys.sync.ShowPipeTask;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateContinuousQueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateFunctionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTriggerStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.GetRegionIdStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.GetSeriesSlotListStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.GetTimeSlotListStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDataNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.DeactivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StartPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StopPipeStatement;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.trigger.service.TriggerClassLoader;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigTaskExecutor
implements IConfigTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigTaskExecutor.class);
    private static final IClientManager<ConfigNodeRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ConfigNodeClientPoolFactory());
    private static final IClientManager<ConfigNodeRegionId, ConfigNodeClient> CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ClusterDeletionConfigNodeClientPoolFactory());

    public static ClusterConfigTaskExecutor getInstance() {
        return ClusterConfigTaskExecutorHolder.INSTANCE;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setStorageGroup(SetStorageGroupStatement setStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        TStorageGroupSchema storageGroupSchema = SetStorageGroupTask.constructStorageGroupSchema(setStorageGroupStatement);
        TSetStorageGroupReq req = new TSetStorageGroupReq(storageGroupSchema);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus = configNodeClient.setStorageGroup(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute create database {} in config node, status is {}.", (Object)setStorageGroupStatement.getStorageGroupPath(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showStorageGroup(ShowStorageGroupStatement showStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(showStorageGroupStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TShowStorageGroupResp resp = client.showStorageGroup(storageGroupPathPattern);
            ShowStorageGroupTask.buildTSBlock(resp.getStorageGroupInfoMap(), (SettableFuture<ConfigTaskResult>)future);
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> countStorageGroup(CountStorageGroupStatement countStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(countStorageGroupStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TCountStorageGroupResp resp = client.countMatchedStorageGroups(storageGroupPathPattern);
            int storageGroupNum = resp.getCount();
            CountStorageGroupTask.buildTSBlock(storageGroupNum, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteStorageGroup(DeleteStorageGroupStatement deleteStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteStorageGroupsReq req = new TDeleteStorageGroupsReq(deleteStorageGroupStatement.getPrefixPath());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus = client.deleteStorageGroups(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute delete database {} in config node, status is {}.", deleteStorageGroupStatement.getPrefixPath(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> createFunction(CreateFunctionStatement createFunctionStatement) {
        SettableFuture future = SettableFuture.create();
        String udfName = createFunctionStatement.getUdfName();
        String className = createFunctionStatement.getClassName();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TCreateFunctionReq tCreateFunctionReq = new TCreateFunctionReq(udfName, className, false);
            String libRoot = UDFExecutableManager.getInstance().getLibRoot();
            if (createFunctionStatement.isUsingURI()) {
                String jarMd5;
                ByteBuffer jarFile;
                String jarFileName;
                block27: {
                    URI uri;
                    String uriString = createFunctionStatement.getUriString();
                    if (uriString == null || uriString.isEmpty()) {
                        future.setException((Throwable)new IoTDBException("URI is empty, please specify the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        return settableFuture;
                    }
                    jarFileName = new File(uriString).getName();
                    try {
                        uri = new URI(uriString);
                        if (uri.getScheme() == null) {
                            future.setException((Throwable)new IoTDBException("The scheme of URI is not set, please specify the scheme of URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                            SettableFuture settableFuture = future;
                            return settableFuture;
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        LOGGER.warn("Failed to get executable for UDF({}) using URI: {}, the cause is: {}", new Object[]{createFunctionStatement.getUdfName(), createFunctionStatement.getUriString(), e});
                        future.setException((Throwable)new IoTDBException("Failed to get executable for UDF '" + createFunctionStatement.getUdfName() + "', please check the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        if (client == null) return settableFuture;
                        client.close();
                        return settableFuture;
                    }
                    {
                        if (!uri.getScheme().equals("file")) {
                            String jarFilePathUnderTempDir;
                            ExecutableResource resource = UDFExecutableManager.getInstance().request(Collections.singletonList(uriString));
                            libRoot = jarFilePathUnderTempDir = UDFExecutableManager.getInstance().getDirStringUnderTempRootByRequestId(resource.getRequestId()) + File.separator + jarFileName;
                            jarFile = ExecutableManager.transferToBytebuffer((String)jarFilePathUnderTempDir);
                            jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(jarFilePathUnderTempDir, new String[0]), new OpenOption[0]));
                            break block27;
                        }
                        libRoot = new File(new URI(uriString)).getAbsolutePath();
                        jarFile = ExecutableManager.transferToBytebuffer((String)libRoot);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(libRoot, new String[0]), new OpenOption[0]));
                    }
                }
                tCreateFunctionReq.setJarFile(jarFile);
                tCreateFunctionReq.setJarMD5(jarMd5);
                tCreateFunctionReq.setIsUsingURI(true);
                tCreateFunctionReq.setJarName(String.format("%s-%s.%s", jarFileName.substring(0, jarFileName.lastIndexOf(".")), jarMd5, jarFileName.substring(jarFileName.lastIndexOf(".") + 1)));
            }
            try (UDFClassLoader classLoader = new UDFClassLoader(libRoot);){
                Class<?> clazz = Class.forName(createFunctionStatement.getClassName(), true, (ClassLoader)classLoader);
                UDTF uDTF = (UDTF)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("Failed to create function when try to create UDF({}) instance first, the cause is: {}", (Object)createFunctionStatement.getUdfName(), (Object)e);
                future.setException((Throwable)new IoTDBException("Failed to load class '" + createFunctionStatement.getClassName() + "', because it's not found in jar file: " + createFunctionStatement.getUriString(), TSStatusCode.UDF_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                if (client == null) return settableFuture;
                client.close();
                return settableFuture;
            }
            TSStatus executionStatus = client.createFunction(tCreateFunctionReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("Failed to create function {}({}) because {}", new Object[]{udfName, className, executionStatus.getMessage()});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropFunction(String udfName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus executionStatus = client.dropFunction(new TDropFunctionReq(udfName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop function {}.", (Object)executionStatus, (Object)udfName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showFunctions() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TGetUDFTableResp getUDFTableResp = client.getUDFTable();
            if (getUDFTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getUDFTableResp.getStatus().message, getUDFTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowFunctionsTask.buildTsBlock(getUDFTableResp.getAllUDFInformation(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> createTrigger(CreateTriggerStatement createTriggerStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TCreateTriggerReq tCreateTriggerReq = new TCreateTriggerReq(createTriggerStatement.getTriggerName(), createTriggerStatement.getClassName(), createTriggerStatement.getTriggerEvent().getId(), createTriggerStatement.getTriggerType().getId(), createTriggerStatement.getPathPattern().serialize(), createTriggerStatement.getAttributes(), FailureStrategy.OPTIMISTIC.getId(), createTriggerStatement.isUsingURI());
            String libRoot = TriggerExecutableManager.getInstance().getLibRoot();
            if (createTriggerStatement.isUsingURI()) {
                String jarMd5;
                ByteBuffer jarFile;
                String jarFileName;
                block27: {
                    URI uri;
                    String uriString = createTriggerStatement.getUriString();
                    if (uriString == null || uriString.isEmpty()) {
                        future.setException((Throwable)new IoTDBException("URI is empty, please specify the URI.", TSStatusCode.UDF_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        return settableFuture;
                    }
                    jarFileName = new File(uriString).getName();
                    try {
                        uri = new URI(uriString);
                        if (uri.getScheme() == null) {
                            future.setException((Throwable)new IoTDBException("The scheme of URI is not set, please specify the scheme of URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                            SettableFuture settableFuture = future;
                            return settableFuture;
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        LOGGER.warn("Failed to get executable for Trigger({}) using URI: {}, the cause is: {}", new Object[]{createTriggerStatement.getTriggerName(), createTriggerStatement.getUriString(), e});
                        future.setException((Throwable)new IoTDBException("Failed to get executable for Trigger '" + createTriggerStatement.getUriString() + "', please check the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture resource = future;
                        if (client == null) return resource;
                        client.close();
                        return resource;
                    }
                    {
                        if (!uri.getScheme().equals("file")) {
                            String jarFilePathUnderTempDir;
                            ExecutableResource resource = TriggerExecutableManager.getInstance().request(Collections.singletonList(uriString));
                            libRoot = jarFilePathUnderTempDir = TriggerExecutableManager.getInstance().getDirStringUnderTempRootByRequestId(resource.getRequestId()) + File.separator + jarFileName;
                            jarFile = ExecutableManager.transferToBytebuffer((String)jarFilePathUnderTempDir);
                            jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(jarFilePathUnderTempDir, new String[0]), new OpenOption[0]));
                            break block27;
                        }
                        libRoot = new File(new URI(uriString)).getAbsolutePath();
                        jarFile = ExecutableManager.transferToBytebuffer((String)libRoot);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(libRoot, new String[0]), new OpenOption[0]));
                    }
                }
                tCreateTriggerReq.setJarFile(jarFile);
                tCreateTriggerReq.setJarMD5(jarMd5);
                tCreateTriggerReq.setIsUsingURI(true);
                tCreateTriggerReq.setJarName(String.format("%s-%s.%s", jarFileName.substring(0, jarFileName.lastIndexOf(".")), jarMd5, jarFileName.substring(jarFileName.lastIndexOf(".") + 1)));
            }
            try (TriggerClassLoader classLoader = new TriggerClassLoader(libRoot);){
                Class<?> triggerClass = Class.forName(createTriggerStatement.getClassName(), true, classLoader);
                Trigger trigger = (Trigger)triggerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                tCreateTriggerReq.setFailureStrategy(trigger.getFailureStrategy().getId());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("Failed to create trigger when try to create trigger({}) instance first, the cause is: {}", (Object)createTriggerStatement.getTriggerName(), (Object)e);
                future.setException((Throwable)new IoTDBException("Failed to load class '" + createTriggerStatement.getClassName() + "', because it's not found in jar file: " + createTriggerStatement.getUriString(), TSStatusCode.TRIGGER_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                if (client == null) return settableFuture;
                client.close();
                return settableFuture;
            }
            TSStatus executionStatus = client.createTrigger(tCreateTriggerReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to create trigger {}. TSStatus is {}", new Object[]{executionStatus, createTriggerStatement.getTriggerName(), executionStatus.message});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropTrigger(String triggerName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus executionStatus = client.dropTrigger(new TDropTriggerReq(triggerName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop trigger {}.", (Object)executionStatus, (Object)triggerName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showTriggers() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TGetTriggerTableResp getTriggerTableResp = client.getTriggerTable();
            if (getTriggerTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getTriggerTableResp.getStatus().message, getTriggerTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowTriggersTask.buildTsBlock(getTriggerTableResp.getAllTriggerInformation(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setTTL(SetTTLStatement setTTLStatement, String taskName) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(setTTLStatement.getStorageGroupPath().getNodes());
        TSetTTLReq setTTLReq = new TSetTTLReq(storageGroupPathPattern, setTTLStatement.getTTL());
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus = configNodeClient.setTTL(setTTLReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute {} {} in config node, status is {}.", new Object[]{taskName, setTTLStatement.getStorageGroupPath(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> merge(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
                tsStatus = client.merge();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeMergeOperation();
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> flush(TFlushReq tFlushReq, boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
                tsStatus = client.flush(tFlushReq);
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeFlushOperation(tFlushReq);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> clearCache(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
                tsStatus = client.clearCache();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeClearCacheOperation();
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> loadConfiguration(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
                tsStatus = client.loadConfiguration();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeLoadConfigurationOperation();
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSystemStatus(boolean onCluster, NodeStatus status) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
                tsStatus = client.setSystemStatus(status.getStatus());
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeSetSystemStatus(status);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster(ShowClusterStatement showClusterStatement) {
        SettableFuture future = SettableFuture.create();
        TShowClusterResp showClusterResp = new TShowClusterResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            showClusterResp = client.showCluster();
        }
        catch (ClientManagerException | TException e) {
            if (showClusterResp.getConfigNodeList() == null) {
                future.setException((Throwable)new TException("Fail to connect to any config node. Please check status of ConfigNodes"));
            } else {
                future.setException(e);
            }
            return future;
        }
        if (showClusterStatement.isDetails()) {
            ShowClusterDetailsTask.buildTSBlock(showClusterResp, (SettableFuture<ConfigTaskResult>)future);
        } else {
            ShowClusterTask.buildTSBlock(showClusterResp, (SettableFuture<ConfigTaskResult>)future);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showClusterParameters() {
        SettableFuture future = SettableFuture.create();
        TShowVariablesResp showVariablesResp = new TShowVariablesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            showVariablesResp = client.showVariables();
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowVariablesTask.buildTSBlock(showVariablesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTTL(ShowTTLStatement showTTLStatement) {
        SettableFuture future = SettableFuture.create();
        List<PartialPath> storageGroupPaths = showTTLStatement.getPaths();
        HashMap<String, Long> storageGroupToTTL = new HashMap<String, Long>();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            if (showTTLStatement.isAll()) {
                List<String> allStorageGroupPathPattern = Arrays.asList("root", "**");
                TStorageGroupSchemaResp resp = client.getMatchedStorageGroupSchemas(allStorageGroupPathPattern);
                for (Map.Entry entry : resp.getStorageGroupSchemaMap().entrySet()) {
                    storageGroupToTTL.put((String)entry.getKey(), ((TStorageGroupSchema)entry.getValue()).getTTL());
                }
            } else {
                for (PartialPath storageGroupPath : storageGroupPaths) {
                    List<String> storageGroupPathPattern = Arrays.asList(storageGroupPath.getNodes());
                    TStorageGroupSchemaResp resp = client.getMatchedStorageGroupSchemas(storageGroupPathPattern);
                    for (Map.Entry entry : resp.getStorageGroupSchemaMap().entrySet()) {
                        if (storageGroupToTTL.containsKey(entry.getKey())) continue;
                        storageGroupToTTL.put((String)entry.getKey(), ((TStorageGroupSchema)entry.getValue()).getTTL());
                    }
                }
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowTTLTask.buildTSBlock(storageGroupToTTL, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showRegion(ShowRegionStatement showRegionStatement) {
        SettableFuture future = SettableFuture.create();
        TShowRegionResp showRegionResp = new TShowRegionResp();
        TShowRegionReq showRegionReq = new TShowRegionReq();
        showRegionReq.setConsensusGroupType(showRegionStatement.getRegionType());
        if (showRegionStatement.getStorageGroups() == null) {
            showRegionReq.setStorageGroups(null);
        } else {
            showRegionReq.setStorageGroups(showRegionStatement.getStorageGroups().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            showRegionResp = client.showRegion(showRegionReq);
            if (showRegionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showRegionResp.getStatus().message, showRegionResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowRegionTask.buildTSBlock(showRegionResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showDataNodes(ShowDataNodesStatement showDataNodesStatement) {
        SettableFuture future = SettableFuture.create();
        TShowDataNodesResp showDataNodesResp = new TShowDataNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            showDataNodesResp = client.showDataNodes();
            if (showDataNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showDataNodesResp.getStatus().message, showDataNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowDataNodesTask.buildTSBlock(showDataNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showConfigNodes() {
        SettableFuture future = SettableFuture.create();
        TShowConfigNodesResp showConfigNodesResp = new TShowConfigNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            showConfigNodesResp = client.showConfigNodes();
            if (showConfigNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showConfigNodesResp.getStatus().message, showConfigNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowConfigNodesTask.buildTSBlock(showConfigNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createSchemaTemplate(CreateSchemaTemplateStatement createSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            TSStatus tsStatus = ClusterTemplateManager.getInstance().createSchemaTemplate(createSchemaTemplateStatement);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute create schema template {} in config node, status is {}.", (Object)createSchemaTemplateStatement.getName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException(e.getCause());
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            List<Template> templateList = ClusterTemplateManager.getInstance().getAllTemplates();
            ShowSchemaTemplateTask.buildTSBlock(templateList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String req = showNodesInSchemaTemplateStatement.getTemplateName();
        TGetTemplateResp tGetTemplateResp = new TGetTemplateResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            Template template = ClusterTemplateManager.getInstance().getTemplate(req);
            ShowNodesInSchemaTemplateTask.buildTSBlock(template, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSchemaTemplate(SetSchemaTemplateStatement setSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String templateName = setSchemaTemplateStatement.getTemplateName();
        PartialPath path = setSchemaTemplateStatement.getPath();
        try {
            ClusterTemplateManager.getInstance().setSchemaTemplate(templateName, path);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            future.setException(e.getCause());
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String templateName = showPathSetTemplateStatement.getTemplateName();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            List<PartialPath> listPath = ClusterTemplateManager.getInstance().getPathsSetTemplate(templateName);
            ShowPathSetTemplateTask.buildTSBlock(listPath, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deactivateSchemaTemplate(String queryId, DeactivateTemplateStatement deactivateTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        TDeactivateSchemaTemplateReq req = new TDeactivateSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateName(deactivateTemplateStatement.getTemplateName());
        req.setPathPatternTree(this.serializePatternListToByteBuffer(deactivateTemplateStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deactivateSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute deactivate schema template {} from {} in config node, status is {}.", new Object[]{deactivateTemplateStatement.getTemplateName(), deactivateTemplateStatement.getPathPatternList(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropSchemaTemplate(DropSchemaTemplateStatement dropSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus = configNodeClient.dropSchemaTemplate(dropSchemaTemplateStatement.getTemplateName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute drop schema template {} in config node, status is {}.", (Object)dropSchemaTemplateStatement.getTemplateName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    private ByteBuffer serializePatternListToByteBuffer(List<PartialPath> patternList) {
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath pathPattern : patternList) {
            patternTree.appendPathPattern(pathPattern);
        }
        patternTree.constructTree();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public SettableFuture<ConfigTaskResult> unsetSchemaTemplate(String queryId, UnsetSchemaTemplateStatement unsetSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        TUnsetSchemaTemplateReq req = new TUnsetSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateName(unsetSchemaTemplateStatement.getTemplateName());
        req.setPath(unsetSchemaTemplateStatement.getPath().getFullPath());
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.unsetSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute unset schema template {} from {} in config node, status is {}.", new Object[]{unsetSchemaTemplateStatement.getTemplateName(), unsetSchemaTemplateStatement.getPath(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipeSink(CreatePipeSinkStatement createPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TPipeSinkInfo pipeSinkInfo = new TPipeSinkInfo();
            pipeSinkInfo.setPipeSinkName(createPipeSinkStatement.getPipeSinkName());
            pipeSinkInfo.setPipeSinkType(createPipeSinkStatement.getPipeSinkType());
            pipeSinkInfo.setAttributes(createPipeSinkStatement.getAttributes());
            TSStatus tsStatus = configNodeClient.createPipeSink(pipeSinkInfo);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to create PIPESINK {} with type {} in config node, status is {}.", new Object[]{createPipeSinkStatement.getPipeSinkName(), createPipeSinkStatement.getPipeSinkType(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipeSink(DropPipeSinkStatement dropPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TDropPipeSinkReq req = new TDropPipeSinkReq();
            req.setPipeSinkName(dropPipeSinkStatement.getPipeSinkName());
            TSStatus tsStatus = configNodeClient.dropPipeSink(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to drop PIPESINK {} in config node, status is {}.", (Object)dropPipeSinkStatement.getPipeSinkName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipeSink(ShowPipeSinkStatement showPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TGetPipeSinkReq tGetPipeSinkReq = new TGetPipeSinkReq();
            if (!StringUtils.isEmpty((CharSequence)showPipeSinkStatement.getPipeSinkName())) {
                tGetPipeSinkReq.setPipeSinkName(showPipeSinkStatement.getPipeSinkName());
            }
            TGetPipeSinkResp resp = configNodeClient.getPipeSink(tGetPipeSinkReq);
            ShowPipeSinkTask.buildTSBlockByTPipeSinkInfo(resp.getPipeSinkInfoList(), (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipe(CreatePipeStatement createPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TCreatePipeReq req = new TCreatePipeReq().setPipeName(createPipeStatement.getPipeName()).setPipeSinkName(createPipeStatement.getPipeSinkName()).setStartTime(createPipeStatement.getStartTime()).setAttributes(createPipeStatement.getPipeAttributes());
            TSStatus tsStatus = configNodeClient.createPipe(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to create PIPE {} in config node, status is {}.", (Object)createPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> startPipe(StartPipeStatement startPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus = configNodeClient.startPipe(startPipeStatement.getPipeName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to start PIPE {}, status is {}.", (Object)startPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipe(DropPipeStatement dropPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus = configNodeClient.dropPipe(dropPipeStatement.getPipeName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to drop PIPE {}, status is {}.", (Object)dropPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> stopPipe(StopPipeStatement stopPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus = configNodeClient.stopPipe(stopPipeStatement.getPipeName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to stop PIPE {}, status is {}.", (Object)stopPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipe(ShowPipeStatement showPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TShowPipeReq tShowPipeReq = new TShowPipeReq();
            if (!StringUtils.isEmpty((CharSequence)showPipeStatement.getPipeName())) {
                tShowPipeReq.setPipeName(showPipeStatement.getPipeName());
            }
            TShowPipeResp resp = configNodeClient.showPipe(tShowPipeReq);
            List<TShowPipeInfo> tShowPipeInfoList = SyncService.getInstance().showPipeForReceiver(showPipeStatement.getPipeName());
            tShowPipeInfoList.addAll(resp.getPipeInfoList());
            ShowPipeTask.buildTSBlock(tShowPipeInfoList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteTimeSeries(String queryId, DeleteTimeSeriesStatement deleteTimeSeriesStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteTimeSeriesReq req = new TDeleteTimeSeriesReq(queryId, this.serializePatternListToByteBuffer(deleteTimeSeriesStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deleteTimeSeries(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute delete timeseries {} in config node, status is {}.", deleteTimeSeriesStatement.getPathPatternList(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getRegionId(GetRegionIdStatement getRegionIdStatement) {
        SettableFuture future = SettableFuture.create();
        TGetRegionIdResp resp = new TGetRegionIdResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TGetRegionIdReq tGetRegionIdReq = new TGetRegionIdReq(getRegionIdStatement.getStorageGroup(), getRegionIdStatement.getPartitionType(), getRegionIdStatement.getSeriesSlotId());
            if (getRegionIdStatement.getTimeSlotId() != null) {
                tGetRegionIdReq.setTimeSlotId(getRegionIdStatement.getTimeSlotId());
            }
            if ((resp = configNodeClient.getRegionId(tGetRegionIdReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus().message, resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetRegionIdTask.buildTSBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getSeriesSlotList(GetSeriesSlotListStatement getSeriesSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TGetSeriesSlotListResp resp = new TGetSeriesSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TGetSeriesSlotListReq tGetSeriesSlotListReq = new TGetSeriesSlotListReq(getSeriesSlotListStatement.getStorageGroup());
            if (getSeriesSlotListStatement.getPartitionType() != null) {
                tGetSeriesSlotListReq.setType(getSeriesSlotListStatement.getPartitionType());
            }
            if ((resp = configNodeClient.getSeriesSlotList(tGetSeriesSlotListReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus().message, resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetSeriesSlotListTask.buildTSBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getTimeSlotList(GetTimeSlotListStatement getTimeSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TGetTimeSlotListResp resp = new TGetTimeSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TGetTimeSlotListReq tGetTimeSlotListReq = new TGetTimeSlotListReq(getTimeSlotListStatement.getStorageGroup(), getTimeSlotListStatement.getSeriesSlotId());
            if (getTimeSlotListStatement.getStartTime() != -1L) {
                tGetTimeSlotListReq.setStartTime(getTimeSlotListStatement.getStartTime());
            }
            if (getTimeSlotListStatement.getEndTime() != -1L) {
                tGetTimeSlotListReq.setEndTime(getTimeSlotListStatement.getEndTime());
            }
            if ((resp = configNodeClient.getTimeSlotList(tGetTimeSlotListReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus().message, resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetTimeSlotListTask.buildTSBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createContinuousQuery(CreateContinuousQueryStatement createContinuousQueryStatement, String sql, String username) {
        createContinuousQueryStatement.semanticCheck();
        String queryBody = createContinuousQueryStatement.getQueryBody();
        Analyzer.validate(createContinuousQueryStatement.getQueryBodyStatement());
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TCreateCQReq tCreateCQReq = new TCreateCQReq(createContinuousQueryStatement.getCqId(), createContinuousQueryStatement.getEveryInterval(), createContinuousQueryStatement.getBoundaryTime(), createContinuousQueryStatement.getStartTimeOffset(), createContinuousQueryStatement.getEndTimeOffset(), createContinuousQueryStatement.getTimeoutPolicy().getType(), queryBody, sql, createContinuousQueryStatement.getZoneId(), username);
            TSStatus executionStatus = client.createCQ(tCreateCQReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to create continuous query {}. TSStatus is {}", new Object[]{executionStatus, createContinuousQueryStatement.getCqId(), executionStatus.message});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropContinuousQuery(String cqId) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TSStatus executionStatus = client.dropCQ(new TDropCQReq(cqId));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop continuous query {}.", (Object)executionStatus, (Object)cqId);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showContinuousQueries() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.configNodeRegionId);){
            TShowCQResp showCQResp = client.showCQ();
            if (showCQResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showCQResp.getStatus().message, showCQResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowContinuousQueriesTask.buildTsBlock(showCQResp.getCqList(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    private static final class ClusterConfigTaskExecutorHolder {
        private static final ClusterConfigTaskExecutor INSTANCE = new ClusterConfigTaskExecutor();

        private ClusterConfigTaskExecutorHolder() {
        }
    }
}

