/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.DeviceGroupSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;

public class StandaloneSchemaFetcher
implements ISchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
    private final SchemaEngine schemaEngine = SchemaEngine.getInstance();

    private StandaloneSchemaFetcher() {
    }

    public static StandaloneSchemaFetcher getInstance() {
        return new StandaloneSchemaFetcher();
    }

    @Override
    public ClusterSchemaTree fetchSchema(PathPatternTree patternTree) {
        return this.fetchSchema(patternTree, false);
    }

    @Override
    public ClusterSchemaTree fetchSchemaWithTags(PathPatternTree patternTree) {
        return this.fetchSchema(patternTree, true);
    }

    private ClusterSchemaTree fetchSchema(PathPatternTree patternTree, boolean withTags) {
        patternTree.constructTree();
        HashSet<String> storageGroupSet = new HashSet<String>();
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        List pathPatterns = patternTree.getAllPathPatterns();
        try {
            for (PartialPath pathPattern : pathPatterns) {
                List<PartialPath> storageGroups = this.localConfigNode.getBelongedStorageGroups(pathPattern);
                for (PartialPath storageGroupPath : storageGroups) {
                    storageGroupSet.add(storageGroupPath.getFullPath());
                    SchemaRegionId schemaRegionId = this.localConfigNode.getBelongedSchemaRegionId(storageGroupPath);
                    ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId);
                    schemaTree.appendMeasurementPaths(schemaRegion.getMeasurementPaths(pathPattern, false, withTags));
                }
            }
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
        schemaTree.setDatabases(storageGroupSet);
        return schemaTree;
    }

    @Override
    public ISchemaTree fetchSchemaWithAutoCreate(PartialPath devicePath, String[] measurements, Function<Integer, TSDataType> getDataType, boolean aligned) {
        DeviceSchemaInfo deviceSchemaInfo = this.getDeviceSchemaInfoWithAutoCreate(devicePath, measurements, getDataType, new TSEncoding[measurements.length], new CompressionType[measurements.length], aligned);
        DeviceGroupSchemaTree schemaTree = new DeviceGroupSchemaTree();
        schemaTree.addDeviceInfo(deviceSchemaInfo);
        return schemaTree;
    }

    private DeviceSchemaInfo getDeviceSchemaInfoWithAutoCreate(PartialPath devicePath, String[] measurements, Function<Integer, TSDataType> getDataType, TSEncoding[] encodings, CompressionType[] compressionTypes, boolean aligned) {
        try {
            SchemaRegionId schemaRegionId = this.localConfigNode.getBelongedSchemaRegionId(devicePath);
            ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId);
            return schemaRegion.getDeviceSchemaInfoWithAutoCreate(devicePath, measurements, getDataType, encodings, compressionTypes, aligned);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ISchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<Boolean> isAlignedList) {
        return this.fetchSchemaListWithAutoCreate(devicePathList, measurementsList, tsDataTypesList, null, null, isAlignedList);
    }

    @Override
    public ISchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<TSEncoding[]> encodingsList, List<CompressionType[]> compressionTypesList, List<Boolean> isAlignedList) {
        HashMap<PartialPath, List> deviceMap = new HashMap<PartialPath, List>();
        int size = devicePathList.size();
        for (int i = 0; i < size; ++i) {
            deviceMap.computeIfAbsent(devicePathList.get(i), k -> new ArrayList()).add(i);
        }
        DeviceGroupSchemaTree schemaTree = new DeviceGroupSchemaTree();
        for (Map.Entry entry : deviceMap.entrySet()) {
            int totalSize = 0;
            boolean isAligned = isAlignedList.get((Integer)((List)entry.getValue()).get(0));
            Iterator iterator = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                if (isAlignedList.get(index2) != isAligned) {
                    throw new StatementAnalyzeException(String.format("Inconsistent device alignment of %s in insert plan.", entry.getKey()));
                }
                totalSize += measurementsList.get(index2).length;
            }
            String[] measurements = new String[totalSize];
            TSDataType[] tsDataTypes = new TSDataType[totalSize];
            TSEncoding[] encodings = new TSEncoding[totalSize];
            CompressionType[] compressionTypes = new CompressionType[totalSize];
            int curPos = 0;
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                int index3 = (Integer)iterator2.next();
                System.arraycopy(measurementsList.get(index3), 0, measurements, curPos, measurementsList.get(index3).length);
                System.arraycopy(tsDataTypesList.get(index3), 0, tsDataTypes, curPos, tsDataTypesList.get(index3).length);
                if (encodingsList != null) {
                    System.arraycopy(encodingsList.get(index3), 0, encodings, curPos, encodingsList.get(index3).length);
                }
                if (compressionTypesList != null) {
                    System.arraycopy(compressionTypesList.get(index3), 0, compressionTypes, curPos, compressionTypesList.get(index3).length);
                }
                curPos += measurementsList.get(index3).length;
            }
            schemaTree.addDeviceInfo(this.getDeviceSchemaInfoWithAutoCreate((PartialPath)entry.getKey(), measurements, index -> tsDataTypes[index], encodings, compressionTypes, isAligned));
        }
        return schemaTree;
    }

    @Override
    public Pair<Template, PartialPath> checkTemplateSetInfo(PartialPath path) {
        return null;
    }

    @Override
    public Map<Integer, Template> checkAllRelatedTemplate(PartialPath pathPattern) {
        return null;
    }

    @Override
    public Pair<Template, List<PartialPath>> getAllPathsSetTemplate(String templateName) {
        return null;
    }

    @Override
    public void invalidAllCache() {
    }
}

