/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.BatchInsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class SchemaValidator {
    private static final ISchemaFetcher SCHEMA_FETCHER = IoTDBDescriptor.getInstance().getConfig().isClusterMode() ? ClusterSchemaFetcher.getInstance() : StandaloneSchemaFetcher.getInstance();

    public static ISchemaTree validate(InsertNode insertNode) {
        ISchemaTree schemaTree;
        if (insertNode instanceof BatchInsertNode) {
            BatchInsertNode batchInsertNode = (BatchInsertNode)((Object)insertNode);
            schemaTree = SCHEMA_FETCHER.fetchSchemaListWithAutoCreate(batchInsertNode.getDevicePaths(), batchInsertNode.getMeasurementsList(), batchInsertNode.getDataTypesList(), batchInsertNode.getAlignedList());
        } else {
            schemaTree = SCHEMA_FETCHER.fetchSchemaWithAutoCreate(insertNode.getDevicePath(), insertNode.getMeasurements(), insertNode::getDataType, insertNode.isAligned());
        }
        try {
            insertNode.validateAndSetSchema(schemaTree);
        }
        catch (MetadataException | QueryProcessException e) {
            throw new SemanticException((Throwable)e);
        }
        return schemaTree;
    }

    public static ISchemaTree validate(List<PartialPath> devicePaths, List<String[]> measurements, List<TSDataType[]> dataTypes, List<TSEncoding[]> encodings, List<CompressionType[]> compressionTypes, List<Boolean> isAlignedList) {
        return SCHEMA_FETCHER.fetchSchemaListWithAutoCreate(devicePaths, measurements, dataTypes, encodings, compressionTypes, isAlignedList);
    }
}

