/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.timer;

import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.schedule.DriverTaskThread;
import org.apache.iotdb.db.mpp.execution.timer.ITimeSliceAllocator;

public class RuleBasedTimeSliceAllocator
implements ITimeSliceAllocator {
    private final long EXECUTION_TIME_SLICE_IN_MS = DriverTaskThread.EXECUTION_TIME_SLICE.roundTo(TimeUnit.MILLISECONDS);
    private final Map<OperatorContext, Integer> operatorToWeightMap = new HashMap<OperatorContext, Integer>();
    private int totalWeight = 0;

    public void recordExecutionWeight(OperatorContext operatorContext, int weight) {
        Preconditions.checkState((!this.operatorToWeightMap.containsKey(operatorContext) ? 1 : 0) != 0, (Object)"Same operator has been weighted");
        this.operatorToWeightMap.put(operatorContext, weight);
        this.totalWeight += weight;
    }

    private int getWeight(OperatorContext operatorContext) {
        Preconditions.checkState((boolean)this.operatorToWeightMap.containsKey(operatorContext), (Object)"This operator has not been weighted");
        return this.operatorToWeightMap.get(operatorContext);
    }

    @Override
    public Duration getMaxRunTime(OperatorContext operatorContext) {
        return new Duration((double)this.EXECUTION_TIME_SLICE_IN_MS * (double)this.getWeight(operatorContext) / (double)this.totalWeight, TimeUnit.MILLISECONDS);
    }
}

