/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.base.Preconditions;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.last.AbstractUpdateLastCacheOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class UpdateLastCacheOperator
extends AbstractUpdateLastCacheOperator {
    private MeasurementPath fullPath;
    private String dataType;

    public UpdateLastCacheOperator(OperatorContext operatorContext, Operator child, MeasurementPath fullPath, TSDataType dataType, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache) {
        super(operatorContext, child, dataNodeSchemaCache, needUpdateCache);
        this.fullPath = fullPath;
        this.dataType = dataType.name();
    }

    @Override
    public TsBlock next() {
        TsBlock res = this.child.next();
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        Preconditions.checkArgument((res.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"last query result should only have one record");
        if (res.getColumn(0).isNull(0)) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        long lastTime = res.getColumn(0).getLong(0);
        TsPrimitiveType lastValue = res.getColumn(1).getTsPrimitiveType(0);
        if (this.needUpdateCache) {
            TimeValuePair timeValuePair = new TimeValuePair(lastTime, lastValue);
            this.lastCache.updateLastCache(this.getDatabaseName(), this.fullPath, timeValuePair, false, Long.MIN_VALUE);
        }
        this.tsBlockBuilder.reset();
        LastQueryUtil.appendLastValue(this.tsBlockBuilder, lastTime, this.fullPath.getFullPath(), lastValue.getStringValue(), this.dataType);
        return this.tsBlockBuilder.build();
    }
}

