/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.join;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AbstractProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.ColumnMerger;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

@Deprecated
public class TimeJoinOperator
extends AbstractProcessOperator {
    private final List<Operator> children;
    private final int inputOperatorsCount;
    private final TsBlock[] inputTsBlocks;
    private final int[] inputIndex;
    private final int[] shadowInputIndex;
    private final boolean[] noMoreTsBlocks;
    private final TimeSelector timeSelector;
    private final int outputColumnCount;
    private final List<TSDataType> dataTypes;
    private final List<ColumnMerger> mergers;
    private final TsBlockBuilder tsBlockBuilder;
    private boolean finished;
    private final TimeComparator comparator;

    public TimeJoinOperator(OperatorContext operatorContext, List<Operator> children, Ordering mergeOrder, List<TSDataType> dataTypes, List<ColumnMerger> mergers, TimeComparator comparator) {
        Preconditions.checkArgument((children != null && children.size() > 0 ? 1 : 0) != 0, (Object)"child size of TimeJoinOperator should be larger than 0");
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.inputIndex = new int[this.inputOperatorsCount];
        this.shadowInputIndex = new int[this.inputOperatorsCount];
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.timeSelector = new TimeSelector(this.inputOperatorsCount << 1, Ordering.ASC == mergeOrder);
        this.outputColumnCount = dataTypes.size();
        this.dataTypes = dataTypes;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.mergers = mergers;
        this.comparator = comparator;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            ListenableFuture<?> blocked;
            if (this.noMoreTsBlocks[i] || !this.empty(i) || (blocked = this.children.get(i).isBlocked()).isDone()) continue;
            listenableFutures.add(blocked);
        }
        return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TsBlock next() {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        this.tsBlockBuilder.reset();
        long currentEndTime = 0L;
        boolean init = false;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.noMoreTsBlocks[i] && this.empty(i)) {
                if (this.children.get(i).hasNext()) {
                    this.inputIndex[i] = 0;
                    this.inputTsBlocks[i] = this.children.get(i).next();
                    if (this.empty(i)) return null;
                    int rowSize = this.inputTsBlocks[i].getPositionCount();
                    for (int row = 0; row < rowSize; ++row) {
                        this.timeSelector.add(this.inputTsBlocks[i].getTimeByIndex(row));
                    }
                } else {
                    this.noMoreTsBlocks[i] = true;
                    this.inputTsBlocks[i] = null;
                }
            }
            if (this.empty(i)) continue;
            currentEndTime = init ? this.comparator.getCurrentEndTime(currentEndTime, this.inputTsBlocks[i].getEndTime()) : this.inputTsBlocks[i].getEndTime();
            init = true;
        }
        if (this.timeSelector.isEmpty()) {
            TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(0, this.dataTypes);
            return tsBlockBuilder.build();
        }
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        while (!this.timeSelector.isEmpty() && this.comparator.satisfyCurEndTime(this.timeSelector.first(), currentEndTime)) {
            timeBuilder.writeLong(this.timeSelector.pollFirst());
            this.tsBlockBuilder.declarePosition();
        }
        for (int i = 0; i < this.outputColumnCount; ++i) {
            ColumnMerger merger = this.mergers.get(i);
            merger.mergeColumn(this.inputTsBlocks, this.inputIndex, this.shadowInputIndex, timeBuilder, currentEndTime, this.tsBlockBuilder.getColumnBuilder(i));
        }
        System.arraycopy(this.shadowInputIndex, 0, this.inputIndex, 0, this.inputOperatorsCount);
        this.resultTsBlock = this.tsBlockBuilder.build();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.retainedTsBlock != null) {
            return true;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.empty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (this.children.get(i).hasNext()) {
                return true;
            }
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    @Override
    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        if (this.retainedTsBlock != null) {
            return false;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.empty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemory());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize(), childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }

    private boolean empty(int columnIndex) {
        return this.inputTsBlocks[columnIndex] == null || this.inputTsBlocks[columnIndex].getPositionCount() == this.inputIndex[columnIndex];
    }
}

