/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LastValueAccumulator
implements Accumulator {
    protected final TSDataType seriesDataType;
    protected TsPrimitiveType lastValue;
    protected long maxTime = Long.MIN_VALUE;
    protected boolean initResult = false;

    public LastValueAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.lastValue = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public int addInput(Column[] column, IWindow curWindow) {
        switch (this.seriesDataType) {
            case INT32: {
                return this.addIntInput(column, curWindow);
            }
            case INT64: {
                return this.addLongInput(column, curWindow);
            }
            case FLOAT: {
                return this.addFloatInput(column, curWindow);
            }
            case DOUBLE: {
                return this.addDoubleInput(column, curWindow);
            }
            case TEXT: {
                return this.addBinaryInput(column, curWindow);
            }
            case BOOLEAN: {
                return this.addBooleanInput(column, curWindow);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 2 ? 1 : 0) != 0, (Object)"partialResult of LastValue should be 2");
        if (partialResult[0].isNull(0)) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntLastValue(partialResult[0].getInt(0), partialResult[1].getLong(0));
                break;
            }
            case INT64: {
                this.updateLongLastValue(partialResult[0].getLong(0), partialResult[1].getLong(0));
                break;
            }
            case FLOAT: {
                this.updateFloatLastValue(partialResult[0].getFloat(0), partialResult[1].getLong(0));
                break;
            }
            case DOUBLE: {
                this.updateDoubleLastValue(partialResult[0].getDouble(0), partialResult[1].getLong(0));
                break;
            }
            case TEXT: {
                this.updateBinaryLastValue(partialResult[0].getBinary(0), partialResult[1].getLong(0));
                break;
            }
            case BOOLEAN: {
                this.updateBooleanLastValue(partialResult[0].getBoolean(0), partialResult[1].getLong(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntLastValue((Integer)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case INT64: {
                this.updateLongLastValue((Long)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case FLOAT: {
                this.updateFloatLastValue(((Float)statistics.getLastValue()).floatValue(), statistics.getEndTime());
                break;
            }
            case DOUBLE: {
                this.updateDoubleLastValue((Double)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case TEXT: {
                this.updateBinaryLastValue((Binary)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanLastValue((Boolean)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        if (!finalResult.isNull(0)) {
            this.initResult = true;
            switch (this.seriesDataType) {
                case INT32: {
                    this.lastValue.setInt(finalResult.getInt(0));
                    break;
                }
                case INT64: {
                    this.lastValue.setLong(finalResult.getLong(0));
                    break;
                }
                case FLOAT: {
                    this.lastValue.setFloat(finalResult.getFloat(0));
                    break;
                }
                case DOUBLE: {
                    this.lastValue.setDouble(finalResult.getDouble(0));
                    break;
                }
                case TEXT: {
                    this.lastValue.setBinary(finalResult.getBinary(0));
                    break;
                }
                case BOOLEAN: {
                    this.lastValue.setBoolean(finalResult.getBoolean(0));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 2 ? 1 : 0) != 0, (Object)"partialResult of LastValue should be 2");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            columnBuilders[1].appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilders[0].writeInt(this.lastValue.getInt());
                break;
            }
            case INT64: {
                columnBuilders[0].writeLong(this.lastValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilders[0].writeFloat(this.lastValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilders[0].writeDouble(this.lastValue.getDouble());
                break;
            }
            case TEXT: {
                columnBuilders[0].writeBinary(this.lastValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilders[0].writeBoolean(this.lastValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
        columnBuilders[1].writeLong(this.maxTime);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.lastValue.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.lastValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.lastValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.lastValue.getDouble());
                break;
            }
            case TEXT: {
                columnBuilder.writeBinary(this.lastValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.lastValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.maxTime = Long.MIN_VALUE;
        this.lastValue.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{this.lastValue.getDataType(), TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return this.lastValue.getDataType();
    }

    protected int addIntInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateIntLastValue(column[2].getInt(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    protected void updateIntLastValue(int value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setInt(value);
        }
    }

    protected int addLongInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateLongLastValue(column[2].getLong(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    protected void updateLongLastValue(long value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setLong(value);
        }
    }

    protected int addFloatInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateFloatLastValue(column[2].getFloat(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    protected void updateFloatLastValue(float value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setFloat(value);
        }
    }

    protected int addDoubleInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateDoubleLastValue(column[2].getDouble(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    protected void updateDoubleLastValue(double value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setDouble(value);
        }
    }

    protected int addBooleanInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateBooleanLastValue(column[2].getBoolean(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    protected void updateBooleanLastValue(boolean value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setBoolean(value);
        }
    }

    protected int addBinaryInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateBinaryLastValue(column[2].getBinary(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    protected void updateBinaryLastValue(Binary value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setBinary(value);
        }
    }
}

