/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable.entry;

import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.idtable.IDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.entry.DiskSchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class SchemaEntry {
    private long schema;
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public SchemaEntry(TSDataType dataType) {
        TSEncoding encoding = EncodingInferenceUtils.getDefaultEncoding(dataType);
        CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        this.schema |= (long)dataType.serialize();
        this.schema |= (long)encoding.serialize() << 8;
        this.schema |= (long)compressionType.serialize() << 16;
    }

    public SchemaEntry(TSDataType dataType, TSEncoding encoding, CompressionType compressionType, long diskPos) {
        this.schema |= (long)dataType.serialize();
        this.schema |= (long)encoding.serialize() << 8;
        this.schema |= (long)compressionType.serialize() << 16;
        this.schema |= diskPos << 24;
    }

    public SchemaEntry(TSDataType dataType, TSEncoding encoding, CompressionType compressionType, IDeviceID deviceID, PartialPath fullPath, boolean isAligned, IDiskSchemaManager IDiskSchemaManager2) {
        this.schema |= (long)dataType.serialize();
        this.schema |= (long)encoding.serialize() << 8;
        this.schema |= (long)compressionType.serialize() << 16;
        if (config.isEnableIDTableLogFile()) {
            DiskSchemaEntry diskSchemaEntry = new DiskSchemaEntry(deviceID.toStringID(), fullPath.getFullPath(), fullPath.getMeasurement(), dataType.serialize(), encoding.serialize(), compressionType.serialize(), isAligned);
            this.schema |= IDiskSchemaManager2.serialize(diskSchemaEntry) << 24;
        }
    }

    public long getDiskPointer() {
        return this.schema >> 24;
    }

    public TSDataType getTSDataType() {
        return TSDataType.deserialize((byte)((byte)this.schema));
    }

    public TSEncoding getTSEncoding() {
        return TSEncoding.deserialize((byte)((byte)(this.schema >> 8)));
    }

    public CompressionType getCompressionType() {
        return CompressionType.deserialize((byte)((byte)(this.schema >> 16)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaEntry)) {
            return false;
        }
        SchemaEntry that = (SchemaEntry)o;
        return this.schema == that.schema;
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }
}

