/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.localconfignode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.localconfignode.LocalDataPartitionInfo;
import org.apache.iotdb.db.localconfignode.LocalSchemaPartitionTable;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.storagegroup.IStorageGroupSchemaManager;
import org.apache.iotdb.db.metadata.storagegroup.StorageGroupSchemaManager;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.mpp.plan.constant.DataNodeEndPoints;
import org.apache.iotdb.db.mpp.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.rescon.MemTableManager;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfigNode {
    private static final Logger logger = LoggerFactory.getLogger(LocalConfigNode.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final long STANDALONE_MOCK_TIME_SLOT_START_TIME = 0L;
    private volatile boolean initialized = false;
    private ScheduledExecutorService timedForceMLogThread;
    private final IStorageGroupSchemaManager storageGroupSchemaManager = StorageGroupSchemaManager.getInstance();
    private final SchemaEngine schemaEngine = SchemaEngine.getInstance();
    private final LocalSchemaPartitionTable schemaPartitionTable = LocalSchemaPartitionTable.getInstance();
    private final StorageEngineV2 storageEngine = StorageEngineV2.getInstance();
    private final LocalDataPartitionInfo dataPartitionInfo = LocalDataPartitionInfo.getInstance();
    private final SeriesPartitionExecutor executor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)config.getSeriesPartitionExecutorClass(), (int)config.getSeriesPartitionSlotNum());
    private final SyncService syncService = SyncService.getInstance();
    private IAuthorizer iAuthorizer;

    private LocalConfigNode() {
        String schemaDir = config.getSchemaDir();
        File schemaFolder = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!schemaFolder.exists()) {
            if (schemaFolder.mkdirs()) {
                logger.info("create system folder {}", (Object)schemaFolder.getAbsolutePath());
            } else {
                logger.error("create system folder {} failed.", (Object)schemaFolder.getAbsolutePath());
            }
        }
        try {
            this.iAuthorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            logger.error(e.getMessage());
        }
    }

    public static LocalConfigNode getInstance() {
        return LocalSchemaConfigManagerHolder.INSTANCE;
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        try {
            this.storageGroupSchemaManager.init();
            Map<PartialPath, List<SchemaRegionId>> recoveredLocalSchemaRegionInfo = this.schemaEngine.initForLocalConfigNode();
            this.schemaPartitionTable.init(recoveredLocalSchemaRegionInfo);
            if (config.getSyncMlogPeriodInMs() != 0L) {
                this.timedForceMLogThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"LocalConfigNode-TimedForceMLog-Thread");
                ScheduledExecutorUtil.unsafelyScheduleAtFixedRate((ScheduledExecutorService)this.timedForceMLogThread, this::forceMlog, (long)config.getSyncMlogPeriodInMs(), (long)config.getSyncMlogPeriodInMs(), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            if (!config.isClusterMode()) {
                Map<String, List<DataRegionId>> recoveredLocalDataRegionInfo = this.storageEngine.getLocalDataRegionInfo();
                this.dataPartitionInfo.init(recoveredLocalDataRegionInfo);
            }
        }
        catch (IOException | MetadataException e) {
            logger.error("Cannot recover all MTree from file, we try to recover as possible as we can", e);
        }
        this.initialized = true;
    }

    public synchronized void clear() {
        if (!this.initialized) {
            return;
        }
        try {
            if (this.timedForceMLogThread != null) {
                this.timedForceMLogThread.shutdown();
                this.timedForceMLogThread = null;
            }
            this.schemaPartitionTable.clear();
            this.schemaEngine.clear();
            this.storageGroupSchemaManager.clear();
            this.dataPartitionInfo.clear();
        }
        catch (IOException e) {
            logger.error("Error occurred when clearing LocalConfigNode:", (Throwable)e);
        }
        this.initialized = false;
    }

    public synchronized void forceMlog() {
        if (!this.initialized) {
            return;
        }
        this.storageGroupSchemaManager.forceLog();
    }

    public void setStorageGroup(PartialPath storageGroup) throws MetadataException {
        this.storageGroupSchemaManager.setStorageGroup(storageGroup);
        for (SchemaRegionId schemaRegionId : this.schemaPartitionTable.setStorageGroup(storageGroup)) {
            this.schemaEngine.createSchemaRegion(storageGroup, schemaRegionId);
        }
        if (!config.isEnableMemControl()) {
            MemTableManager.getInstance().addOrDeleteStorageGroup(1);
        }
    }

    public void deleteStorageGroup(PartialPath storageGroup) throws MetadataException {
        if (!config.isClusterMode()) {
            this.deleteDataRegionsInStorageGroup(this.dataPartitionInfo.getDataRegionIdsByStorageGroup(storageGroup));
            this.dataPartitionInfo.deleteStorageGroup(storageGroup);
        }
        this.deleteSchemaRegionsInStorageGroup(storageGroup, this.schemaPartitionTable.getSchemaRegionIdsByStorageGroup(storageGroup));
        if (!config.isEnableMemControl()) {
            MemTableManager.getInstance().addOrDeleteStorageGroup(-1);
        }
        this.schemaPartitionTable.deleteStorageGroup(storageGroup);
        this.storageGroupSchemaManager.deleteStorageGroup(storageGroup);
    }

    private void deleteSchemaRegionsInStorageGroup(PartialPath storageGroup, List<SchemaRegionId> schemaRegionIdSet) throws MetadataException {
        for (SchemaRegionId schemaRegionId : schemaRegionIdSet) {
            this.schemaEngine.deleteSchemaRegion(schemaRegionId);
        }
        File sgDir = new File(config.getSchemaDir() + File.separator + storageGroup.getFullPath());
        if (sgDir.delete()) {
            logger.info("delete database folder {}", (Object)sgDir.getAbsolutePath());
        } else if (sgDir.exists()) {
            logger.info("delete database folder {} failed.", (Object)sgDir.getAbsolutePath());
            throw new MetadataException(String.format("Failed to delete database folder %s", sgDir.getAbsolutePath()));
        }
    }

    private void deleteDataRegionsInStorageGroup(List<DataRegionId> dataRegionIdSet) {
        for (DataRegionId dataRegionId : dataRegionIdSet) {
            this.storageEngine.deleteDataRegion(dataRegionId);
        }
    }

    public void deleteStorageGroups(List<PartialPath> storageGroups) throws MetadataException {
        for (PartialPath storageGroup : storageGroups) {
            this.deleteStorageGroup(storageGroup);
        }
    }

    private PartialPath ensureStorageGroup(PartialPath path) throws MetadataException {
        try {
            return this.getBelongedStorageGroup(path);
        }
        catch (StorageGroupNotSetException e) {
            if (!config.isAutoCreateSchemaEnabled()) {
                throw e;
            }
            PartialPath storageGroupPath = MetaUtils.getStorageGroupPathByLevel(path, config.getDefaultStorageGroupLevel());
            try {
                this.setStorageGroup(storageGroupPath);
                return storageGroupPath;
            }
            catch (StorageGroupAlreadySetException storageGroupAlreadySetException) {
                if (storageGroupAlreadySetException.isHasChild()) {
                    throw storageGroupAlreadySetException;
                }
                return this.getBelongedStorageGroup(path);
            }
        }
    }

    public void setTTL(PartialPath storageGroup, long dataTTL) throws MetadataException, IOException {
        if (!config.isClusterMode()) {
            this.storageEngine.setTTL(this.dataPartitionInfo.getDataRegionIdsByStorageGroup(storageGroup), dataTTL);
        }
        this.storageGroupSchemaManager.setTTL(storageGroup, dataTTL);
    }

    public boolean isStorageGroup(PartialPath path) {
        return this.storageGroupSchemaManager.isStorageGroup(path);
    }

    public boolean checkStorageGroupByPath(PartialPath path) {
        return this.storageGroupSchemaManager.checkStorageGroupByPath(path);
    }

    public boolean isStorageGroupAlreadySet(PartialPath path) {
        return this.storageGroupSchemaManager.isStorageGroupAlreadySet(path);
    }

    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.storageGroupSchemaManager.getStorageGroupNum(pathPattern, isPrefixMatch);
    }

    public PartialPath getBelongedStorageGroup(PartialPath path) throws StorageGroupNotSetException {
        return this.storageGroupSchemaManager.getBelongedStorageGroup(path);
    }

    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.storageGroupSchemaManager.getBelongedStorageGroups(pathPattern);
    }

    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.storageGroupSchemaManager.getMatchedStorageGroups(pathPattern, isPrefixMatch);
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        return this.storageGroupSchemaManager.getAllStorageGroupPaths();
    }

    public Map<PartialPath, Long> getStorageGroupsTTL() {
        HashMap<PartialPath, Long> storageGroupsTTL = new HashMap<PartialPath, Long>();
        for (IStorageGroupMNode storageGroupMNode : this.getAllStorageGroupNodes()) {
            storageGroupsTTL.put(storageGroupMNode.getPartialPath(), storageGroupMNode.getDataTTL());
        }
        return storageGroupsTTL;
    }

    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) throws MetadataException {
        return this.storageGroupSchemaManager.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch);
    }

    public Pair<Set<TSchemaNode>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.storageGroupSchemaManager.getChildNodePathInNextLevel(pathPattern);
    }

    public Pair<Set<String>, Set<PartialPath>> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.storageGroupSchemaManager.getChildNodeNameInNextLevel(pathPattern);
    }

    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        this.ensureStorageGroup(path);
        return this.storageGroupSchemaManager.getStorageGroupNodeByPath(path);
    }

    public List<IStorageGroupMNode> getAllStorageGroupNodes() {
        return this.storageGroupSchemaManager.getAllStorageGroupNodes();
    }

    public SchemaRegionId getBelongedSchemaRegionId(PartialPath path) throws MetadataException {
        PartialPath storageGroup = this.storageGroupSchemaManager.getBelongedStorageGroup(path);
        SchemaRegionId schemaRegionId = this.schemaPartitionTable.getSchemaRegionId(storageGroup, path);
        if (schemaRegionId == null) {
            throw new MetadataException(String.format("database %s has not been prepared well. Schema region for %s has not been allocated or is not initialized.", storageGroup, path));
        }
        ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId);
        if (schemaRegion == null) {
            throw new MetadataException(String.format("database [%s] has not been prepared well. Schema region [%s] is not initialized.", storageGroup, schemaRegionId));
        }
        return schemaRegionId;
    }

    public SchemaRegionId getBelongedSchemaRegionIdWithAutoCreate(PartialPath path) throws MetadataException {
        ISchemaRegion schemaRegion;
        PartialPath storageGroup = this.ensureStorageGroup(path);
        SchemaRegionId schemaRegionId = this.schemaPartitionTable.getSchemaRegionId(storageGroup, path);
        if (schemaRegionId == null) {
            this.schemaPartitionTable.setStorageGroup(storageGroup);
            schemaRegionId = this.schemaPartitionTable.getSchemaRegionId(storageGroup, path);
        }
        if ((schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId)) == null) {
            this.schemaEngine.createSchemaRegion(storageGroup, schemaRegionId);
        }
        return schemaRegionId;
    }

    public List<SchemaRegionId> getInvolvedSchemaRegionIds(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        ArrayList<SchemaRegionId> result = new ArrayList<SchemaRegionId>();
        for (PartialPath storageGroup : this.storageGroupSchemaManager.getInvolvedStorageGroups(pathPattern, isPrefixMatch)) {
            result.addAll(this.schemaPartitionTable.getInvolvedSchemaRegionIds(storageGroup, pathPattern, isPrefixMatch));
        }
        return result;
    }

    public List<SchemaRegionId> getSchemaRegionIdsByStorageGroup(PartialPath storageGroup) {
        return this.schemaPartitionTable.getSchemaRegionIdsByStorageGroup(storageGroup);
    }

    public DataRegionId getBelongedDataRegionId(PartialPath path) throws MetadataException, DataRegionException {
        PartialPath storageGroup = this.storageGroupSchemaManager.getBelongedStorageGroup(path);
        DataRegionId dataRegionId = this.dataPartitionInfo.getDataRegionId(storageGroup, path);
        if (dataRegionId == null) {
            return null;
        }
        DataRegion dataRegion = this.storageEngine.getDataRegion(dataRegionId);
        if (dataRegion == null) {
            throw new DataRegionException(String.format("Database %s has not been prepared well. Data region for %s is not initialized.", storageGroup, path));
        }
        return dataRegionId;
    }

    public DataRegionId getBelongedDataRegionIdWithAutoCreate(PartialPath devicePath) throws MetadataException, DataRegionException {
        DataRegion dataRegion;
        PartialPath storageGroup = this.storageGroupSchemaManager.getBelongedStorageGroup(devicePath);
        DataRegionId dataRegionId = this.dataPartitionInfo.getDataRegionId(storageGroup, devicePath);
        if (dataRegionId == null) {
            this.dataPartitionInfo.registerStorageGroup(storageGroup);
            dataRegionId = this.dataPartitionInfo.allocateDataRegionForNewSlot(storageGroup, devicePath);
        }
        if ((dataRegion = this.storageEngine.getDataRegion(dataRegionId)) == null) {
            this.storageEngine.createDataRegion(dataRegionId, storageGroup.getFullPath(), Long.MAX_VALUE);
        }
        return dataRegionId;
    }

    public Map<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> getSchemaPartition(PathPatternTree patternTree) {
        HashMap<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>>();
        patternTree.constructTree();
        List partialPathList = patternTree.getAllPathPatterns();
        try {
            for (PartialPath path : partialPathList) {
                List<PartialPath> storageGroups = this.getBelongedStorageGroups(path);
                for (PartialPath storageGroupPath : storageGroups) {
                    String storageGroup = storageGroupPath.getFullPath();
                    SchemaRegionId schemaRegionId = this.getBelongedSchemaRegionId(storageGroupPath);
                    ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId);
                    Set<PartialPath> devices = schemaRegion.getMatchedDevices(storageGroupPath, true);
                    for (PartialPath device : devices) {
                        partitionSlotsMap.computeIfAbsent(storageGroup, key -> new HashMap()).put(this.executor.getSeriesPartitionSlot(device.getFullPath()), this.genStandaloneRegionReplicaSet(TConsensusGroupType.SchemaRegion, schemaRegionId.getId()));
                    }
                }
            }
            return partitionSlotsMap;
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> getOrCreateSchemaPartition(PathPatternTree patternTree) {
        List devicePaths = patternTree.getAllDevicePatterns();
        HashMap<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>>();
        try {
            for (String devicePath : devicePaths) {
                if (devicePath.contains("*")) continue;
                PartialPath device = new PartialPath(devicePath);
                PartialPath storageGroup = this.ensureStorageGroup(device);
                SchemaRegionId schemaRegionId = this.getBelongedSchemaRegionIdWithAutoCreate(device);
                partitionSlotsMap.computeIfAbsent(storageGroup.getFullPath(), key -> new HashMap()).put(this.executor.getSeriesPartitionSlot(devicePath), this.genStandaloneRegionReplicaSet(TConsensusGroupType.SchemaRegion, schemaRegionId.getId()));
            }
        }
        catch (MetadataException e) {
            throw new StatementAnalyzeException("An error occurred when executing getOrCreateSchemaPartition():" + e.getMessage());
        }
        return partitionSlotsMap;
    }

    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) throws MetadataException, DataRegionException {
        HashMap dataPartitionMap = new HashMap();
        for (Map.Entry<String, List<DataPartitionQueryParam>> sgEntry : sgNameToQueryParamsMap.entrySet()) {
            String storageGroupName = sgEntry.getKey();
            List<DataPartitionQueryParam> dataPartitionQueryParams = sgEntry.getValue();
            HashMap<TSeriesPartitionSlot, Map> deviceToRegionsMap = new HashMap<TSeriesPartitionSlot, Map>();
            for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
                String deviceId = dataPartitionQueryParam.getDevicePath();
                DataRegionId dataRegionId = this.getBelongedDataRegionId(new PartialPath(deviceId));
                if (dataRegionId == null) continue;
                Map timePartitionToRegionsMap = deviceToRegionsMap.getOrDefault(this.executor.getSeriesPartitionSlot(deviceId), new HashMap());
                timePartitionToRegionsMap.put(new TTimePartitionSlot(0L), Collections.singletonList(this.genStandaloneRegionReplicaSet(TConsensusGroupType.DataRegion, dataRegionId.getId())));
                deviceToRegionsMap.put(this.executor.getSeriesPartitionSlot(deviceId), timePartitionToRegionsMap);
            }
            if (deviceToRegionsMap.isEmpty()) continue;
            dataPartitionMap.put(storageGroupName, deviceToRegionsMap);
        }
        return new DataPartition(dataPartitionMap, IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
    }

    private TRegionReplicaSet genStandaloneRegionReplicaSet(TConsensusGroupType type, int id) {
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
        regionReplicaSet.setRegionId(new TConsensusGroupId(type, id));
        regionReplicaSet.setDataNodeLocations(Collections.singletonList(new TDataNodeLocation(IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), new TEndPoint(), DataNodeEndPoints.LOCAL_HOST_INTERNAL_ENDPOINT, DataNodeEndPoints.LOCAL_HOST_DATA_BLOCK_ENDPOINT, new TEndPoint(), new TEndPoint())));
        return regionReplicaSet;
    }

    public DataPartition getOrCreateDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) throws MetadataException, DataRegionException {
        HashMap dataPartitionMap = new HashMap();
        for (Map.Entry<String, List<DataPartitionQueryParam>> sgEntry : sgNameToQueryParamsMap.entrySet()) {
            String storageGroupName = sgEntry.getKey();
            List<DataPartitionQueryParam> dataPartitionQueryParams = sgEntry.getValue();
            HashMap<TSeriesPartitionSlot, Map> deviceToRegionsMap = new HashMap<TSeriesPartitionSlot, Map>();
            for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
                String deviceId = dataPartitionQueryParam.getDevicePath();
                List timePartitionSlotList = dataPartitionQueryParam.getTimePartitionSlotList();
                for (TTimePartitionSlot timePartitionSlot : timePartitionSlotList) {
                    DataRegionId dataRegionId = this.getBelongedDataRegionIdWithAutoCreate(new PartialPath(deviceId));
                    Map timePartitionToRegionsMap = deviceToRegionsMap.getOrDefault(this.executor.getSeriesPartitionSlot(deviceId), new HashMap());
                    timePartitionToRegionsMap.put(timePartitionSlot, Collections.singletonList(this.genStandaloneRegionReplicaSet(TConsensusGroupType.DataRegion, dataRegionId.getId())));
                    deviceToRegionsMap.put(this.executor.getSeriesPartitionSlot(deviceId), timePartitionToRegionsMap);
                }
            }
            dataPartitionMap.put(storageGroupName, deviceToRegionsMap);
        }
        return new DataPartition(dataPartitionMap, IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
    }

    public void operatorPermission(AuthorStatement authorStatement) throws AuthException {
        AuthorOperator.AuthorType authorType = AuthorOperator.AuthorType.values()[authorStatement.getAuthorType().ordinal()];
        String userName = authorStatement.getUserName();
        String roleName = authorStatement.getRoleName();
        String password = authorStatement.getPassWord();
        String newPassword = authorStatement.getNewPassword();
        Set permissions = AuthUtils.strToPermissions((String[])authorStatement.getPrivilegeList());
        List nodeNameList = authorStatement.getNodeNameList().stream().map(PartialPath::getFullPath).collect(Collectors.toList());
        switch (authorType) {
            case UPDATE_USER: {
                this.iAuthorizer.updateUserPassword(userName, newPassword);
                break;
            }
            case CREATE_USER: {
                this.iAuthorizer.createUser(userName, password);
                break;
            }
            case CREATE_ROLE: {
                this.iAuthorizer.createRole(roleName);
                break;
            }
            case DROP_USER: {
                this.iAuthorizer.deleteUser(userName);
                break;
            }
            case DROP_ROLE: {
                this.iAuthorizer.deleteRole(roleName);
                break;
            }
            case GRANT_ROLE: {
                Iterator iterator = permissions.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    for (String path : nodeNameList) {
                        this.iAuthorizer.grantPrivilegeToRole(roleName, path, i);
                    }
                }
                break;
            }
            case GRANT_USER: {
                Iterator iterator = permissions.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    for (String path : nodeNameList) {
                        this.iAuthorizer.grantPrivilegeToUser(userName, path, i);
                    }
                }
                break;
            }
            case GRANT_USER_ROLE: {
                this.iAuthorizer.grantRoleToUser(roleName, userName);
                break;
            }
            case REVOKE_USER: {
                Iterator iterator = permissions.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    for (String path : nodeNameList) {
                        this.iAuthorizer.revokePrivilegeFromUser(userName, path, i);
                    }
                }
                break;
            }
            case REVOKE_ROLE: {
                Iterator iterator = permissions.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    for (String path : nodeNameList) {
                        this.iAuthorizer.revokePrivilegeFromRole(roleName, path, i);
                    }
                }
                break;
            }
            case REVOKE_USER_ROLE: {
                this.iAuthorizer.revokeRoleFromUser(roleName, userName);
                break;
            }
            default: {
                throw new AuthException("Unsupported operation " + (Object)((Object)authorType));
            }
        }
    }

    public Map<String, List<String>> queryPermission(AuthorStatement authorStatement) throws AuthException {
        AuthorOperator.AuthorType authorType = AuthorOperator.AuthorType.values()[authorStatement.getAuthorType().ordinal()];
        switch (authorType) {
            case LIST_USER: {
                return this.executeListRoleUsers(authorStatement);
            }
            case LIST_ROLE: {
                return this.executeListRoles(authorStatement);
            }
            case LIST_USER_PRIVILEGE: {
                return this.executeListUserPrivileges(authorStatement);
            }
            case LIST_ROLE_PRIVILEGE: {
                return this.executeListRolePrivileges(authorStatement);
            }
        }
        throw new AuthException("Unsupported operation " + (Object)((Object)authorType));
    }

    public Map<String, List<String>> executeListRoleUsers(AuthorStatement authorStatement) throws AuthException {
        List userList = this.iAuthorizer.listAllUsers();
        if (authorStatement.getRoleName() != null && !authorStatement.getRoleName().isEmpty()) {
            try {
                Role role = this.iAuthorizer.getRole(authorStatement.getRoleName());
                if (role == null) {
                    throw new AuthException("No such role : " + authorStatement.getRoleName());
                }
            }
            catch (AuthException e) {
                throw new AuthException((Throwable)e);
            }
            Iterator itr = userList.iterator();
            while (itr.hasNext()) {
                User userObj = this.iAuthorizer.getUser((String)itr.next());
                if (userObj != null && userObj.hasRole(authorStatement.getRoleName())) continue;
                itr.remove();
            }
        }
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        permissionInfo.put("user", userList);
        return permissionInfo;
    }

    public Map<String, List<String>> executeListRoles(AuthorStatement authorStatement) throws AuthException {
        ArrayList<String> roleList = new ArrayList<String>();
        if (authorStatement.getUserName() == null || authorStatement.getUserName().isEmpty()) {
            roleList.addAll(this.iAuthorizer.listAllRoles());
        } else {
            User user;
            try {
                user = this.iAuthorizer.getUser(authorStatement.getUserName());
                if (user == null) {
                    throw new AuthException("No such user : " + authorStatement.getUserName());
                }
            }
            catch (AuthException e) {
                throw new AuthException((Throwable)e);
            }
            for (String roleN : user.getRoleList()) {
                roleList.add(roleN);
            }
        }
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        permissionInfo.put("role", roleList);
        return permissionInfo;
    }

    public Map<String, List<String>> executeListRolePrivileges(AuthorStatement authorStatement) throws AuthException {
        Role role;
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        try {
            role = this.iAuthorizer.getRole(authorStatement.getRoleName());
            if (role == null) {
                throw new AuthException("No such role : " + authorStatement.getRoleName());
            }
        }
        catch (AuthException e) {
            throw new AuthException((Throwable)e);
        }
        HashSet<String> rolePrivilegeSet = new HashSet<String>();
        for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
            if (authorStatement.getNodeNameList().isEmpty()) {
                rolePrivilegeSet.add(pathPrivilege.toString());
                continue;
            }
            for (PartialPath path : authorStatement.getNodeNameList()) {
                if (!AuthUtils.pathBelongsTo((String)pathPrivilege.getPath(), (String)path.getFullPath())) continue;
                rolePrivilegeSet.add(pathPrivilege.toString());
            }
        }
        permissionInfo.put("privilege", new ArrayList(rolePrivilegeSet));
        return permissionInfo;
    }

    public Map<String, List<String>> executeListUserPrivileges(AuthorStatement authorStatement) throws AuthException {
        User user;
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        try {
            user = this.iAuthorizer.getUser(authorStatement.getUserName());
            if (user == null) {
                throw new AuthException("No such user : " + authorStatement.getUserName());
            }
        }
        catch (AuthException e) {
            throw new AuthException((Throwable)e);
        }
        ArrayList<String> userPrivilegesList = new ArrayList<String>();
        if ("root".equals(authorStatement.getUserName())) {
            for (PrivilegeType privilegeType : PrivilegeType.values()) {
                userPrivilegesList.add(privilegeType.toString());
            }
        } else {
            ArrayList<String> rolePrivileges = new ArrayList<String>();
            HashSet<String> userPrivilegeSet = new HashSet<String>();
            for (PathPrivilege pathPrivilege : user.getPrivilegeList()) {
                if (authorStatement.getNodeNameList().isEmpty() && !userPrivilegeSet.contains(pathPrivilege.toString())) {
                    rolePrivileges.add("");
                    userPrivilegeSet.add(pathPrivilege.toString());
                    continue;
                }
                for (PartialPath path : authorStatement.getNodeNameList()) {
                    if (!AuthUtils.pathBelongsTo((String)pathPrivilege.getPath(), (String)path.getFullPath()) || userPrivilegeSet.contains(pathPrivilege.toString())) continue;
                    rolePrivileges.add("");
                    userPrivilegeSet.add(pathPrivilege.toString());
                }
            }
            userPrivilegesList.addAll(userPrivilegeSet);
            for (String roleN : user.getRoleList()) {
                Role role = this.iAuthorizer.getRole(roleN);
                if (roleN == null) continue;
                HashSet<String> rolePrivilegeSet = new HashSet<String>();
                for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                    if (authorStatement.getNodeNameList().isEmpty() && !rolePrivilegeSet.contains(pathPrivilege.toString())) {
                        rolePrivileges.add(roleN);
                        rolePrivilegeSet.add(pathPrivilege.toString());
                        continue;
                    }
                    for (PartialPath path : authorStatement.getNodeNameList()) {
                        if (!AuthUtils.pathBelongsTo((String)pathPrivilege.getPath(), (String)path.getFullPath()) || rolePrivilegeSet.contains(pathPrivilege.toString())) continue;
                        rolePrivileges.add(roleN);
                        rolePrivilegeSet.add(pathPrivilege.toString());
                    }
                }
                userPrivilegesList.addAll(rolePrivilegeSet);
            }
            permissionInfo.put("role", rolePrivileges);
        }
        permissionInfo.put("privilege", userPrivilegesList);
        return permissionInfo;
    }

    public boolean login(String username, String password) throws AuthException {
        return this.iAuthorizer.login(username, password);
    }

    public boolean checkUserPrivileges(String username, String path, int permission) throws AuthException {
        return this.iAuthorizer.checkUserPrivileges(username, path, permission);
    }

    public TSStatus executeMergeOperation() {
        try {
            this.storageEngine.mergeAll();
        }
        catch (StorageEngineException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus executeFlushOperation(TFlushReq tFlushReq) {
        return this.storageEngine.operateFlush(tFlushReq);
    }

    public TSStatus executeClearCacheOperation() {
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus executeLoadConfigurationOperation() {
        try {
            IoTDBDescriptor.getInstance().loadHotModifiedProps();
        }
        catch (QueryProcessException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus executeSetSystemStatus(NodeStatus status) {
        try {
            CommonDescriptor.getInstance().getConfig().setNodeStatus(status);
        }
        catch (Exception e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus createPipeSink(CreatePipeSinkStatement createPipeSinkStatement) {
        try {
            this.syncService.addPipeSink(createPipeSinkStatement);
        }
        catch (PipeSinkException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CREATE_PIPE_SINK_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus dropPipeSink(String pipeSinkName) {
        try {
            this.syncService.dropPipeSink(pipeSinkName);
        }
        catch (PipeSinkException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CREATE_PIPE_SINK_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public List<PipeSink> showPipeSink(String pipeSinkName) throws PipeSinkException {
        boolean showAll = StringUtils.isEmpty((CharSequence)pipeSinkName);
        if (showAll) {
            return this.syncService.getAllPipeSink();
        }
        return Collections.singletonList(this.syncService.getPipeSink(pipeSinkName));
    }

    public TSStatus createPipe(CreatePipeStatement createPipeStatement) {
        try {
            this.syncService.addPipe(SyncPipeUtil.parseCreatePipeStatementAsPipeInfo(createPipeStatement, System.currentTimeMillis()));
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus startPipe(String pipeName) {
        try {
            this.syncService.startPipe(pipeName);
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus stopPipe(String pipeName) {
        try {
            this.syncService.stopPipe(pipeName);
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus dropPipe(String pipeName) {
        try {
            this.syncService.dropPipe(pipeName);
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TShowPipeResp showPipe(String pipeName) {
        List<TShowPipeInfo> pipeInfos = SyncService.getInstance().showPipe(pipeName);
        return new TShowPipeResp().setPipeInfoList(pipeInfos).setStatus(StatusUtils.OK);
    }

    private static class LocalSchemaConfigManagerHolder {
        private static final LocalConfigNode INSTANCE = new LocalConfigNode();

        private LocalSchemaConfigManagerHolder() {
        }
    }
}

