/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResourceList
implements List<TsFileResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileResourceList.class);
    private TsFileResource header;
    private TsFileResource tail;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private int count = 0;

    public void insertBefore(TsFileResource node, TsFileResource newNode) {
        if (newNode.equals(node)) {
            return;
        }
        newNode.prev = node.prev;
        newNode.next = node;
        if (node.prev == null) {
            this.header = newNode;
        } else {
            node.prev.next = newNode;
        }
        node.prev = newNode;
        ++this.count;
    }

    public void insertAfter(TsFileResource node, TsFileResource newNode) {
        newNode.prev = node;
        newNode.next = node.next;
        if (node.next == null) {
            this.tail = newNode;
        } else {
            node.next.prev = newNode;
        }
        node.next = newNode;
        ++this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof TsFileResource)) {
            return false;
        }
        boolean contain = false;
        TsFileResource current = this.header;
        while (current != null) {
            if (current.equals(o)) {
                contain = true;
                break;
            }
            current = current.next;
        }
        return contain;
    }

    @Override
    public Iterator<TsFileResource> iterator() {
        return new TsFileIterator();
    }

    public Iterator<TsFileResource> reverseIterator() {
        return new TsFileReverseIterator();
    }

    @Override
    public boolean add(TsFileResource newNode) {
        if (newNode.prev != null || newNode.next != null) {
            return false;
        }
        if (this.tail == null) {
            this.header = newNode;
            this.tail = newNode;
            ++this.count;
        } else {
            this.insertAfter(this.tail, newNode);
        }
        return true;
    }

    public boolean keepOrderInsert(TsFileResource newNode) throws IOException {
        if (newNode.prev != null || newNode.next != null || this.count == 1 && this.header == newNode) {
            return false;
        }
        if (this.tail == null) {
            this.header = newNode;
            this.tail = newNode;
            ++this.count;
        } else {
            long versionOfNewNode = TsFileNameGenerator.getTsFileName(newNode.getTsFile().getName()).getVersion();
            if (TsFileNameGenerator.getTsFileName(this.header.getTsFile().getName()).getVersion() > versionOfNewNode) {
                this.insertBefore(this.header, newNode);
            } else if (TsFileNameGenerator.getTsFileName(this.tail.getTsFile().getName()).getVersion() < versionOfNewNode) {
                this.insertAfter(this.tail, newNode);
            } else {
                TsFileResource currNode = this.header;
                while (currNode.next != null && TsFileNameGenerator.getTsFileName(currNode.getTsFile().getName()).getVersion() <= versionOfNewNode) {
                    currNode = currNode.next;
                }
                if (TsFileNameGenerator.getTsFileName(currNode.getTsFile().getName()).getVersion() < versionOfNewNode) {
                    LOGGER.error("Cannot find an appropriate place to insert {}", (Object)newNode);
                } else {
                    this.insertBefore(currNode, newNode);
                }
            }
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        TsFileResource tsFileResource = (TsFileResource)o;
        if (!this.contains(o)) {
            return false;
        }
        if (tsFileResource.prev == null) {
            this.header = this.header.next;
            if (this.header != null) {
                this.header.prev = null;
            } else {
                this.tail = null;
            }
        } else if (tsFileResource.next == null) {
            this.tail = this.tail.prev;
            if (this.tail != null) {
                this.tail.next = null;
            } else {
                this.header = null;
            }
        } else {
            tsFileResource.prev.next = tsFileResource.next;
            tsFileResource.next.prev = tsFileResource.prev;
        }
        tsFileResource.prev = null;
        tsFileResource.next = null;
        --this.count;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends TsFileResource> c) {
        if (c instanceof List) {
            for (TsFileResource tsFileResource : c) {
                this.add(tsFileResource);
            }
            return true;
        }
        throw new NotImplementedException();
    }

    @Override
    public void clear() {
        this.header = null;
        this.tail = null;
        this.count = 0;
    }

    @Override
    public Object[] toArray() {
        return this.getArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getArrayList().toArray(a);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TsFileResource> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public TsFileResource get(int index) {
        TsFileResource currTsFileResource = this.header;
        for (int currIndex = 0; currIndex != index; ++currIndex) {
            if (currTsFileResource.next == null) {
                throw new ArrayIndexOutOfBoundsException(currIndex);
            }
            currTsFileResource = currTsFileResource.next;
        }
        return currTsFileResource;
    }

    @Override
    public TsFileResource set(int index, TsFileResource element) {
        TsFileResource currTsFileResource = this.header;
        if (this.header == null && index > 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        for (int currIndex = 0; currIndex != index; ++currIndex) {
            if (currTsFileResource.next == null) {
                if (currIndex == index - 1) {
                    this.insertAfter(currTsFileResource, element);
                    return element;
                }
                throw new ArrayIndexOutOfBoundsException(currIndex);
            }
            currTsFileResource = currTsFileResource.next;
        }
        if (currTsFileResource != null) {
            this.insertBefore(currTsFileResource, element);
        } else {
            this.add(element);
        }
        return element;
    }

    @Override
    public void add(int index, TsFileResource element) {
        throw new NotImplementedException();
    }

    @Override
    public TsFileResource remove(int index) {
        throw new NotImplementedException();
    }

    @Override
    public int indexOf(Object o) {
        throw new NotImplementedException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<TsFileResource> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<TsFileResource> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public List<TsFileResource> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    public List<TsFileResource> getArrayList() {
        ArrayList<TsFileResource> list = new ArrayList<TsFileResource>();
        if (this.header == null) {
            return list;
        }
        TsFileResource current = this.header;
        while (current.next != null) {
            list.add(current);
            current = current.next;
        }
        list.add(current);
        return list;
    }

    public TsFileResource getHeader() {
        return this.header;
    }

    public TsFileResource getTail() {
        return this.tail;
    }

    private class TsFileReverseIterator
    implements Iterator<TsFileResource> {
        List<TsFileResource> tsFileResourceList;
        int currentIndex;

        public TsFileReverseIterator() {
            this.tsFileResourceList = TsFileResourceList.this.getArrayList();
            this.currentIndex = this.tsFileResourceList.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= 0;
        }

        @Override
        public TsFileResource next() {
            return this.tsFileResourceList.get(this.currentIndex--);
        }
    }

    private class TsFileIterator
    implements Iterator<TsFileResource> {
        List<TsFileResource> tsFileResourceList;
        int currentIndex = 0;

        public TsFileIterator() {
            this.tsFileResourceList = TsFileResourceList.this.getArrayList();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.tsFileResourceList.size();
        }

        @Override
        public TsFileResource next() {
            return this.tsFileResourceList.get(this.currentIndex++);
        }
    }
}

