/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.DataNodeRemoveHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.RemoveDataNodeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDataNodeProcedure
extends AbstractNodeProcedure<RemoveDataNodeState> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveDataNodeProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TDataNodeLocation removedDataNode;
    private List<TConsensusGroupId> migratedDataNodeRegions = new ArrayList<TConsensusGroupId>();

    public RemoveDataNodeProcedure() {
    }

    public RemoveDataNodeProcedure(TDataNodeLocation removedDataNode) {
        this.removedDataNode = removedDataNode;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RemoveDataNodeState state) {
        block14: {
            if (this.removedDataNode == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            DataNodeRemoveHandler handler = env.getDataNodeRemoveHandler();
            try {
                switch (state) {
                    case REGION_REPLICA_CHECK: {
                        if (env.doubleCheckReplica(this.removedDataNode)) {
                            this.setNextState(RemoveDataNodeState.REMOVE_DATA_NODE_PREPARE);
                        } else {
                            LOG.error("{}, Can not remove DataNode {} because the number of DataNodes is less or equal than region replica number", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)this.removedDataNode);
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                    }
                    case REMOVE_DATA_NODE_PREPARE: {
                        env.markDataNodeAsRemovingAndBroadcast(this.removedDataNode);
                        this.migratedDataNodeRegions = handler.getMigratedDataNodeRegions(this.removedDataNode);
                        LOG.info("{}, DataNode regions to be removed is {}", (Object)"[REMOVE_DATANODE_PROCESS]", this.migratedDataNodeRegions);
                        this.setNextState(RemoveDataNodeState.BROADCAST_DISABLE_DATA_NODE);
                        break;
                    }
                    case BROADCAST_DISABLE_DATA_NODE: {
                        handler.broadcastDisableDataNode(this.removedDataNode);
                        this.setNextState(RemoveDataNodeState.SUBMIT_REGION_MIGRATE);
                        break;
                    }
                    case SUBMIT_REGION_MIGRATE: {
                        this.submitChildRegionMigrate(env);
                        this.setNextState(RemoveDataNodeState.STOP_DATA_NODE);
                        break;
                    }
                    case STOP_DATA_NODE: {
                        if (this.isAllRegionMigratedSuccessfully(env)) {
                            LOG.info("{}, Begin to stop DataNode: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)this.removedDataNode);
                            handler.removeDataNodePersistence(this.removedDataNode);
                            handler.stopDataNode(this.removedDataNode);
                        }
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Remove Data Node failed " + (Object)((Object)state)));
                }
                LOG.error("Retrievable error trying to remove data node {}, state {}", new Object[]{this.removedDataNode, state, e});
                if (this.getCycles() <= 5) break block14;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void submitChildRegionMigrate(ConfigNodeProcedureEnv env) {
        this.migratedDataNodeRegions.forEach(regionId -> {
            TDataNodeLocation destDataNode = env.getDataNodeRemoveHandler().findDestDataNode((TConsensusGroupId)regionId);
            if (destDataNode != null) {
                RegionMigrateProcedure regionMigrateProcedure = new RegionMigrateProcedure((TConsensusGroupId)regionId, this.removedDataNode, destDataNode);
                this.addChildProcedure(new RegionMigrateProcedure[]{regionMigrateProcedure});
                LOG.info("Submit child procedure {} for regionId {}", (Object)regionMigrateProcedure, regionId);
            } else {
                LOG.error("{}, Cannot find target DataNode to migrate the region: {}", (Object)"[REMOVE_DATANODE_PROCESS]", regionId);
            }
        });
    }

    private boolean isAllRegionMigratedSuccessfully(ConfigNodeProcedureEnv env) {
        List<TRegionReplicaSet> replicaSets = env.getConfigManager().getPartitionManager().getAllReplicaSets();
        List migratedFailedRegions = replicaSets.stream().filter(replica -> replica.getDataNodeLocations().contains(this.removedDataNode)).map(TRegionReplicaSet::getRegionId).collect(Collectors.toList());
        if (!migratedFailedRegions.isEmpty()) {
            LOG.warn("{}, Some regions are migrated failed, the StopDataNode process should not be executed, migratedFailedRegions: {}", (Object)"[REMOVE_DATANODE_PROCESS]", migratedFailedRegions);
            return false;
        }
        return true;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RemoveDataNodeState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected boolean isRollbackSupported(RemoveDataNodeState state) {
        return false;
    }

    @Override
    protected boolean holdLock(ConfigNodeProcedureEnv env) {
        return true;
    }

    @Override
    protected RemoveDataNodeState getState(int stateId) {
        return RemoveDataNodeState.values()[stateId];
    }

    @Override
    protected int getStateId(RemoveDataNodeState removeDataNodeState) {
        return removeDataNodeState.ordinal();
    }

    @Override
    protected RemoveDataNodeState getInitialState() {
        return RemoveDataNodeState.REGION_REPLICA_CHECK;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.REMOVE_DATA_NODE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.removedDataNode, (DataOutputStream)stream);
        stream.writeInt(this.migratedDataNodeRegions.size());
        this.migratedDataNodeRegions.forEach(tid -> ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)tid, (DataOutputStream)stream));
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.removedDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            int regionSize = byteBuffer.getInt();
            this.migratedDataNodeRegions = new ArrayList<TConsensusGroupId>(regionSize);
            for (int i = 0; i < regionSize; ++i) {
                this.migratedDataNodeRegions.add(ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer));
            }
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize RemoveConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof RemoveDataNodeProcedure) {
            RemoveDataNodeProcedure thatProc = (RemoveDataNodeProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.removedDataNode.equals(this.removedDataNode) && thatProc.migratedDataNodeRegions.equals(this.migratedDataNodeRegions);
        }
        return false;
    }
}

