/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoppableThread
extends Thread {
    private static final int JOIN_TIMEOUT = 250;
    private static final Logger LOG = LoggerFactory.getLogger(StoppableThread.class);

    protected StoppableThread(ThreadGroup threadGroup, String name) {
        super(threadGroup, name);
    }

    public abstract void sendStopSignal();

    public void awaitTermination() {
        try {
            int i = 0;
            while (this.isAlive()) {
                this.sendStopSignal();
                this.join(250L);
                if (i > 0 && i % 8 == 0) {
                    this.interrupt();
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{} join wait got interrupted", (Object)this.getName(), (Object)e);
        }
    }
}

