/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.executor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionIdPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.storagegroup.CountStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.storagegroup.GetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.udf.GetUDFJarPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.ActiveCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.AddCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.DropCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.ShowCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.UpdateCQLastExecTimePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.function.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.DropFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.DeleteProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.DeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.GetPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.PreCreatePipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.RecordPipeMessagePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.SetPipeStatusPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.ShowPipePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.AddTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerStateInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggersOnTransferNodesPlan;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.exception.physical.UnknownPhysicalPlanTypeException;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.cq.CQInfo;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.persistence.sync.ClusterSyncInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPlanExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPlanExecutor.class);
    private final List<SnapshotProcessor> snapshotProcessorList = new ArrayList<SnapshotProcessor>();
    private final NodeInfo nodeInfo;
    private final ClusterSchemaInfo clusterSchemaInfo;
    private final PartitionInfo partitionInfo;
    private final AuthorInfo authorInfo;
    private final ProcedureInfo procedureInfo;
    private final UDFInfo udfInfo;
    private final TriggerInfo triggerInfo;
    private final ClusterSyncInfo syncInfo;
    private final CQInfo cqInfo;

    public ConfigPlanExecutor(NodeInfo nodeInfo, ClusterSchemaInfo clusterSchemaInfo, PartitionInfo partitionInfo, AuthorInfo authorInfo, ProcedureInfo procedureInfo, UDFInfo udfInfo, TriggerInfo triggerInfo, ClusterSyncInfo syncInfo, CQInfo cqInfo) {
        this.nodeInfo = nodeInfo;
        this.snapshotProcessorList.add(nodeInfo);
        this.clusterSchemaInfo = clusterSchemaInfo;
        this.snapshotProcessorList.add(clusterSchemaInfo);
        this.partitionInfo = partitionInfo;
        this.snapshotProcessorList.add(partitionInfo);
        this.authorInfo = authorInfo;
        this.snapshotProcessorList.add(authorInfo);
        this.udfInfo = udfInfo;
        this.snapshotProcessorList.add(udfInfo);
        this.triggerInfo = triggerInfo;
        this.snapshotProcessorList.add(triggerInfo);
        this.syncInfo = syncInfo;
        this.snapshotProcessorList.add(syncInfo);
        this.cqInfo = cqInfo;
        this.snapshotProcessorList.add(cqInfo);
        this.procedureInfo = procedureInfo;
    }

    public DataSet executeQueryPlan(ConfigPhysicalPlan req) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (req.getType()) {
            case GetDataNodeConfiguration: {
                return this.nodeInfo.getDataNodeConfiguration((GetDataNodeConfigurationPlan)req);
            }
            case CountStorageGroup: {
                return this.clusterSchemaInfo.countMatchedStorageGroups((CountStorageGroupPlan)req);
            }
            case GetStorageGroup: {
                return this.clusterSchemaInfo.getMatchedStorageGroupSchemas((GetStorageGroupPlan)req);
            }
            case GetDataPartition: 
            case GetOrCreateDataPartition: {
                return this.partitionInfo.getDataPartition((GetDataPartitionPlan)req);
            }
            case GetSchemaPartition: 
            case GetOrCreateSchemaPartition: {
                return this.partitionInfo.getSchemaPartition((GetSchemaPartitionPlan)req);
            }
            case ListUser: {
                return this.authorInfo.executeListUsers((AuthorPlan)req);
            }
            case ListRole: {
                return this.authorInfo.executeListRoles((AuthorPlan)req);
            }
            case ListUserPrivilege: {
                return this.authorInfo.executeListUserPrivileges((AuthorPlan)req);
            }
            case ListRolePrivilege: {
                return this.authorInfo.executeListRolePrivileges((AuthorPlan)req);
            }
            case GetNodePathsPartition: {
                return this.getSchemaNodeManagementPartition(req);
            }
            case GetRegionInfoList: {
                return this.getRegionInfoList(req);
            }
            case GetAllSchemaTemplate: {
                return this.clusterSchemaInfo.getAllTemplates();
            }
            case GetSchemaTemplate: {
                return this.clusterSchemaInfo.getTemplate((GetSchemaTemplatePlan)req);
            }
            case CheckTemplateSettable: {
                return this.clusterSchemaInfo.checkTemplateSettable((CheckTemplateSettablePlan)req);
            }
            case GetPathsSetTemplate: {
                return this.clusterSchemaInfo.getPathsSetTemplate((GetPathsSetTemplatePlan)req);
            }
            case GetAllTemplateSetInfo: {
                return this.clusterSchemaInfo.getAllTemplateSetInfo();
            }
            case GetTemplateSetInfo: {
                return this.clusterSchemaInfo.getTemplateSetInfo((GetTemplateSetInfoPlan)req);
            }
            case GetPipeSink: {
                return this.syncInfo.getPipeSink((GetPipeSinkPlan)req);
            }
            case ShowPipe: {
                return this.syncInfo.showPipe((ShowPipePlan)req);
            }
            case GetTriggerTable: {
                return this.triggerInfo.getTriggerTable((GetTriggerTablePlan)req);
            }
            case GetTriggerLocation: {
                return this.triggerInfo.getTriggerLocation((GetTriggerLocationPlan)req);
            }
            case GetTriggerJar: {
                return this.triggerInfo.getTriggerJar((GetTriggerJarPlan)req);
            }
            case GetTransferringTriggers: {
                return this.triggerInfo.getTransferringTriggers();
            }
            case GetRegionId: {
                return this.partitionInfo.getRegionId((GetRegionIdPlan)req);
            }
            case GetTimeSlotList: {
                return this.partitionInfo.getTimeSlotList((GetTimeSlotListPlan)req);
            }
            case GetSeriesSlotList: {
                return this.partitionInfo.getSeriesSlotList((GetSeriesSlotListPlan)req);
            }
            case SHOW_CQ: {
                return this.cqInfo.showCQ((ShowCQPlan)req);
            }
            case GetFunctionTable: {
                return this.udfInfo.getUDFTable();
            }
            case GetFunctionJar: {
                return this.udfInfo.getUDFJar((GetUDFJarPlan)req);
            }
        }
        throw new UnknownPhysicalPlanTypeException(req.getType());
    }

    public TSStatus executeNonQueryPlan(ConfigPhysicalPlan physicalPlan) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (physicalPlan.getType()) {
            case RegisterDataNode: {
                return this.nodeInfo.registerDataNode((RegisterDataNodePlan)physicalPlan);
            }
            case RemoveDataNode: {
                return this.nodeInfo.removeDataNode((RemoveDataNodePlan)physicalPlan);
            }
            case UpdateDataNodeConfiguration: {
                return this.nodeInfo.updateDataNode((UpdateDataNodePlan)physicalPlan);
            }
            case SetStorageGroup: {
                TSStatus status = this.clusterSchemaInfo.setStorageGroup((SetStorageGroupPlan)physicalPlan);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return status;
                }
                return this.partitionInfo.setStorageGroup((SetStorageGroupPlan)physicalPlan);
            }
            case AdjustMaxRegionGroupNum: {
                return this.clusterSchemaInfo.adjustMaxRegionGroupCount((AdjustMaxRegionGroupNumPlan)physicalPlan);
            }
            case DeleteStorageGroup: {
                this.partitionInfo.deleteStorageGroup((DeleteStorageGroupPlan)physicalPlan);
                return this.clusterSchemaInfo.deleteStorageGroup((DeleteStorageGroupPlan)physicalPlan);
            }
            case PreDeleteStorageGroup: {
                return this.partitionInfo.preDeleteStorageGroup((PreDeleteStorageGroupPlan)physicalPlan);
            }
            case SetTTL: {
                return this.clusterSchemaInfo.setTTL((SetTTLPlan)physicalPlan);
            }
            case SetSchemaReplicationFactor: {
                return this.clusterSchemaInfo.setSchemaReplicationFactor((SetSchemaReplicationFactorPlan)physicalPlan);
            }
            case SetDataReplicationFactor: {
                return this.clusterSchemaInfo.setDataReplicationFactor((SetDataReplicationFactorPlan)physicalPlan);
            }
            case SetTimePartitionInterval: {
                return this.clusterSchemaInfo.setTimePartitionInterval((SetTimePartitionIntervalPlan)physicalPlan);
            }
            case CreateRegionGroups: {
                return this.partitionInfo.createRegionGroups((CreateRegionGroupsPlan)physicalPlan);
            }
            case OfferRegionMaintainTasks: {
                return this.partitionInfo.offerRegionMaintainTasks((OfferRegionMaintainTasksPlan)physicalPlan);
            }
            case PollRegionMaintainTask: {
                return this.partitionInfo.pollRegionMaintainTask();
            }
            case CreateSchemaPartition: {
                return this.partitionInfo.createSchemaPartition((CreateSchemaPartitionPlan)physicalPlan);
            }
            case CreateDataPartition: {
                return this.partitionInfo.createDataPartition((CreateDataPartitionPlan)physicalPlan);
            }
            case UpdateProcedure: {
                return this.procedureInfo.updateProcedure((UpdateProcedurePlan)physicalPlan);
            }
            case DeleteProcedure: {
                return this.procedureInfo.deleteProcedure((DeleteProcedurePlan)physicalPlan);
            }
            case CreateUser: 
            case CreateRole: 
            case DropUser: 
            case DropRole: 
            case GrantRole: 
            case GrantUser: 
            case GrantRoleToUser: 
            case RevokeUser: 
            case RevokeRole: 
            case RevokeRoleFromUser: 
            case UpdateUser: {
                return this.authorInfo.authorNonQuery((AuthorPlan)physicalPlan);
            }
            case ApplyConfigNode: {
                return this.nodeInfo.applyConfigNode((ApplyConfigNodePlan)physicalPlan);
            }
            case RemoveConfigNode: {
                return this.nodeInfo.removeConfigNode((RemoveConfigNodePlan)physicalPlan);
            }
            case CreateFunction: {
                return this.udfInfo.addUDFInTable((CreateFunctionPlan)physicalPlan);
            }
            case DropFunction: {
                return this.udfInfo.dropFunction((DropFunctionPlan)physicalPlan);
            }
            case AddTriggerInTable: {
                return this.triggerInfo.addTriggerInTable((AddTriggerInTablePlan)physicalPlan);
            }
            case DeleteTriggerInTable: {
                return this.triggerInfo.deleteTriggerInTable((DeleteTriggerInTablePlan)physicalPlan);
            }
            case UpdateTriggerStateInTable: {
                return this.triggerInfo.updateTriggerStateInTable((UpdateTriggerStateInTablePlan)physicalPlan);
            }
            case UpdateTriggersOnTransferNodes: {
                return this.triggerInfo.updateTriggersOnTransferNodes((UpdateTriggersOnTransferNodesPlan)physicalPlan);
            }
            case UpdateTriggerLocation: {
                return this.triggerInfo.updateTriggerLocation((UpdateTriggerLocationPlan)physicalPlan);
            }
            case CreateSchemaTemplate: {
                return this.clusterSchemaInfo.createSchemaTemplate((CreateSchemaTemplatePlan)physicalPlan);
            }
            case UpdateRegionLocation: {
                return this.partitionInfo.updateRegionLocation((UpdateRegionLocationPlan)physicalPlan);
            }
            case SetSchemaTemplate: {
                return this.clusterSchemaInfo.setSchemaTemplate((SetSchemaTemplatePlan)physicalPlan);
            }
            case PreUnsetTemplate: {
                return this.clusterSchemaInfo.preUnsetSchemaTemplate((PreUnsetSchemaTemplatePlan)physicalPlan);
            }
            case RollbackUnsetTemplate: {
                return this.clusterSchemaInfo.rollbackUnsetSchemaTemplate((RollbackPreUnsetSchemaTemplatePlan)physicalPlan);
            }
            case UnsetTemplate: {
                return this.clusterSchemaInfo.unsetSchemaTemplate((UnsetSchemaTemplatePlan)physicalPlan);
            }
            case DropSchemaTemplate: {
                return this.clusterSchemaInfo.dropSchemaTemplate((DropSchemaTemplatePlan)physicalPlan);
            }
            case CreatePipeSink: {
                return this.syncInfo.addPipeSink((CreatePipeSinkPlan)physicalPlan);
            }
            case DropPipeSink: {
                return this.syncInfo.dropPipeSink((DropPipeSinkPlan)physicalPlan);
            }
            case PreCreatePipe: {
                return this.syncInfo.preCreatePipe((PreCreatePipePlan)physicalPlan);
            }
            case SetPipeStatus: {
                return this.syncInfo.setPipeStatus((SetPipeStatusPlan)physicalPlan);
            }
            case DropPipe: {
                return this.syncInfo.dropPipe((DropPipePlan)physicalPlan);
            }
            case RecordPipeMessage: {
                return this.syncInfo.recordPipeMessage((RecordPipeMessagePlan)physicalPlan);
            }
            case ADD_CQ: {
                return this.cqInfo.addCQ((AddCQPlan)physicalPlan);
            }
            case DROP_CQ: {
                return this.cqInfo.dropCQ((DropCQPlan)physicalPlan);
            }
            case ACTIVE_CQ: {
                return this.cqInfo.activeCQ((ActiveCQPlan)physicalPlan);
            }
            case UPDATE_CQ_LAST_EXEC_TIME: {
                return this.cqInfo.updateCQLastExecutionTime((UpdateCQLastExecTimePlan)physicalPlan);
            }
        }
        throw new UnknownPhysicalPlanTypeException(physicalPlan.getType());
    }

    public boolean takeSnapshot(File snapshotDir) {
        File[] fileList;
        if (!snapshotDir.exists()) {
            LOGGER.warn("snapshot directory [{}] is not exist,start to create it.", (Object)snapshotDir.getAbsolutePath());
            if (!snapshotDir.mkdirs()) {
                LOGGER.error("snapshot directory [{}] can not be created.", (Object)snapshotDir.getAbsolutePath());
                return false;
            }
        }
        if ((fileList = snapshotDir.listFiles()) != null && fileList.length > 0) {
            LOGGER.error("snapshot directory [{}] is not empty.", (Object)snapshotDir.getAbsolutePath());
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        this.snapshotProcessorList.parallelStream().forEach(x -> {
            boolean takeSnapshotResult = true;
            try {
                takeSnapshotResult = x.processTakeSnapshot(snapshotDir);
            }
            catch (IOException | TException e) {
                LOGGER.error("Take snapshot error: {}", (Object)e.getMessage());
                takeSnapshotResult = false;
            }
            finally {
                if (!takeSnapshotResult) {
                    result.set(false);
                }
            }
        });
        if (result.get()) {
            LOGGER.info("Task snapshot success, snapshotDir: {}", (Object)snapshotDir);
        }
        return result.get();
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        if (!latestSnapshotRootDir.exists()) {
            LOGGER.error("snapshot directory [{}] is not exist, can not load snapshot with this directory.", (Object)latestSnapshotRootDir.getAbsolutePath());
            return;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        this.snapshotProcessorList.parallelStream().forEach(x -> {
            try {
                x.processLoadSnapshot(latestSnapshotRootDir);
            }
            catch (IOException | TException e) {
                result.set(false);
                LOGGER.error("Load snapshot error: {}", (Object)e.getMessage());
            }
        });
        if (result.get()) {
            LOGGER.info("Load snapshot success, latestSnapshotRootDir: {}", (Object)latestSnapshotRootDir);
        }
    }

    private DataSet getSchemaNodeManagementPartition(ConfigPhysicalPlan req) {
        Set needMatchedNode;
        Set<TSchemaNode> alreadyMatchedNode;
        Object matchedChildInNextLevel;
        ArrayList<String> matchedStorageGroups = new ArrayList<String>();
        GetNodePathsPartitionPlan getNodePathsPartitionPlan = (GetNodePathsPartitionPlan)req;
        PartialPath partialPath = getNodePathsPartitionPlan.getPartialPath();
        int level = getNodePathsPartitionPlan.getLevel();
        if (-1 == level) {
            matchedChildInNextLevel = this.clusterSchemaInfo.getChildNodePathInNextLevel(partialPath);
            alreadyMatchedNode = (Set<TSchemaNode>)matchedChildInNextLevel.left;
            needMatchedNode = (Set)matchedChildInNextLevel.right;
        } else {
            matchedChildInNextLevel = this.clusterSchemaInfo.getNodesListInGivenLevel(partialPath, level);
            alreadyMatchedNode = ((List)matchedChildInNextLevel.left).stream().map(path -> new TSchemaNode(path.getFullPath(), MNodeType.UNIMPLEMENT.getNodeType())).collect(Collectors.toSet());
            needMatchedNode = (Set)matchedChildInNextLevel.right;
        }
        needMatchedNode.forEach(nodePath -> matchedStorageGroups.add(nodePath.getFullPath()));
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)this.partitionInfo.getSchemaNodeManagementPartition(matchedStorageGroups);
        if (schemaNodeManagementResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            schemaNodeManagementResp.setMatchedNode(alreadyMatchedNode);
        }
        return schemaNodeManagementResp;
    }

    private DataSet getRegionInfoList(ConfigPhysicalPlan req) {
        List storageGroups;
        List matchedStorageGroups;
        GetRegionInfoListPlan getRegionInfoListPlan = (GetRegionInfoListPlan)req;
        TShowRegionReq showRegionReq = getRegionInfoListPlan.getShowRegionReq();
        if (showRegionReq != null && showRegionReq.isSetStorageGroups() && !(matchedStorageGroups = this.clusterSchemaInfo.getMatchedStorageGroupSchemasByName(storageGroups = showRegionReq.getStorageGroups()).values().stream().map(TStorageGroupSchema::getName).collect(Collectors.toList())).isEmpty()) {
            showRegionReq.setStorageGroups(matchedStorageGroups);
        }
        return this.partitionInfo.getRegionInfoList(getRegionInfoListPlan);
    }
}

