/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionIdPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.storagegroup.CountStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.storagegroup.GetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.ConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.CountStorageGroupResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeToStatusResp;
import org.apache.iotdb.confignode.consensus.response.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.SchemaPartitionResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.consensus.response.TemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.statemachine.ConfigNodeRegionStateMachine;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.PermissionManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.SyncManager;
import org.apache.iotdb.confignode.manager.TriggerManager;
import org.apache.iotdb.confignode.manager.UDFManager;
import org.apache.iotdb.confignode.manager.cq.CQManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.ClusterNodeStartUtils;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.cq.CQInfo;
import org.apache.iotdb.confignode.persistence.executor.ConfigPlanExecutor;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.persistence.sync.ClusterSyncInfo;
import org.apache.iotdb.confignode.rpc.thrift.TClusterParameters;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRecordPipeMessageReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
implements IManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig COMMON_CONF = CommonDescriptor.getInstance().getConfig();
    private volatile ConsensusManager consensusManager;
    private final NodeManager nodeManager;
    private final ClusterSchemaManager clusterSchemaManager;
    private final PartitionManager partitionManager;
    private final PermissionManager permissionManager;
    private final LoadManager loadManager;
    private final ProcedureManager procedureManager;
    private final UDFManager udfManager;
    private final TriggerManager triggerManager;
    private final SyncManager syncManager;
    private final CQManager cqManager;
    private final ConfigNodeRegionStateMachine stateMachine;

    public ConfigManager() throws IOException {
        NodeInfo nodeInfo = new NodeInfo();
        ClusterSchemaInfo clusterSchemaInfo = new ClusterSchemaInfo();
        PartitionInfo partitionInfo = new PartitionInfo();
        AuthorInfo authorInfo = new AuthorInfo();
        ProcedureInfo procedureInfo = new ProcedureInfo();
        UDFInfo udfInfo = new UDFInfo();
        TriggerInfo triggerInfo = new TriggerInfo();
        ClusterSyncInfo syncInfo = new ClusterSyncInfo();
        CQInfo cqInfo = new CQInfo();
        ConfigPlanExecutor executor = new ConfigPlanExecutor(nodeInfo, clusterSchemaInfo, partitionInfo, authorInfo, procedureInfo, udfInfo, triggerInfo, syncInfo, cqInfo);
        this.stateMachine = new ConfigNodeRegionStateMachine(this, executor);
        this.nodeManager = new NodeManager(this, nodeInfo);
        this.clusterSchemaManager = new ClusterSchemaManager(this, clusterSchemaInfo);
        this.partitionManager = new PartitionManager(this, partitionInfo);
        this.permissionManager = new PermissionManager(this, authorInfo);
        this.procedureManager = new ProcedureManager(this, procedureInfo);
        this.udfManager = new UDFManager(this, udfInfo);
        this.triggerManager = new TriggerManager(this, triggerInfo);
        this.loadManager = new LoadManager(this);
        this.syncManager = new SyncManager(this, syncInfo);
        this.cqManager = new CQManager(this);
    }

    public void initConsensusManager() throws IOException {
        this.consensusManager = new ConsensusManager(this, this.stateMachine);
    }

    public void close() throws IOException {
        if (this.consensusManager != null) {
            this.consensusManager.close();
        }
        if (this.partitionManager != null) {
            this.partitionManager.getRegionMaintainer().shutdown();
        }
        if (this.procedureManager != null) {
            this.procedureManager.shiftExecutor(false);
        }
    }

    @Override
    public DataSet getSystemConfiguration() {
        ConfigurationResp dataSet;
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ConfigNodeDescriptor.getInstance().isSeedConfigNode() || SystemPropertiesUtils.isSeedConfigNode()) {
            dataSet = (ConfigurationResp)this.nodeManager.getSystemConfiguration();
        } else {
            dataSet = new ConfigurationResp();
            dataSet.setStatus(status);
        }
        return dataSet;
    }

    @Override
    public DataSet registerDataNode(TDataNodeRegisterReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = ClusterNodeStartUtils.confirmNodeRegistration(NodeType.DataNode, req.getClusterName(), req.getDataNodeConfiguration().getLocation(), this)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.registerDataNode(new RegisterDataNodePlan(req.getDataNodeConfiguration()));
        }
        DataNodeRegisterResp resp = new DataNodeRegisterResp();
        resp.setStatus(status);
        resp.setConfigNodeList(this.getNodeManager().getRegisteredConfigNodes());
        return resp;
    }

    @Override
    public TDataNodeRestartResp restartDataNode(TDataNodeRestartReq req) {
        TSStatus status = this.confirmLeader();
        if ((status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ConfigNodeDescriptor.getInstance().isSeedConfigNode() || SystemPropertiesUtils.isSeedConfigNode()) && (status = ClusterNodeStartUtils.confirmNodeRestart(NodeType.DataNode, req.getClusterName(), req.getDataNodeConfiguration().getLocation().getDataNodeId(), req.getDataNodeConfiguration().getLocation(), this)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.restartDataNode(req.getDataNodeConfiguration().getLocation());
        }
        return new TDataNodeRestartResp().setStatus(status).setConfigNodeList(this.getNodeManager().getRegisteredConfigNodes());
    }

    @Override
    public DataSet removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.removeDataNode(removeDataNodePlan);
        }
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public DataSet updateDataNode(UpdateDataNodePlan updateDataNodePlan) {
        DataNodeRegisterResp dataSet;
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            dataSet = (DataNodeRegisterResp)this.nodeManager.updateDataNode(updateDataNodePlan);
        } else {
            dataSet = new DataNodeRegisterResp();
            dataSet.setStatus(status);
            dataSet.setConfigNodeList(this.nodeManager.getRegisteredConfigNodes());
        }
        return dataSet;
    }

    @Override
    public TSStatus reportRegionMigrateResult(TRegionMigrateResultReportReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.procedureManager.reportRegionMigrateResult(req);
        }
        return status;
    }

    @Override
    public DataSet getDataNodeConfiguration(GetDataNodeConfigurationPlan getDataNodeConfigurationPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.getDataNodeConfiguration(getDataNodeConfigurationPlan);
        }
        DataNodeConfigurationResp dataSet = new DataNodeConfigurationResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TShowClusterResp showCluster() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List<TConfigNodeLocation> configNodeLocations = this.getNodeManager().getRegisteredConfigNodes();
            configNodeLocations.sort(Comparator.comparingInt(TConfigNodeLocation::getConfigNodeId));
            List dataNodeInfoLocations = this.getNodeManager().getRegisteredDataNodes().stream().map(TDataNodeConfiguration::getLocation).sorted(Comparator.comparingInt(TDataNodeLocation::getDataNodeId)).collect(Collectors.toList());
            HashMap nodeStatus = new HashMap();
            this.getNodeManager().getNodeCacheMap().forEach((nodeId, heartbeatCache) -> nodeStatus.put(nodeId, heartbeatCache.getNodeStatusWithReason()));
            return new TShowClusterResp(status, configNodeLocations, dataNodeInfoLocations, nodeStatus);
        }
        return new TShowClusterResp(status, new ArrayList(), new ArrayList(), new HashMap());
    }

    @Override
    public TShowVariablesResp showVariables() {
        TSStatus status = this.confirmLeader();
        TShowVariablesResp resp = new TShowVariablesResp();
        resp.setStatus(status);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setClusterParameters(this.getClusterParameters());
        }
        return resp;
    }

    public TClusterParameters getClusterParameters() {
        TClusterParameters clusterParameters = new TClusterParameters();
        clusterParameters.setClusterName(CONF.getClusterName());
        clusterParameters.setConfigNodeConsensusProtocolClass(CONF.getConfigNodeConsensusProtocolClass());
        clusterParameters.setDataRegionConsensusProtocolClass(CONF.getDataRegionConsensusProtocolClass());
        clusterParameters.setSchemaRegionConsensusProtocolClass(CONF.getSchemaRegionConsensusProtocolClass());
        clusterParameters.setSeriesPartitionSlotNum(CONF.getSeriesSlotNum());
        clusterParameters.setSeriesPartitionExecutorClass(CONF.getSeriesPartitionExecutorClass());
        clusterParameters.setDefaultTTL(COMMON_CONF.getDefaultTTLInMs());
        clusterParameters.setTimePartitionInterval(CONF.getTimePartitionInterval());
        clusterParameters.setDataReplicationFactor(CONF.getDataReplicationFactor());
        clusterParameters.setSchemaReplicationFactor(CONF.getSchemaReplicationFactor());
        clusterParameters.setDataRegionPerProcessor(CONF.getDataRegionPerProcessor());
        clusterParameters.setSchemaRegionPerDataNode(CONF.getSchemaRegionPerDataNode());
        clusterParameters.setDiskSpaceWarningThreshold(COMMON_CONF.getDiskSpaceWarningThreshold());
        clusterParameters.setReadConsistencyLevel(CONF.getReadConsistencyLevel());
        clusterParameters.setLeastDataRegionGroupNum(CONF.getLeastDataRegionGroupNum());
        return clusterParameters;
    }

    @Override
    public TSStatus setTTL(SetTTLPlan setTTLPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTTL(setTTLPlan);
        }
        return status;
    }

    @Override
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan setSchemaReplicationFactorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setSchemaReplicationFactor(setSchemaReplicationFactorPlan);
        }
        return status;
    }

    @Override
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan setDataReplicationFactorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setDataReplicationFactor(setDataReplicationFactorPlan);
        }
        return status;
    }

    @Override
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan setTimePartitionIntervalPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTimePartitionInterval(setTimePartitionIntervalPlan);
        }
        return status;
    }

    @Override
    public DataSet countMatchedStorageGroups(CountStorageGroupPlan countStorageGroupPlan) {
        TSStatus status = this.confirmLeader();
        CountStorageGroupResp result = new CountStorageGroupResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.countMatchedStorageGroups(countStorageGroupPlan);
        }
        result.setStatus(status);
        return result;
    }

    @Override
    public DataSet getMatchedStorageGroupSchemas(GetStorageGroupPlan getStorageGroupReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getMatchedStorageGroupSchema(getStorageGroupReq);
        }
        StorageGroupSchemaResp dataSet = new StorageGroupSchemaResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public synchronized TSStatus setStorageGroup(SetStorageGroupPlan setStorageGroupPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setStorageGroup(setStorageGroupPlan);
        }
        return status;
    }

    @Override
    public synchronized TSStatus deleteStorageGroups(List<String> deletedPaths) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            Map<String, TStorageGroupSchema> deleteStorageSchemaMap = this.getClusterSchemaManager().getMatchedStorageGroupSchemasByName(deletedPaths);
            if (deleteStorageSchemaMap.isEmpty()) {
                return RpcUtils.getStatus((int)TSStatusCode.PATH_NOT_EXIST.getStatusCode(), (String)String.format("Path %s does not exist", Arrays.toString(deletedPaths.toArray())));
            }
            ArrayList<TStorageGroupSchema> parsedDeleteStorageGroups = new ArrayList<TStorageGroupSchema>(deleteStorageSchemaMap.values());
            return this.procedureManager.deleteStorageGroups(parsedDeleteStorageGroups);
        }
        return status;
    }

    private List<TSeriesPartitionSlot> calculateRelatedSlot(PartialPath path, PartialPath storageGroup) {
        if (path.getFullPath().contains("**")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        PartialPath innerPath = (PartialPath)path.alterPrefixPath(storageGroup).get(0);
        if (innerPath.getDevice().contains("*")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        return Collections.singletonList(this.getPartitionManager().getSeriesPartitionSlot(innerPath.getDevice()));
    }

    @Override
    public TSchemaPartitionTableResp getSchemaPartition(PathPatternTree patternTree) {
        TSchemaPartitionTableResp resp = new TSchemaPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        HashMap<String, Set> partitionSlotsMap = new HashMap<String, Set>();
        List relatedPaths = patternTree.getAllPathPatterns();
        List<String> allStorageGroups = this.getClusterSchemaManager().getStorageGroupNames();
        ArrayList<PartialPath> allStorageGroupPaths = new ArrayList<PartialPath>();
        for (String string : allStorageGroups) {
            try {
                allStorageGroupPaths.add(new PartialPath(string));
            }
            catch (IllegalPathException e2) {
                throw new RuntimeException(e2);
            }
        }
        HashMap<String, Boolean> scanAllRegions = new HashMap<String, Boolean>();
        for (PartialPath path : relatedPaths) {
            for (int i = 0; i < allStorageGroups.size(); ++i) {
                String storageGroup = allStorageGroups.get(i);
                PartialPath storageGroupPath = (PartialPath)allStorageGroupPaths.get(i);
                if (!path.overlapWith(storageGroupPath.concatNode("**")) || scanAllRegions.containsKey(storageGroup)) continue;
                List<TSeriesPartitionSlot> relatedSlot = this.calculateRelatedSlot(path, storageGroupPath);
                if (relatedSlot.isEmpty()) {
                    scanAllRegions.put(storageGroup, true);
                    partitionSlotsMap.put(storageGroup, new HashSet());
                    continue;
                }
                partitionSlotsMap.computeIfAbsent(storageGroup, k -> new HashSet()).addAll(relatedSlot);
            }
        }
        if (partitionSlotsMap.isEmpty()) {
            return resp.setStatus(StatusUtils.OK).setSchemaPartitionTable(new HashMap());
        }
        GetSchemaPartitionPlan getSchemaPartitionPlan = new GetSchemaPartitionPlan(partitionSlotsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()))));
        SchemaPartitionResp queryResult = (SchemaPartitionResp)this.partitionManager.getSchemaPartition(getSchemaPartitionPlan);
        resp = queryResult.convertToRpcSchemaPartitionTableResp();
        LOGGER.debug("GetSchemaPartition receive paths: {}, return: {}", (Object)relatedPaths, (Object)resp);
        return resp;
    }

    @Override
    public TSchemaPartitionTableResp getOrCreateSchemaPartition(PathPatternTree patternTree) {
        TSchemaPartitionTableResp resp = new TSchemaPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        List devicePaths = patternTree.getAllDevicePatterns();
        List<String> storageGroups = this.getClusterSchemaManager().getStorageGroupNames();
        HashMap<String, List<TSeriesPartitionSlot>> partitionSlotsMap = new HashMap<String, List<TSeriesPartitionSlot>>();
        block0: for (String devicePath : devicePaths) {
            if (devicePath.contains("*")) continue;
            for (String storageGroup : storageGroups) {
                if (!PathUtils.isStartWith((String)devicePath, (String)storageGroup)) continue;
                partitionSlotsMap.computeIfAbsent(storageGroup, key -> new ArrayList()).add(this.getPartitionManager().getSeriesPartitionSlot(devicePath));
                continue block0;
            }
        }
        GetOrCreateSchemaPartitionPlan getOrCreateSchemaPartitionPlan = new GetOrCreateSchemaPartitionPlan(partitionSlotsMap);
        SchemaPartitionResp queryResult = this.partitionManager.getOrCreateSchemaPartition(getOrCreateSchemaPartitionPlan);
        resp = queryResult.convertToRpcSchemaPartitionTableResp();
        LOGGER.debug("GetOrCreateSchemaPartition receive devicePaths: {}, return TSchemaPartitionResp: {}", (Object)devicePaths, (Object)resp);
        return resp;
    }

    @Override
    public TSchemaNodeManagementResp getNodePathsPartition(PartialPath partialPath, Integer level) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            GetNodePathsPartitionPlan getNodePathsPartitionPlan = new GetNodePathsPartitionPlan();
            getNodePathsPartitionPlan.setPartialPath(partialPath);
            if (null != level) {
                getNodePathsPartitionPlan.setLevel(level);
            }
            SchemaNodeManagementResp resp = this.partitionManager.getNodePathsPartition(getNodePathsPartitionPlan);
            TSchemaNodeManagementResp result = resp.convertToRpcSchemaNodeManagementPartitionResp(this.getLoadManager().getLatestRegionRouteMap());
            LOGGER.info("getNodePathsPartition receive devicePaths: {}, level: {}, return TSchemaNodeManagementResp: {}", new Object[]{partialPath, level, result});
            return result;
        }
        return new TSchemaNodeManagementResp().setStatus(status);
    }

    @Override
    public TDataPartitionTableResp getDataPartition(GetDataPartitionPlan getDataPartitionPlan) {
        TDataPartitionTableResp resp = new TDataPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        DataPartitionResp queryResult = (DataPartitionResp)this.partitionManager.getDataPartition(getDataPartitionPlan);
        resp = queryResult.convertToTDataPartitionTableResp();
        LOGGER.debug("GetDataPartition interface receive PartitionSlotsMap: {}, return: {}", getDataPartitionPlan.getPartitionSlotsMap(), (Object)resp);
        return resp;
    }

    @Override
    public TDataPartitionTableResp getOrCreateDataPartition(GetOrCreateDataPartitionPlan getOrCreateDataPartitionReq) {
        TDataPartitionTableResp resp = new TDataPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        DataPartitionResp queryResult = this.partitionManager.getOrCreateDataPartition(getOrCreateDataPartitionReq);
        resp = queryResult.convertToTDataPartitionTableResp();
        LOGGER.debug("GetOrCreateDataPartition success. receive PartitionSlotsMap: {}, return: {}", getOrCreateDataPartitionReq.getPartitionSlotsMap(), (Object)resp);
        return resp;
    }

    private TSStatus confirmLeader() {
        if (this.getConsensusManager() == null) {
            return new TSStatus(TSStatusCode.CONSENSUS_NOT_INITIALIZED.getStatusCode()).setMessage("ConsensusManager of target-ConfigNode is not initialized, please make sure the target-ConfigNode has been started successfully.");
        }
        return this.getConsensusManager().confirmLeader();
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public ClusterSchemaManager getClusterSchemaManager() {
        return this.clusterSchemaManager;
    }

    @Override
    public ConsensusManager getConsensusManager() {
        return this.consensusManager;
    }

    @Override
    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    @Override
    public LoadManager getLoadManager() {
        return this.loadManager;
    }

    @Override
    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public SyncManager getSyncManager() {
        return this.syncManager;
    }

    @Override
    public TSStatus operatePermission(AuthorPlan authorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.operatePermission(authorPlan);
        }
        return status;
    }

    @Override
    public DataSet queryPermission(AuthorPlan authorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.queryPermission(authorPlan);
        }
        PermissionInfoResp dataSet = new PermissionInfoResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TPermissionInfoResp login(String username, String password) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.login(username, password);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    @Override
    public TPermissionInfoResp checkUserPrivileges(String username, List<String> paths, int permission) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.checkUserPrivileges(username, paths, permission);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    @Override
    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        int ERROR_STATUS_NODE_ID = -1;
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = this.checkConfigNodeGlobalConfig(req)) == null && (status = ClusterNodeStartUtils.confirmNodeRegistration(NodeType.ConfigNode, req.getClusterParameters().getClusterName(), req.getConfigNodeLocation(), this)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.registerConfigNode(req);
        }
        return new TConfigNodeRegisterResp().setStatus(status).setConfigNodeId(-1);
    }

    @Override
    public TSStatus restartConfigNode(TConfigNodeRestartReq req) {
        TSStatus status = this.confirmLeader();
        if ((status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ConfigNodeDescriptor.getInstance().isSeedConfigNode() || SystemPropertiesUtils.isSeedConfigNode()) && (status = ClusterNodeStartUtils.confirmNodeRestart(NodeType.ConfigNode, req.getClusterName(), req.getConfigNodeLocation().getConfigNodeId(), req.getConfigNodeLocation(), this)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.restartConfigNode(req.getConfigNodeLocation());
        }
        return status;
    }

    @Override
    public TSStatus checkConfigNodeGlobalConfig(TConfigNodeRegisterReq req) {
        String errorPrefix = "Reject register, please ensure that the parameter ";
        String errorSuffix = " is consistent with the Seed-ConfigNode.";
        TSStatus errorStatus = new TSStatus(TSStatusCode.CONFIGURATION_ERROR.getStatusCode());
        TClusterParameters clusterParameters = req.getClusterParameters();
        if (!clusterParameters.getConfigNodeConsensusProtocolClass().equals(CONF.getConfigNodeConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter config_node_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getDataRegionConsensusProtocolClass().equals(CONF.getDataRegionConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_region_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getSchemaRegionConsensusProtocolClass().equals(CONF.getSchemaRegionConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_region_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getSeriesPartitionSlotNum() != CONF.getSeriesSlotNum()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter series_partition_slot_num is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getSeriesPartitionExecutorClass().equals(CONF.getSeriesPartitionExecutorClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter series_partition_executor_class is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDefaultTTL() != CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter default_ttl is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getTimePartitionInterval() != CONF.getTimePartitionInterval()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter time_partition_interval is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getSchemaReplicationFactor() != CONF.getSchemaReplicationFactor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_replication_factor is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDataReplicationFactor() != CONF.getDataReplicationFactor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_replication_factor is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getSchemaRegionPerDataNode() != CONF.getSchemaRegionPerDataNode()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_region_per_data_node is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDataRegionPerProcessor() != CONF.getDataRegionPerProcessor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_region_per_processor is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getReadConsistencyLevel().equals(CONF.getReadConsistencyLevel())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter read_consistency_level is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDiskSpaceWarningThreshold() != CommonDescriptor.getInstance().getConfig().getDiskSpaceWarningThreshold()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter disk_space_warning_threshold is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getLeastDataRegionGroupNum() != CONF.getLeastDataRegionGroupNum()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter least_data_region_group_num is consistent with the Seed-ConfigNode.");
        }
        return null;
    }

    @Override
    public TSStatus createPeerForConsensusGroup(List<TConfigNodeLocation> configNodeLocations) {
        for (int i = 0; i < 30; ++i) {
            try {
                if (this.consensusManager != null) {
                    this.consensusManager.createPeerForConsensusGroup(Collections.emptyList());
                    return StatusUtils.OK;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Unexpected interruption during retry creating peer for consensus group");
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed to create peer for consensus group", (Throwable)e);
                break;
            }
        }
        return StatusUtils.INTERNAL_ERROR;
    }

    @Override
    public TSStatus removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = this.nodeManager.checkConfigNodeBeforeRemove(removeConfigNodePlan)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.procedureManager.removeConfigNode(removeConfigNodePlan);
        }
        return status;
    }

    @Override
    public TSStatus createFunction(TCreateFunctionReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.createFunction(req) : status;
    }

    @Override
    public TSStatus dropFunction(String udfName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.dropFunction(udfName) : status;
    }

    @Override
    public TGetUDFTableResp getUDFTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.getUDFTable() : new TGetUDFTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetJarInListResp getUDFJar(TGetJarInListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.getUDFJar(req) : new TGetJarInListResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus createTrigger(TCreateTriggerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.createTrigger(req) : status;
    }

    @Override
    public TSStatus dropTrigger(TDropTriggerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.dropTrigger(req) : status;
    }

    @Override
    public TGetTriggerTableResp getTriggerTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerTable(false) : new TGetTriggerTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetTriggerTableResp getStatefulTriggerTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerTable(true) : new TGetTriggerTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetLocationForTriggerResp getLocationOfStatefulTrigger(String triggerName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getLocationOfStatefulTrigger(triggerName) : new TGetLocationForTriggerResp(status);
    }

    @Override
    public TGetJarInListResp getTriggerJar(TGetJarInListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerJar(req) : new TGetJarInListResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus merge() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.merge()) : status;
    }

    @Override
    public TSStatus flush(TFlushReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.flush(req)) : status;
    }

    @Override
    public TSStatus clearCache() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.clearCache()) : status;
    }

    @Override
    public TSStatus loadConfiguration() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.loadConfiguration()) : status;
    }

    @Override
    public TSStatus setSystemStatus(String systemStatus) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.setSystemStatus(systemStatus)) : status;
    }

    @Override
    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.nodeManager.setDataNodeStatus(req) : status;
    }

    @Override
    public TRegionRouteMapResp getLatestRegionRouteMap() {
        TSStatus status = this.confirmLeader();
        TRegionRouteMapResp resp = new TRegionRouteMapResp(status);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setTimestamp(System.currentTimeMillis());
            resp.setRegionRouteMap(this.getLoadManager().getLatestRegionRouteMap());
        }
        return resp;
    }

    @Override
    public UDFManager getUDFManager() {
        return this.udfManager;
    }

    @Override
    public RegionInfoListResp showRegion(GetRegionInfoListPlan getRegionInfoListPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.partitionManager.getRegionInfoList(getRegionInfoListPlan);
        }
        RegionInfoListResp regionResp = new RegionInfoListResp();
        regionResp.setStatus(status);
        return regionResp;
    }

    @Override
    public TShowDataNodesResp showDataNodes() {
        TSStatus status = this.confirmLeader();
        TShowDataNodesResp resp = new TShowDataNodesResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setDataNodesInfoList(this.nodeManager.getRegisteredDataNodeInfoList()).setStatus(StatusUtils.OK);
        }
        return resp.setStatus(status);
    }

    @Override
    public TShowConfigNodesResp showConfigNodes() {
        TSStatus status = this.confirmLeader();
        TShowConfigNodesResp resp = new TShowConfigNodesResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setConfigNodesInfoList(this.nodeManager.getRegisteredConfigNodeInfoList()).setStatus(StatusUtils.OK);
        }
        return resp.setStatus(status);
    }

    @Override
    public TShowStorageGroupResp showStorageGroup(GetStorageGroupPlan getStorageGroupPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.getClusterSchemaManager().showStorageGroup(getStorageGroupPlan);
        }
        return new TShowStorageGroupResp().setStatus(status);
    }

    @Override
    public ProcedureManager getProcedureManager() {
        return this.procedureManager;
    }

    @Override
    public CQManager getCQManager() {
        return this.cqManager;
    }

    public List<PartialPath> checkStorageGroupExist(List<PartialPath> storageGroups) {
        ArrayList<PartialPath> noExistSg = new ArrayList<PartialPath>();
        if (storageGroups == null) {
            return noExistSg;
        }
        for (PartialPath storageGroup : storageGroups) {
            if (this.clusterSchemaManager.getStorageGroupNames().contains(storageGroup.toString())) continue;
            noExistSg.add(storageGroup);
        }
        return noExistSg;
    }

    @Override
    public void addMetrics() {
        this.partitionManager.addMetrics();
    }

    @Override
    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            CreateSchemaTemplatePlan createSchemaTemplatePlan = new CreateSchemaTemplatePlan(req.getSerializedTemplate());
            return this.clusterSchemaManager.createTemplate(createSchemaTemplatePlan);
        }
        return status;
    }

    @Override
    public TGetAllTemplatesResp getAllTemplates() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getAllTemplates();
        }
        return new TGetAllTemplatesResp().setStatus(status);
    }

    @Override
    public TGetTemplateResp getTemplate(String req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getTemplate(req);
        }
        return new TGetTemplateResp().setStatus(status);
    }

    @Override
    public TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setSchemaTemplate(req.getName(), req.getPath());
        }
        return status;
    }

    @Override
    public TGetPathsSetTemplatesResp getPathsSetTemplate(String req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getPathsSetTemplate(req);
        }
        return new TGetPathsSetTemplatesResp(status);
    }

    @Override
    public TSStatus deactivateSchemaTemplate(TDeactivateSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        List patternList = patternTree.getAllPathPatterns();
        TemplateSetInfoResp templateSetInfoResp = this.clusterSchemaManager.getTemplateSetInfo(patternList);
        if (templateSetInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return templateSetInfoResp.getStatus();
        }
        Map<PartialPath, List<Template>> templateSetInfo = templateSetInfoResp.getPatternTemplateMap();
        if (templateSetInfo.isEmpty()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TEMPLATE_NOT_SET, (String)String.format("Schema Template %s is not set on any prefix path of %s", req.getTemplateName(), patternList));
        }
        if (!req.getTemplateName().equals("*")) {
            HashMap<PartialPath, List<Template>> filteredTemplateSetInfo = new HashMap<PartialPath, List<Template>>();
            block0: for (Map.Entry<PartialPath, List<Template>> entry : templateSetInfo.entrySet()) {
                for (Template template : entry.getValue()) {
                    if (!template.getName().equals(req.getTemplateName())) continue;
                    filteredTemplateSetInfo.put(entry.getKey(), Collections.singletonList(template));
                    continue block0;
                }
            }
            if (filteredTemplateSetInfo.isEmpty()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TEMPLATE_NOT_SET, (String)String.format("Schema Template %s is not set on any prefix path of %s", req.getTemplateName(), patternList));
            }
            templateSetInfo = filteredTemplateSetInfo;
        }
        return this.procedureManager.deactivateTemplate(req.getQueryId(), templateSetInfo);
    }

    @Override
    public TSStatus unsetSchemaTemplate(TUnsetSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        Pair<TSStatus, Template> checkResult = this.clusterSchemaManager.checkIsTemplateSetOnPath(req.getTemplateName(), req.getPath());
        if (((TSStatus)checkResult.left).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            try {
                return this.procedureManager.unsetSchemaTemplate(req.getQueryId(), (Template)checkResult.right, new PartialPath(req.getPath()));
            }
            catch (IllegalPathException e) {
                return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            }
        }
        return (TSStatus)checkResult.left;
    }

    @Override
    public TSStatus dropSchemaTemplate(String templateName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.dropSchemaTemplate(templateName);
        }
        return status;
    }

    @Override
    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.deleteTimeSeries(req);
        }
        return status;
    }

    @Override
    public TSStatus createPipeSink(CreatePipeSinkPlan plan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.createPipeSink(plan);
        }
        return status;
    }

    @Override
    public TSStatus dropPipeSink(DropPipeSinkPlan plan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.dropPipeSink(plan);
        }
        return status;
    }

    @Override
    public TGetPipeSinkResp getPipeSink(TGetPipeSinkReq req) {
        TSStatus status = this.confirmLeader();
        TGetPipeSinkResp resp = new TGetPipeSinkResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.getPipeSink(req.getPipeSinkName());
        }
        return resp.setStatus(status);
    }

    @Override
    public TSStatus createPipe(TCreatePipeReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.createPipe(req);
        }
        return status;
    }

    @Override
    public TSStatus startPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.startPipe(pipeName);
        }
        return status;
    }

    @Override
    public TSStatus stopPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.stopPipe(pipeName);
        }
        return status;
    }

    @Override
    public TSStatus dropPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.dropPipe(pipeName);
        }
        return status;
    }

    @Override
    public TShowPipeResp showPipe(TShowPipeReq req) {
        TSStatus status = this.confirmLeader();
        TShowPipeResp resp = new TShowPipeResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.showPipe(req.getPipeName());
        }
        return resp.setStatus(status);
    }

    @Override
    public TGetAllPipeInfoResp getAllPipeInfo() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.getAllPipeInfo();
        }
        return new TGetAllPipeInfoResp().setStatus(status);
    }

    @Override
    public TSStatus recordPipeMessage(TRecordPipeMessageReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.recordPipeMessage(req.getPipeName(), PipeMessage.deserialize((ByteBuffer)ByteBuffer.wrap(req.getMessage())));
        }
        return status;
    }

    @Override
    public TGetRegionIdResp getRegionId(GetRegionIdPlan plan) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getRegionId(plan).convertToRpcGetRegionIdResp() : new TGetRegionIdResp(status);
    }

    @Override
    public TGetTimeSlotListResp getTimeSlotList(GetTimeSlotListPlan plan) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getTimeSlotList(plan).convertToRpcGetTimeSlotListResp() : new TGetTimeSlotListResp(status);
    }

    @Override
    public TGetSeriesSlotListResp getSeriesSlotList(GetSeriesSlotListPlan plan) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getSeriesSlotList(plan).convertToRpcGetSeriesSlotListResp() : new TGetSeriesSlotListResp(status);
    }

    @Override
    public TSStatus createCQ(TCreateCQReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.cqManager.createCQ(req) : status;
    }

    @Override
    public TSStatus dropCQ(TDropCQReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.cqManager.dropCQ(req) : status;
    }

    @Override
    public TShowCQResp showCQ() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.cqManager.showCQ() : new TShowCQResp(status, Collections.emptyList());
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRelatedSchemaRegionGroup(PathPatternTree patternTree) {
        Map schemaPartitionTable = this.getSchemaPartition(patternTree).getSchemaPartitionTable();
        List<TRegionReplicaSet> allRegionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        Set groupIdSet = schemaPartitionTable.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
        HashMap<TConsensusGroupId, TRegionReplicaSet> filteredRegionReplicaSets = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (TRegionReplicaSet regionReplicaSet : allRegionReplicaSets) {
            if (!groupIdSet.contains(regionReplicaSet.getRegionId())) continue;
            filteredRegionReplicaSets.put(regionReplicaSet.getRegionId(), regionReplicaSet);
        }
        return filteredRegionReplicaSets;
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRelatedDataRegionGroup(PathPatternTree patternTree) {
        Map schemaPartitionTable = this.getSchemaPartition(patternTree).getSchemaPartitionTable();
        HashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>> partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>>();
        schemaPartitionTable.forEach((key, value) -> {
            HashMap slotListMap = new HashMap();
            value.keySet().forEach(slot -> slotListMap.put(slot, new TTimeSlotList(Collections.emptyList(), true, true)));
            partitionSlotsMap.put((String)key, slotListMap);
        });
        GetDataPartitionPlan getDataPartitionPlan = new GetDataPartitionPlan(partitionSlotsMap);
        Map dataPartitionTable = this.getDataPartition(getDataPartitionPlan).getDataPartitionTable();
        List<TRegionReplicaSet> allRegionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        Set groupIdSet = dataPartitionTable.values().stream().flatMap(tSeriesPartitionSlotMapMap -> tSeriesPartitionSlotMapMap.values().stream().flatMap(tTimePartitionSlotListMap -> tTimePartitionSlotListMap.values().stream().flatMap(Collection::stream))).collect(Collectors.toSet());
        HashMap<TConsensusGroupId, TRegionReplicaSet> filteredRegionReplicaSets = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (TRegionReplicaSet regionReplicaSet : allRegionReplicaSets) {
            if (!groupIdSet.contains(regionReplicaSet.getRegionId())) continue;
            filteredRegionReplicaSets.put(regionReplicaSet.getRegionId(), regionReplicaSet);
        }
        return filteredRegionReplicaSets;
    }

    @Override
    public TSStatus transfer(List<TDataNodeLocation> newUnknownDataList) {
        HashMap<Integer, TDataNodeLocation> runningDataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
        this.nodeManager.filterDataNodeThroughStatus(NodeStatus.Running).forEach(dataNodeConfiguration -> runningDataNodeLocationMap.put(dataNodeConfiguration.getLocation().getDataNodeId(), dataNodeConfiguration.getLocation()));
        if (runningDataNodeLocationMap.isEmpty()) {
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        newUnknownDataList.forEach(dataNodeLocation -> runningDataNodeLocationMap.remove(dataNodeLocation.getDataNodeId()));
        LOGGER.info("Start transfer of {}", newUnknownDataList);
        TSStatus transferResult = this.triggerManager.transferTrigger(newUnknownDataList, runningDataNodeLocationMap);
        if (transferResult.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Fail to transfer because {}, will retry", (Object)transferResult.getMessage());
        }
        return transferResult;
    }
}

