/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.storagegroup.CountStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.storagegroup.GetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetAllSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetAllTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.DeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.AllTemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.response.PathInfoResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.consensus.response.TemplateInfoResp;
import org.apache.iotdb.confignode.consensus.response.TemplateSetInfoResp;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupInfo;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUtil;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final double SCHEMA_REGION_PER_DATA_NODE = CONF.getSchemaRegionPerDataNode();
    private static final double DATA_REGION_PER_PROCESSOR = CONF.getDataRegionPerProcessor();
    private final IManager configManager;
    private final ClusterSchemaInfo clusterSchemaInfo;

    public ClusterSchemaManager(IManager configManager, ClusterSchemaInfo clusterSchemaInfo) {
        this.configManager = configManager;
        this.clusterSchemaInfo = clusterSchemaInfo;
    }

    public TSStatus setStorageGroup(SetStorageGroupPlan setStorageGroupPlan) {
        if (setStorageGroupPlan.getSchema().getName().length() > 64) {
            IllegalPathException illegalPathException = new IllegalPathException(setStorageGroupPlan.getSchema().getName(), "the length of database name shall not exceed 64");
            return RpcUtils.getStatus((int)illegalPathException.getErrorCode(), (String)illegalPathException.getMessage());
        }
        try {
            this.clusterSchemaInfo.checkContainsStorageGroup(setStorageGroupPlan.getSchema().getName());
        }
        catch (MetadataException metadataException) {
            TSStatus result = metadataException instanceof IllegalPathException ? new TSStatus(TSStatusCode.ILLEGAL_PATH.getStatusCode()) : new TSStatus(TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode());
            result.setMessage(metadataException.getMessage());
            return result;
        }
        TSStatus result = this.getConsensusManager().write(setStorageGroupPlan).getStatus();
        this.adjustMaxRegionGroupNum();
        return result;
    }

    public synchronized TSStatus deleteStorageGroup(DeleteStorageGroupPlan deleteStorageGroupPlan) {
        TSStatus result = this.getConsensusManager().write(deleteStorageGroupPlan).getStatus();
        if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.adjustMaxRegionGroupNum();
        }
        return result;
    }

    public DataSet countMatchedStorageGroups(CountStorageGroupPlan countStorageGroupPlan) {
        return this.getConsensusManager().read(countStorageGroupPlan).getDataset();
    }

    public DataSet getMatchedStorageGroupSchema(GetStorageGroupPlan getStorageGroupPlan) {
        return this.getConsensusManager().read(getStorageGroupPlan).getDataset();
    }

    public TShowStorageGroupResp showStorageGroup(GetStorageGroupPlan getStorageGroupPlan) {
        StorageGroupSchemaResp storageGroupSchemaResp = (StorageGroupSchemaResp)this.getMatchedStorageGroupSchema(getStorageGroupPlan);
        if (storageGroupSchemaResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return new TShowStorageGroupResp().setStatus(storageGroupSchemaResp.getStatus());
        }
        ConcurrentHashMap<String, TStorageGroupInfo> infoMap = new ConcurrentHashMap<String, TStorageGroupInfo>();
        for (TStorageGroupSchema storageGroupSchema : storageGroupSchemaResp.getSchemaMap().values()) {
            String name = storageGroupSchema.getName();
            TStorageGroupInfo storageGroupInfo = new TStorageGroupInfo();
            storageGroupInfo.setName(name);
            storageGroupInfo.setTTL(storageGroupSchema.getTTL());
            storageGroupInfo.setSchemaReplicationFactor(storageGroupSchema.getSchemaReplicationFactor());
            storageGroupInfo.setDataReplicationFactor(storageGroupSchema.getDataReplicationFactor());
            storageGroupInfo.setTimePartitionInterval(storageGroupSchema.getTimePartitionInterval());
            try {
                storageGroupInfo.setSchemaRegionNum(this.getPartitionManager().getRegionGroupCount(name, TConsensusGroupType.SchemaRegion));
                storageGroupInfo.setDataRegionNum(this.getPartitionManager().getRegionGroupCount(name, TConsensusGroupType.DataRegion));
            }
            catch (StorageGroupNotExistsException e) {
                return new TShowStorageGroupResp().setStatus(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage(e.getMessage()));
            }
            infoMap.put(name, storageGroupInfo);
        }
        return new TShowStorageGroupResp().setStorageGroupInfoMap(infoMap).setStatus(StatusUtils.OK);
    }

    public Map<String, Long> getAllTTLInfo() {
        StorageGroupSchemaResp storageGroupSchemaResp = (StorageGroupSchemaResp)this.getMatchedStorageGroupSchema(new GetStorageGroupPlan(Arrays.asList("root", "**")));
        ConcurrentHashMap<String, Long> infoMap = new ConcurrentHashMap<String, Long>();
        if (storageGroupSchemaResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return infoMap;
        }
        for (TStorageGroupSchema storageGroupSchema : storageGroupSchemaResp.getSchemaMap().values()) {
            infoMap.put(storageGroupSchema.getName(), storageGroupSchema.getTTL());
        }
        return infoMap;
    }

    public TSStatus setTTL(SetTTLPlan setTTLPlan) {
        Map<String, TStorageGroupSchema> storageSchemaMap = this.clusterSchemaInfo.getMatchedStorageGroupSchemasByOneName(setTTLPlan.getStorageGroupPathPattern());
        if (storageSchemaMap.isEmpty()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.DATABASE_NOT_EXIST, (String)("Path [" + new PartialPath(setTTLPlan.getStorageGroupPathPattern()) + "] does not exist"));
        }
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        ConcurrentHashMap<Integer, List> dnlToSgMap = new ConcurrentHashMap<Integer, List>();
        for (String storageGroup : storageSchemaMap.keySet()) {
            Set<TDataNodeLocation> dataNodeLocations = this.getPartitionManager().getStorageGroupRelatedDataNodes(storageGroup, TConsensusGroupType.DataRegion);
            for (TDataNodeLocation dataNodeLocation : dataNodeLocations) {
                dataNodeLocationMap.putIfAbsent(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                dnlToSgMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), empty -> new ArrayList()).add(storageGroup);
            }
        }
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.SET_TTL);
        dnlToSgMap.keySet().forEach(dataNodeId -> {
            TSetTTLReq setTTLReq = new TSetTTLReq((List)dnlToSgMap.get(dataNodeId), setTTLPlan.getTTL());
            clientHandler.putRequest((int)dataNodeId, setTTLReq);
            clientHandler.putDataNodeLocation((int)dataNodeId, (TDataNodeLocation)dataNodeLocationMap.get(dataNodeId));
        });
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return this.getConsensusManager().write(setTTLPlan).getStatus();
    }

    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan setSchemaReplicationFactorPlan) {
        return this.getConsensusManager().write(setSchemaReplicationFactorPlan).getStatus();
    }

    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan setDataReplicationFactorPlan) {
        return this.getConsensusManager().write(setDataReplicationFactorPlan).getStatus();
    }

    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan setTimePartitionIntervalPlan) {
        return this.getConsensusManager().write(setTimePartitionIntervalPlan).getStatus();
    }

    public synchronized void adjustMaxRegionGroupNum() {
        int leastDataRegionGroupNum;
        Map<String, TStorageGroupSchema> storageGroupSchemaMap = this.getMatchedStorageGroupSchemasByName(this.getStorageGroupNames());
        if (storageGroupSchemaMap.size() == 0) {
            return;
        }
        int dataNodeNum = this.getNodeManager().getRegisteredDataNodeCount();
        int totalCpuCoreNum = this.getNodeManager().getTotalCpuCoreCount();
        int storageGroupNum = storageGroupSchemaMap.size();
        if (!CONF.isLeastDataRegionGroupNumSetByUser() && (leastDataRegionGroupNum = (int)Math.ceil((double)totalCpuCoreNum / (double)(storageGroupNum * CONF.getDataReplicationFactor()))) < CONF.getLeastDataRegionGroupNum()) {
            CONF.setLeastDataRegionGroupNum(leastDataRegionGroupNum);
            LOGGER.info("[AdjustRegionGroupNum] The least number of DataRegionGroups per Database is adjusted to: {}", (Object)leastDataRegionGroupNum);
        }
        AdjustMaxRegionGroupNumPlan adjustMaxRegionGroupNumPlan = new AdjustMaxRegionGroupNumPlan();
        for (TStorageGroupSchema storageGroupSchema : storageGroupSchemaMap.values()) {
            try {
                int allocatedSchemaRegionGroupCount = this.getPartitionManager().getRegionGroupCount(storageGroupSchema.getName(), TConsensusGroupType.SchemaRegion);
                int maxSchemaRegionGroupNum = ClusterSchemaManager.calcMaxRegionGroupNum(CONF.getLeastSchemaRegionGroupNum(), SCHEMA_REGION_PER_DATA_NODE, dataNodeNum, storageGroupNum, storageGroupSchema.getSchemaReplicationFactor(), allocatedSchemaRegionGroupCount);
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of SchemaRegionGroups for Database: {} is adjusted to: {}", (Object)storageGroupSchema.getName(), (Object)maxSchemaRegionGroupNum);
                int allocatedDataRegionGroupCount = this.getPartitionManager().getRegionGroupCount(storageGroupSchema.getName(), TConsensusGroupType.DataRegion);
                int maxDataRegionGroupNum = ClusterSchemaManager.calcMaxRegionGroupNum(CONF.getLeastDataRegionGroupNum(), DATA_REGION_PER_PROCESSOR, totalCpuCoreNum, storageGroupNum, storageGroupSchema.getDataReplicationFactor(), allocatedDataRegionGroupCount);
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of DataRegionGroups for Database: {} is adjusted to: {}", (Object)storageGroupSchema.getName(), (Object)maxDataRegionGroupNum);
                adjustMaxRegionGroupNumPlan.putEntry(storageGroupSchema.getName(), (Pair<Integer, Integer>)new Pair((Object)maxSchemaRegionGroupNum, (Object)maxDataRegionGroupNum));
            }
            catch (StorageGroupNotExistsException e) {
                LOGGER.warn("Adjust maxRegionGroupNum failed because StorageGroup doesn't exist", (Throwable)e);
            }
        }
        this.getConsensusManager().write(adjustMaxRegionGroupNumPlan);
    }

    public static int calcMaxRegionGroupNum(int leastRegionGroupNum, double resourceWeight, int resource, int storageGroupNum, int replicationFactor, int allocatedRegionGroupCount) {
        return Math.max(leastRegionGroupNum, Math.max((int)Math.ceil(resourceWeight * (double)resource / (double)(storageGroupNum * replicationFactor)), allocatedRegionGroupCount));
    }

    public TStorageGroupSchema getStorageGroupSchemaByName(String storageGroup) throws StorageGroupNotExistsException {
        return this.clusterSchemaInfo.getMatchedStorageGroupSchemaByName(storageGroup);
    }

    public int getReplicationFactor(String storageGroup, TConsensusGroupType consensusGroupType) throws StorageGroupNotExistsException {
        TStorageGroupSchema storageGroupSchema = this.getStorageGroupSchemaByName(storageGroup);
        return consensusGroupType == TConsensusGroupType.SchemaRegion ? storageGroupSchema.getSchemaReplicationFactor() : storageGroupSchema.getDataReplicationFactor();
    }

    public Map<String, TStorageGroupSchema> getMatchedStorageGroupSchemasByName(List<String> rawPathList) {
        return this.clusterSchemaInfo.getMatchedStorageGroupSchemasByName(rawPathList);
    }

    public List<String> getStorageGroupNames() {
        return this.clusterSchemaInfo.getStorageGroupNames();
    }

    public int getMaxRegionGroupNum(String storageGroup, TConsensusGroupType consensusGroupType) {
        return this.clusterSchemaInfo.getMaxRegionGroupNum(storageGroup, consensusGroupType);
    }

    public TSStatus createTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan) {
        return this.getConsensusManager().write(createSchemaTemplatePlan).getStatus();
    }

    public TGetAllTemplatesResp getAllTemplates() {
        GetAllSchemaTemplatePlan getAllSchemaTemplatePlan = new GetAllSchemaTemplatePlan();
        TemplateInfoResp templateResp = (TemplateInfoResp)this.getConsensusManager().read(getAllSchemaTemplatePlan).getDataset();
        TGetAllTemplatesResp resp = new TGetAllTemplatesResp();
        resp.setStatus(templateResp.getStatus());
        if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && templateResp.getTemplateList() != null) {
            ArrayList list = new ArrayList();
            templateResp.getTemplateList().forEach(template -> list.add(template.serialize()));
            resp.setTemplateList(list);
        }
        return resp;
    }

    public TGetTemplateResp getTemplate(String req) {
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(req);
        TemplateInfoResp templateResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan).getDataset();
        TGetTemplateResp resp = new TGetTemplateResp();
        if (templateResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && templateResp.getTemplateList() != null && !templateResp.getTemplateList().isEmpty()) {
            ByteBuffer byteBuffer = templateResp.getTemplateList().get(0).serialize();
            resp.setTemplate(byteBuffer);
        }
        resp.setStatus(templateResp.getStatus());
        return resp;
    }

    public synchronized TSStatus setSchemaTemplate(String templateName, String path) {
        TSStatus status;
        CheckTemplateSettablePlan checkTemplateSettablePlan = new CheckTemplateSettablePlan(templateName, path);
        TemplateInfoResp resp = (TemplateInfoResp)this.getConsensusManager().read(checkTemplateSettablePlan).getDataset();
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.getStatus();
        }
        Template template = resp.getTemplateList().get(0);
        TUpdateTemplateReq req = new TUpdateTemplateReq();
        req.setType(TemplateInternalRPCUpdateType.ADD_TEMPLATE_SET_INFO.toByte());
        req.setTemplateInfo(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes((Template)template, (String)path));
        List<TDataNodeConfiguration> allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes();
        for (TDataNodeConfiguration dataNodeInfo : allDataNodes) {
            status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeInfo.getLocation().getInternalEndPoint(), req, DataNodeRequestType.UPDATE_TEMPLATE);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return status.setSubStatus(this.rollbackTemplateSetInfoSync(template.getId(), path));
        }
        SetSchemaTemplatePlan setSchemaTemplatePlan = new SetSchemaTemplatePlan(templateName, path);
        status = this.getConsensusManager().write(setSchemaTemplatePlan).getStatus();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return status.setSubStatus(this.rollbackTemplateSetInfoSync(template.getId(), path));
    }

    private List<TSStatus> rollbackTemplateSetInfoSync(int templateId, String path) {
        TUpdateTemplateReq rollbackReq = new TUpdateTemplateReq();
        rollbackReq.setType(TemplateInternalRPCUpdateType.INVALIDATE_TEMPLATE_SET_INFO.toByte());
        rollbackReq.setTemplateInfo(TemplateInternalRPCUtil.generateInvalidateTemplateSetInfoBytes((int)templateId, (String)path));
        List<TDataNodeConfiguration> allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes();
        ArrayList<TSStatus> failedRollbackStatusList = new ArrayList<TSStatus>();
        for (TDataNodeConfiguration dataNodeInfo : allDataNodes) {
            TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeInfo.getLocation().getInternalEndPoint(), rollbackReq, DataNodeRequestType.UPDATE_TEMPLATE);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            failedRollbackStatusList.add(status);
        }
        return failedRollbackStatusList;
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(String templateName) {
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName);
        PathInfoResp pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan).getDataset();
        if (pathInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            TGetPathsSetTemplatesResp resp = new TGetPathsSetTemplatesResp();
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            resp.setPathList(pathInfoResp.getPathList());
            return resp;
        }
        return new TGetPathsSetTemplatesResp(pathInfoResp.getStatus());
    }

    public byte[] getAllTemplateSetInfo() {
        AllTemplateSetInfoResp resp = (AllTemplateSetInfoResp)this.getConsensusManager().read(new GetAllTemplateSetInfoPlan()).getDataset();
        return resp.getTemplateInfo();
    }

    public TemplateSetInfoResp getTemplateSetInfo(List<PartialPath> patternList) {
        return (TemplateSetInfoResp)this.getConsensusManager().read(new GetTemplateSetInfoPlan(patternList)).getDataset();
    }

    public Pair<TSStatus, Template> checkIsTemplateSetOnPath(String templateName, String path) {
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(templateName);
        TemplateInfoResp templateResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan).getDataset();
        if (templateResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (templateResp.getTemplateList() == null || templateResp.getTemplateList().isEmpty()) {
                return new Pair((Object)RpcUtils.getStatus((int)TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode(), (String)String.format("Undefined template name: %s", templateName)), null);
            }
        } else {
            return new Pair((Object)templateResp.getStatus(), null);
        }
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName);
        PathInfoResp pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan).getDataset();
        if (pathInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List<String> templateSetPathList = pathInfoResp.getPathList();
            if (templateSetPathList == null || templateSetPathList.isEmpty() || !pathInfoResp.getPathList().contains(path)) {
                return new Pair((Object)RpcUtils.getStatus((int)TSStatusCode.TEMPLATE_NOT_SET.getStatusCode(), (String)String.format("No template on %s", path)), null);
            }
            return new Pair((Object)templateResp.getStatus(), (Object)templateResp.getTemplateList().get(0));
        }
        return new Pair((Object)pathInfoResp.getStatus(), null);
    }

    public TSStatus preUnsetSchemaTemplate(int templateId, PartialPath path) {
        return this.getConsensusManager().write(new PreUnsetSchemaTemplatePlan(templateId, path)).getStatus();
    }

    public TSStatus rollbackPreUnsetSchemaTemplate(int templateId, PartialPath path) {
        return this.getConsensusManager().write(new RollbackPreUnsetSchemaTemplatePlan(templateId, path)).getStatus();
    }

    public TSStatus unsetSchemaTemplateInBlackList(int templateId, PartialPath path) {
        return this.getConsensusManager().write(new UnsetSchemaTemplatePlan(templateId, path)).getStatus();
    }

    public synchronized TSStatus dropSchemaTemplate(String templateName) {
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(templateName);
        TemplateInfoResp templateInfoResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan).getDataset();
        if (templateInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return templateInfoResp.getStatus();
        }
        if (templateInfoResp.getTemplateList() == null || templateInfoResp.getTemplateList().isEmpty()) {
            return RpcUtils.getStatus((int)TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode(), (String)String.format("Undefined template name: %s", templateName));
        }
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName);
        PathInfoResp pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan).getDataset();
        if (pathInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return pathInfoResp.getStatus();
        }
        if (pathInfoResp.getPathList() != null && !pathInfoResp.getPathList().isEmpty()) {
            return RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), (String)String.format("Template [%s] has been set on MTree, cannot be dropped now.", templateName));
        }
        return this.getConsensusManager().write(new DropSchemaTemplatePlan(templateName)).getStatus();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }
}

