/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class RecordPipeMessagePlan
extends ConfigPhysicalPlan {
    private String pipeName;
    private PipeMessage pipeMessage;

    public RecordPipeMessagePlan() {
        super(ConfigPhysicalPlanType.RecordPipeMessage);
    }

    public RecordPipeMessagePlan(String pipeName, PipeMessage pipeMessage) {
        this();
        this.pipeName = pipeName;
        this.pipeMessage = pipeMessage;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public PipeMessage getPipeMessage() {
        return this.pipeMessage;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write((String)this.pipeName, (DataOutputStream)stream);
        this.pipeMessage.serialize(stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.pipeName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.pipeMessage = PipeMessage.deserialize((ByteBuffer)buffer);
    }
}

