/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.storagegroup;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;

public class SetStorageGroupPlan
extends ConfigPhysicalPlan {
    private TStorageGroupSchema schema = new TStorageGroupSchema();

    public SetStorageGroupPlan() {
        super(ConfigPhysicalPlanType.SetStorageGroup);
    }

    public SetStorageGroupPlan(TStorageGroupSchema schema) {
        this();
        this.schema = schema;
    }

    public TStorageGroupSchema getSchema() {
        return this.schema;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftConfigNodeSerDeUtils.serializeTStorageGroupSchema((TStorageGroupSchema)this.schema, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.schema = ThriftConfigNodeSerDeUtils.deserializeTStorageGroupSchema((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetStorageGroupPlan that = (SetStorageGroupPlan)o;
        return this.schema.equals(that.schema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema);
    }
}

