/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.storagegroup;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AdjustMaxRegionGroupNumPlan
extends ConfigPhysicalPlan {
    public final Map<String, Pair<Integer, Integer>> maxRegionGroupNumMap = new HashMap<String, Pair<Integer, Integer>>();

    public AdjustMaxRegionGroupNumPlan() {
        super(ConfigPhysicalPlanType.AdjustMaxRegionGroupNum);
    }

    public void putEntry(String storageGroup, Pair<Integer, Integer> maxRegionGroupNum) {
        this.maxRegionGroupNumMap.put(storageGroup, maxRegionGroupNum);
    }

    public Map<String, Pair<Integer, Integer>> getMaxRegionGroupNumMap() {
        return this.maxRegionGroupNumMap;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.getType().getPlanType(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.maxRegionGroupNumMap.size(), (OutputStream)stream);
        for (Map.Entry<String, Pair<Integer, Integer>> maxRegionGroupNumEntry : this.maxRegionGroupNumMap.entrySet()) {
            ReadWriteIOUtils.write((String)maxRegionGroupNumEntry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)maxRegionGroupNumEntry.getValue().getLeft()), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)maxRegionGroupNumEntry.getValue().getRight()), (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            int maxSchemaRegionGroupNum = buffer.getInt();
            int maxDataRegionGroupNum = buffer.getInt();
            this.maxRegionGroupNumMap.put(storageGroup, (Pair<Integer, Integer>)new Pair((Object)maxSchemaRegionGroupNum, (Object)maxDataRegionGroupNum));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjustMaxRegionGroupNumPlan that = (AdjustMaxRegionGroupNumPlan)o;
        return this.maxRegionGroupNumMap.equals(that.maxRegionGroupNumMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxRegionGroupNumMap);
    }
}

