/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.pool;

import java.util.List;
import org.apache.iotdb.isession.IDataIterator;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.ISessionDataSet;
import org.apache.iotdb.isession.pool.ISessionDataSetWrapper;
import org.apache.iotdb.isession.pool.ISessionPool;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class SessionDataSetWrapper
implements ISessionDataSetWrapper {
    ISessionDataSet sessionDataSet;
    ISession session;
    ISessionPool pool;

    public SessionDataSetWrapper(ISessionDataSet sessionDataSet, ISession session, ISessionPool pool) {
        this.sessionDataSet = sessionDataSet;
        this.session = session;
        this.pool = pool;
    }

    public ISession getSession() {
        return this.session;
    }

    public int getBatchSize() {
        return this.sessionDataSet.getFetchSize();
    }

    public void setBatchSize(int batchSize) {
        this.sessionDataSet.setFetchSize(batchSize);
    }

    public boolean hasNext() throws IoTDBConnectionException, StatementExecutionException {
        boolean next = this.sessionDataSet.hasNext();
        if (!next) {
            this.pool.closeResultSet((ISessionDataSetWrapper)this);
        }
        return next;
    }

    public RowRecord next() throws IoTDBConnectionException, StatementExecutionException {
        return this.sessionDataSet.next();
    }

    public IDataIterator iterator() {
        return this.sessionDataSet.iterator();
    }

    public List<String> getColumnNames() {
        return this.sessionDataSet.getColumnNames();
    }

    public List<String> getColumnTypes() {
        return this.sessionDataSet.getColumnTypes();
    }

    public void close() {
        this.pool.closeResultSet((ISessionDataSetWrapper)this);
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public ISessionDataSet getSessionDataSet() {
        return this.sessionDataSet;
    }

    public void setSessionDataSet(ISessionDataSet sessionDataSet) {
        this.sessionDataSet = sessionDataSet;
    }
}

