/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.exception.sync.PipeAlreadyExistException;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeNotExistException;
import org.apache.iotdb.commons.exception.sync.PipeSinkAlreadyExistException;
import org.apache.iotdb.commons.exception.sync.PipeSinkBeingUsedException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.exception.sync.PipeSinkNotExistException;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.sync.persistence.SyncLogReader;
import org.apache.iotdb.commons.sync.persistence.SyncLogWriter;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMetadata
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncMetadata.class);
    private Map<String, PipeSink> pipeSinks;
    private Map<String, PipeInfo> pipes = new ConcurrentHashMap<String, PipeInfo>();

    public SyncMetadata() {
        this.pipeSinks = new ConcurrentHashMap<String, PipeSink>();
    }

    public Map<String, PipeSink> getPipeSinks() {
        return this.pipeSinks;
    }

    public void setPipeSinks(Map<String, PipeSink> pipeSinks) {
        this.pipeSinks = pipeSinks;
    }

    public Map<String, PipeInfo> getPipes() {
        return this.pipes;
    }

    public void setPipes(Map<String, PipeInfo> pipes) {
        this.pipes = pipes;
    }

    public boolean isPipeSinkExist(String name) {
        return this.pipeSinks.containsKey(name);
    }

    public void checkPipeSinkNoExist(String pipeSinkName) throws PipeSinkException {
        if (this.isPipeSinkExist(pipeSinkName)) {
            throw new PipeSinkAlreadyExistException(pipeSinkName);
        }
    }

    public void addPipeSink(PipeSink pipeSink) {
        this.pipeSinks.put(pipeSink.getPipeSinkName(), pipeSink);
    }

    public void checkDropPipeSink(String pipeSinkName) throws PipeSinkException {
        if (!this.isPipeSinkExist(pipeSinkName)) {
            throw new PipeSinkNotExistException(pipeSinkName);
        }
        for (PipeInfo pipeInfo : this.pipes.values()) {
            if (!pipeInfo.getPipeSinkName().equals(pipeSinkName)) continue;
            throw new PipeSinkBeingUsedException(pipeSinkName, pipeInfo.getPipeName());
        }
    }

    public void dropPipeSink(String name) {
        this.pipeSinks.remove(name);
    }

    public PipeSink getPipeSink(String name) {
        return this.pipeSinks.getOrDefault(name, null);
    }

    public List<PipeSink> getAllPipeSink() {
        ArrayList<PipeSink> allPipeSinks = new ArrayList<PipeSink>();
        for (Map.Entry<String, PipeSink> entry : this.pipeSinks.entrySet()) {
            allPipeSinks.add(entry.getValue());
        }
        return allPipeSinks;
    }

    public void checkAddPipe(PipeInfo pipeInfo) throws PipeException, PipeSinkNotExistException {
        if (!this.isPipeSinkExist(pipeInfo.getPipeSinkName())) {
            throw new PipeSinkNotExistException(pipeInfo.getPipeSinkName());
        }
        if (this.pipes.containsKey(pipeInfo.getPipeName())) {
            PipeInfo runningPipe = this.pipes.get(pipeInfo.getPipeName());
            throw new PipeAlreadyExistException(runningPipe.getPipeName(), runningPipe.getStatus());
        }
    }

    public void addPipe(PipeInfo pipeInfo) {
        this.pipes.putIfAbsent(pipeInfo.getPipeName(), pipeInfo);
    }

    public void dropPipe(String pipeName) {
        this.pipes.remove(pipeName);
    }

    public void setPipeStatus(String pipeName, PipeStatus status) {
        this.pipes.get(pipeName).setStatus(status);
        if (status.equals((Object)PipeStatus.RUNNING)) {
            this.pipes.get(pipeName).setMessageType(PipeMessage.PipeMessageType.NORMAL);
        }
    }

    public PipeInfo getPipeInfo(String pipeName) {
        return this.pipes.get(pipeName);
    }

    public List<PipeInfo> getAllPipeInfos() {
        return new ArrayList<PipeInfo>(this.pipes.values());
    }

    public void checkIfPipeExist(String pipeName) throws PipeException {
        if (!this.pipes.containsKey(pipeName)) {
            throw new PipeNotExistException(pipeName);
        }
    }

    public void changePipeMessage(String pipeName, PipeMessage.PipeMessageType messageType) {
        if (messageType.compareTo(this.pipes.get(pipeName).getMessageType()) > 0) {
            this.pipes.get(pipeName).setMessageType(messageType);
        }
    }

    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, "syncService.log");
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        try (SyncLogWriter writer = new SyncLogWriter(snapshotDir, tmpFile.getName());){
            writer.initOutputStream();
            for (PipeSink pipeSink : this.pipeSinks.values()) {
                writer.addPipeSink(pipeSink);
            }
            for (PipeInfo pipeInfo : this.pipes.values()) {
                writer.addPipe(pipeInfo);
                switch (pipeInfo.getStatus()) {
                    case RUNNING: {
                        writer.operatePipe(pipeInfo.getPipeName(), SyncOperation.START_PIPE);
                        break;
                    }
                    case STOP: {
                        writer.operatePipe(pipeInfo.getPipeName(), SyncOperation.STOP_PIPE);
                    }
                }
            }
        }
        return tmpFile.renameTo(snapshotFile);
    }

    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, "syncService.log");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        SyncLogReader reader = new SyncLogReader(snapshotDir, snapshotFile.getName());
        reader.recover();
        this.setPipes(reader.getPipes());
        this.setPipeSinks(reader.getAllPipeSinks());
    }
}

