/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.tree;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.tree.AbstractTreeVisitor;
import org.apache.iotdb.commons.schema.tree.ITreeNode;

public abstract class AbstractTreeVisitorWithLimitOffset<N extends ITreeNode, R>
extends AbstractTreeVisitor<N, R> {
    protected final int limit;
    protected final int offset;
    protected final boolean hasLimit;
    protected int count = 0;
    protected int curOffset = -1;

    protected AbstractTreeVisitorWithLimitOffset(N root, PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch) {
        super(root, pathPattern, isPrefixMatch);
        this.limit = limit;
        this.offset = offset;
        this.hasLimit = limit != 0;
    }

    @Override
    public boolean hasNext() {
        if (this.hasLimit) {
            return this.count < this.limit && super.hasNext();
        }
        return super.hasNext();
    }

    @Override
    protected void getNext() {
        if (this.hasLimit) {
            if (this.curOffset < this.offset) {
                while (this.curOffset < this.offset) {
                    super.getNext();
                    ++this.curOffset;
                    if (this.nextMatchedNode != null) continue;
                    return;
                }
            } else {
                super.getNext();
                ++this.curOffset;
            }
        } else {
            super.getNext();
        }
    }

    @Override
    public R next() {
        Object result = super.next();
        if (this.hasLimit) {
            ++this.count;
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.count = 0;
        this.curOffset = -1;
    }

    public int getNextOffset() {
        return this.curOffset + 1;
    }
}

