/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.sync.sender.manager.ISyncManager;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;

public class LocalSyncManager
implements ISyncManager {
    private TsFilePipe syncPipe;
    private final DataRegion dataRegion;
    private final String dataRegionId;

    public LocalSyncManager(DataRegion dataRegion, Pipe pipe) {
        this.dataRegion = dataRegion;
        this.dataRegionId = dataRegion.getDataRegionId();
        this.syncPipe = (TsFilePipe)pipe;
    }

    @Override
    public void syncRealTimeDeletion(Deletion deletion) {
        this.syncPipe.collectRealTimeDeletion(deletion, this.dataRegion.getDatabaseName(), this.dataRegionId);
    }

    @Override
    public void syncRealTimeTsFile(File tsFile) {
        this.syncPipe.collectRealTimeTsFile(tsFile, this.dataRegionId);
    }

    @Override
    public void syncRealTimeResource(File tsFile) {
        this.syncPipe.collectRealTimeResource(tsFile);
    }

    @Override
    public List<File> syncHistoryTsFile(long dataStartTime) {
        return new ArrayList<File>(this.dataRegion.collectHistoryTsFileForSync(this, dataStartTime));
    }

    @Override
    public File createHardlink(File tsFile, long modsOffset) {
        return this.syncPipe.createHistoryTsFileHardlink(tsFile, modsOffset);
    }

    @Override
    public void delete() {
    }

    public static List<PartialPath> splitPathPatternByDevice(PartialPath pathPattern) throws MetadataException {
        Set<PartialPath> devices = LocalSchemaProcessor.getInstance().getBelongedDevices(pathPattern);
        LinkedList<PartialPath> resultPathPattern = new LinkedList<PartialPath>();
        for (PartialPath device : devices) {
            pathPattern.alterPrefixPath(device).stream().filter(i -> !i.equals((Object)device)).forEach(resultPathPattern::add);
        }
        return resultPathPattern;
    }
}

