/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import org.apache.iotdb.db.mpp.plan.constant.DataNodeEndPoints;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.DevicesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.DevicesSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.LevelTimeSeriesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodeManagementMemoryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsConvertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryOrderByHeatNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.TimeSeriesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.TimeSeriesSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.ConstructSchemaBlackListNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.RollbackSchemaBlackListNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewIntoNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FillNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.IntoNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProjectNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.VerticallyConcatNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryCollectNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;

public class MemoryDistributionCalculator
extends PlanVisitor<Void, MemoryDistributionContext> {
    private int exchangeNum;

    public int calculateTotalSplit() {
        return this.exchangeNum;
    }

    @Override
    public Void visitPlan(PlanNode node, MemoryDistributionContext context) {
        throw new UnsupportedOperationException("Should call concrete visitXX method");
    }

    private void processConsumeChildrenOneByOneNode(PlanNode node) {
        MemoryDistributionContext context = new MemoryDistributionContext(node.getPlanNodeId(), MemoryDistributionType.CONSUME_CHILDREN_ONE_BY_ONE);
        node.getChildren().forEach(child -> {
            if (child != null) {
                child.accept(this, context);
            }
        });
    }

    private void processConsumeAllChildrenAtTheSameTime(PlanNode node) {
        MemoryDistributionContext context = new MemoryDistributionContext(node.getPlanNodeId(), MemoryDistributionType.CONSUME_ALL_CHILDREN_AT_THE_SAME_TIME);
        node.getChildren().forEach(child -> {
            if (child != null) {
                child.accept(this, context);
            }
        });
    }

    @Override
    public Void visitExchange(ExchangeNode node, MemoryDistributionContext context) {
        if (context == null || context.memoryDistributionType.equals((Object)MemoryDistributionType.CONSUME_ALL_CHILDREN_AT_THE_SAME_TIME)) {
            ++this.exchangeNum;
        } else if (!context.exchangeAdded) {
            context.exchangeAdded = true;
            ++this.exchangeNum;
        }
        return null;
    }

    @Override
    public Void visitFragmentSink(FragmentSinkNode node, MemoryDistributionContext context) {
        if (!DataNodeEndPoints.isSameNode(node.getDownStreamEndpoint())) {
            ++this.exchangeNum;
        }
        node.getChild().accept(this, context);
        return null;
    }

    @Override
    public Void visitSeriesScan(SeriesScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitSeriesAggregationScan(SeriesAggregationScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitAlignedSeriesScan(AlignedSeriesScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitDeviceView(DeviceViewNode node, MemoryDistributionContext context) {
        this.processConsumeChildrenOneByOneNode(node);
        return null;
    }

    @Override
    public Void visitDeviceMerge(DeviceMergeNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitFill(FillNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitFilter(FilterNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitGroupByLevel(GroupByLevelNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitGroupByTag(GroupByTagNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitSlidingWindowAggregation(SlidingWindowAggregationNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitLimit(LimitNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitOffset(OffsetNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitAggregation(AggregationNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitSort(SortNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitProject(ProjectNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitTimeJoin(TimeJoinNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitTransform(TransformNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitLastQueryScan(LastQueryScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitAlignedLastQueryScan(AlignedLastQueryScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitLastQuery(LastQueryNode node, MemoryDistributionContext context) {
        this.processConsumeChildrenOneByOneNode(node);
        return null;
    }

    @Override
    public Void visitLastQueryMerge(LastQueryMergeNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitLastQueryCollect(LastQueryCollectNode node, MemoryDistributionContext context) {
        this.processConsumeChildrenOneByOneNode(node);
        return null;
    }

    @Override
    public Void visitInto(IntoNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitDeviceViewInto(DeviceViewIntoNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitSchemaQueryMerge(SchemaQueryMergeNode node, MemoryDistributionContext context) {
        this.processConsumeChildrenOneByOneNode(node);
        return null;
    }

    @Override
    public Void visitSchemaQueryScan(SchemaQueryScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitSchemaQueryOrderByHeat(SchemaQueryOrderByHeatNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitTimeSeriesSchemaScan(TimeSeriesSchemaScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitDevicesSchemaScan(DevicesSchemaScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitDevicesCount(DevicesCountNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitTimeSeriesCount(TimeSeriesCountNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitLevelTimeSeriesCount(LevelTimeSeriesCountNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitCountMerge(CountSchemaMergeNode node, MemoryDistributionContext context) {
        this.processConsumeChildrenOneByOneNode(node);
        return null;
    }

    @Override
    public Void visitSchemaFetchMerge(SchemaFetchMergeNode node, MemoryDistributionContext context) {
        this.processConsumeChildrenOneByOneNode(node);
        return null;
    }

    @Override
    public Void visitSchemaFetchScan(SchemaFetchScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitNodePathsSchemaScan(NodePathsSchemaScanNode node, MemoryDistributionContext context) {
        return null;
    }

    @Override
    public Void visitNodeManagementMemoryMerge(NodeManagementMemoryMergeNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitNodePathConvert(NodePathsConvertNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitNodePathsCount(NodePathsCountNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitConstructSchemaBlackList(ConstructSchemaBlackListNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitRollbackSchemaBlackList(RollbackSchemaBlackListNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    @Override
    public Void visitVerticallyConcat(VerticallyConcatNode node, MemoryDistributionContext context) {
        this.processConsumeAllChildrenAtTheSameTime(node);
        return null;
    }

    static class MemoryDistributionContext {
        final PlanNodeId planNodeId;
        boolean exchangeAdded = false;
        final MemoryDistributionType memoryDistributionType;

        MemoryDistributionContext(PlanNodeId planNodeId, MemoryDistributionType memoryDistributionType) {
            this.planNodeId = planNodeId;
            this.memoryDistributionType = memoryDistributionType;
        }
    }

    static enum MemoryDistributionType {
        CONSUME_ALL_CHILDREN_AT_THE_SAME_TIME(0),
        CONSUME_CHILDREN_ONE_BY_ONE(1);

        private final int id;

        private MemoryDistributionType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

