/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;

public class NodePathsCountOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Operator child;
    private boolean isFinished;
    private final Set<String> nodePaths;
    private final List<TSDataType> outputDataTypes;

    public NodePathsCountOperator(OperatorContext operatorContext, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.isFinished = false;
        this.nodePaths = new HashSet<String>();
        this.outputDataTypes = ColumnHeaderConstant.countNodesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        while (!this.child.isFinished()) {
            TsBlock tsBlock;
            ListenableFuture<?> blocked = this.child.isBlocked();
            if (!blocked.isDone()) {
                return null;
            }
            if (!this.child.hasNext() || null == (tsBlock = this.child.next()) || tsBlock.isEmpty()) continue;
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                String path = tsBlock.getColumn(0).getBinary(i).toString();
                this.nodePaths.add(path);
            }
        }
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(this.outputDataTypes);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong((long)this.nodePaths.size());
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return !this.child.isFinished() || !this.isFinished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(2L * (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.child.calculateMaxPeekMemory());
    }

    @Override
    public long calculateMaxReturnSize() {
        return Math.max((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.child.calculateMaxReturnSize());
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + this.child.calculateRetainedSizeAfterCallingNext();
    }
}

