/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.cross.ICrossSpaceSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.CrossCompactionTaskResource;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.ICompactionSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public static void scheduleCompaction(TsFileManager tsFileManager, long timePartition) {
        if (!tsFileManager.isAllowCompaction()) {
            return;
        }
        try {
            CompactionScheduler.tryToSubmitCrossSpaceCompactionTask(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager);
            CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, true);
            CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, false);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception occurs when selecting compaction tasks", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void tryToSubmitInnerSpaceCompactionTask(String storageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager, boolean sequence) throws InterruptedException {
        if (!config.isEnableSeqSpaceCompaction() && sequence || !config.isEnableUnseqSpaceCompaction() && !sequence) {
            return;
        }
        ICompactionSelector innerSpaceCompactionSelector = null;
        innerSpaceCompactionSelector = sequence ? config.getInnerSequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager) : config.getInnerUnsequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager);
        List<List<TsFileResource>> taskList = innerSpaceCompactionSelector.selectInnerSpaceTask(sequence ? tsFileManager.getSequenceListByTimePartition(timePartition) : tsFileManager.getUnsequenceListByTimePartition(timePartition));
        for (List<TsFileResource> task : taskList) {
            ICompactionPerformer performer = sequence ? IoTDBDescriptor.getInstance().getConfig().getInnerSeqCompactionPerformer().createInstance() : IoTDBDescriptor.getInstance().getConfig().getInnerUnseqCompactionPerformer().createInstance();
            CompactionTaskManager.getInstance().addTaskToWaitingQueue(new InnerSpaceCompactionTask(timePartition, tsFileManager, task, sequence, performer, CompactionTaskManager.currentTaskNum, tsFileManager.getNextCompactionTaskId()));
        }
    }

    private static void tryToSubmitCrossSpaceCompactionTask(String logicalStorageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager) throws InterruptedException {
        if (!config.isEnableCrossSpaceCompaction()) {
            return;
        }
        ICrossSpaceSelector crossSpaceCompactionSelector = config.getCrossCompactionSelector().createInstance(logicalStorageGroupName, dataRegionId, timePartition, tsFileManager);
        List<CrossCompactionTaskResource> taskList = crossSpaceCompactionSelector.selectCrossSpaceTask(tsFileManager.getSequenceListByTimePartition(timePartition), tsFileManager.getUnsequenceListByTimePartition(timePartition));
        List<Long> memoryCost = crossSpaceCompactionSelector.getCompactionMemoryCost();
        int size = taskList.size();
        for (int i = 0; i < size; ++i) {
            CompactionTaskManager.getInstance().addTaskToWaitingQueue(new CrossSpaceCompactionTask(timePartition, tsFileManager, taskList.get(i).getSeqFiles(), taskList.get(i).getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), CompactionTaskManager.currentTaskNum, memoryCost.get(i), tsFileManager.getNextCompactionTaskId()));
        }
    }
}

