/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.client;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.exception.IntoProcessException;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandalonePartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.db.query.control.clientsession.InternalClientSession;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeInternalClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeInternalClient.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher PARTITION_FETCHER;
    private final ISchemaFetcher SCHEMA_FETCHER;
    private final IClientSession session;

    public DataNodeInternalClient(SessionInfo sessionInfo) {
        if (config.isClusterMode()) {
            this.PARTITION_FETCHER = ClusterPartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = ClusterSchemaFetcher.getInstance();
        } else {
            this.PARTITION_FETCHER = StandalonePartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = StandaloneSchemaFetcher.getInstance();
        }
        try {
            this.session = new InternalClientSession("SELECT_INTO");
            SESSION_MANAGER.supplySession(this.session, sessionInfo.getUserName(), sessionInfo.getZoneId(), IoTDBConstant.ClientVersion.V_0_13);
            LOGGER.info("User: {}, opens internal Session-{}.", (Object)sessionInfo.getUserName(), (Object)this.session);
        }
        catch (Exception e) {
            LOGGER.warn("User {} opens internal Session failed.", (Object)sessionInfo.getUserName(), (Object)e);
            throw new IntoProcessException(String.format("User %s opens internal Session failed.", sessionInfo.getUserName()));
        }
    }

    public TSStatus insertTablets(InsertMultiTabletsStatement statement) {
        try {
            TSStatus status = AuthorityChecker.checkAuthority(statement, this.session);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(this.session), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLETS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public void close() {
        SESSION_MANAGER.closeSession(this.session, COORDINATOR::cleanupQueryExecution);
    }
}

