/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.mpp.rpc.thrift.TOperatePipeOnDataNodeReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatePipeProcedureRollbackProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatePipeProcedureRollbackProcessor.class);
    private static final int TIME_INTERVAL = 5000;
    private final NodeManager nodeManager;
    private final Map<Integer, Queue<TOperatePipeOnDataNodeReq>> messageMap = new ConcurrentHashMap<Integer, Queue<TOperatePipeOnDataNodeReq>>();
    private volatile ScheduledFuture<?> promise;
    private ScheduledFuture<?> canceller;
    private final ScheduledExecutorService executorService = IoTDBThreadPoolFactory.newScheduledThreadPool((int)2, (String)"OperatePipeProcedureRollback");

    public OperatePipeProcedureRollbackProcessor(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void retryRollbackReq(List<Integer> dataNodeIds, TOperatePipeOnDataNodeReq req) {
        for (int id : dataNodeIds) {
            this.messageMap.computeIfAbsent(id, i -> new LinkedList()).add(req);
        }
        if (this.canceller != null && !this.canceller.isDone()) {
            this.canceller.cancel(true);
        }
        if (this.promise == null || this.promise.isDone()) {
            this.promise = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.executorService, this::rollback, (long)5000L, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.canceller = this.executorService.schedule(() -> {
            LOGGER.info("Cancel rollback retry thread.");
            this.promise.cancel(false);
        }, 20000L, TimeUnit.MILLISECONDS);
    }

    private void rollback() {
        LOGGER.info("Scheduled OperatePipeProcedureRollbackProcessor.");
        block0: for (Map.Entry<Integer, Queue<TOperatePipeOnDataNodeReq>> entry : this.messageMap.entrySet()) {
            TOperatePipeOnDataNodeReq request;
            int dataNodeId = entry.getKey();
            if (!NodeStatus.Running.equals((Object)this.nodeManager.getNodeStatusByNodeId(dataNodeId))) continue;
            HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
            dataNodeLocationMap.put(dataNodeId, this.nodeManager.getRegisteredDataNodeLocations().get(dataNodeId));
            while ((request = entry.getValue().peek()) != null) {
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.ROLLBACK_OPERATE_PIPE, request, dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                TSStatus tsStatus = (TSStatus)clientHandler.getResponseList().get(0);
                if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    entry.getValue().poll();
                    continue;
                }
                if (tsStatus.getCode() == TSStatusCode.PIPE_ERROR.getStatusCode()) {
                    LOGGER.warn(String.format("Roll back failed because %s. Skip this roll back request [%s].", tsStatus.getMessage(), request));
                    continue;
                }
                LOGGER.error(String.format("Roll back failed because %s. This roll back request [%s] will be retried later.", tsStatus.getMessage(), request));
                continue block0;
            }
        }
    }
}

