/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node.heartbeat;

import java.util.LinkedList;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeStatistics;

public abstract class BaseNodeCache {
    public static final int HEARTBEAT_TIMEOUT_TIME = 20000;
    public static final int MAXIMUM_WINDOW_SIZE = 100;
    protected final LinkedList<NodeHeartbeatSample> slidingWindow = new LinkedList();
    protected volatile NodeStatistics previousStatistics = NodeStatistics.generateDefaultNodeStatistics();
    protected volatile NodeStatistics currentStatistics = NodeStatistics.generateDefaultNodeStatistics();

    protected BaseNodeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheHeartbeatSample(NodeHeartbeatSample newHeartbeatSample) {
        LinkedList<NodeHeartbeatSample> linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.isEmpty() || this.slidingWindow.getLast().getSendTimestamp() < newHeartbeatSample.getSendTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.removeFirst();
            }
        }
    }

    public boolean periodicUpdate() {
        this.updateCurrentStatistics();
        if (!this.currentStatistics.equals(this.previousStatistics)) {
            this.previousStatistics = this.currentStatistics.deepCopy();
            return true;
        }
        return false;
    }

    public void forceUpdate(NodeHeartbeatSample newHeartbeatSample) {
        this.cacheHeartbeatSample(newHeartbeatSample);
        this.updateCurrentStatistics();
    }

    protected abstract void updateCurrentStatistics();

    public long getLoadScore() {
        return this.currentStatistics.getLoadScore();
    }

    public NodeStatus getNodeStatus() {
        return NodeStatus.parse((String)this.currentStatistics.getStatus().getStatus());
    }

    public String getNodeStatusWithReason() {
        if (this.currentStatistics.getStatusReason() == null) {
            return this.currentStatistics.getStatus().getStatus();
        }
        return this.currentStatistics.getStatus().getStatus() + "(" + this.currentStatistics.getStatusReason() + ")";
    }

    public NodeStatistics getStatistics() {
        return this.currentStatistics;
    }
}

